/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class DoubleColumnVector
extends ColumnVector {
    public static final long NULL_VALUE = 1L;
    public double[] vector;

    public DoubleColumnVector(IDataType dType, boolean isSorted, int vectorSize) {
        super(dType, isSorted, vectorSize);
        this.vector = new double[vectorSize];
        this.noNulls = true;
    }

    public void set(int index, double value) {
        this.vector[index] = value;
        this.isNull[index] = false;
    }

    @Override
    public void complete(int nValues) {
        if (!this.isSorted) {
            return;
        }
        this.isRepeating = this.isNull[0] || this.isNull[nValues - 1] ? this.isNull[0] && this.isNull[nValues - 1] : this.vector[0] == this.vector[nValues - 1];
    }

    @Override
    public void copyFrom(int dstIndex, ColumnVector srcVector, int inSrcIndex) {
        int srcIndex = inSrcIndex;
        if (srcVector.isRepeating) {
            srcIndex = 0;
        }
        if (srcVector.isNull[srcIndex]) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        }
        this.vector[dstIndex] = srcVector.getDouble(srcIndex);
    }

    @Override
    public void assign(int index, IValue value) {
        if (value.isNull()) {
            this.isNull[index] = true;
            this.noNulls = false;
        } else {
            this.vector[index] = ((Value)value).getDouble();
        }
    }

    @Override
    public void assign(int index, Object value) {
        if (value == null) {
            this.isNull[index] = true;
            this.noNulls = false;
            return;
        }
        this.vector[index] = value instanceof String ? Double.valueOf((String)value).doubleValue() : ((Number)value).doubleValue();
    }

    @Override
    public void assign(int dstIndex, ColumnVector srcVector, int inSrcIndex) {
        int srcIndex = inSrcIndex;
        if (srcVector.isRepeating) {
            srcIndex = 0;
        }
        if (srcVector.isNull[srcIndex]) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        }
        this.vector[dstIndex] = ((DoubleColumnVector)srcVector).vector[srcIndex];
    }

    @Override
    public void vectorCopyImpl(ColumnVector srcVector, int size) {
        double[] inputVector = ((DoubleColumnVector)srcVector).vector;
        if (this.isRepeating) {
            this.vector[0] = inputVector[0];
        } else {
            System.arraycopy(inputVector, 0, this.vector, 0, size);
        }
    }

    public void fill(double value) {
        this.noNulls = true;
        this.isRepeating = true;
        this.vector[0] = value;
    }

    public void copySelected(boolean selectedInUse, int[] selected, int size, DoubleColumnVector output) {
        int i;
        int j;
        output.noNulls = this.noNulls;
        output.isRepeating = false;
        if (this.isRepeating) {
            output.vector[0] = this.vector[0];
            output.isNull[0] = this.isNull[0];
            output.isRepeating = true;
            return;
        }
        if (selectedInUse) {
            for (j = 0; j < size; ++j) {
                i = selected[j];
                output.vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, output.vector, 0, size);
        }
        if (!this.noNulls) {
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = selected[j];
                    output.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output.isNull, 0, size);
            }
        }
    }

    @Override
    public Object getObject(int index) {
        return this.vector[index];
    }

    @Override
    public byte[] getBytes(int index) {
        return ColumnVector.longToByteArray(Double.doubleToRawLongBits(this.vector[index]));
    }

    @Override
    public long getLong(int index) {
        return (long)this.vector[index];
    }

    @Override
    public float getFloat(int index) throws ValueConversionException {
        double value = this.vector[index];
        double absValue = Math.abs(value);
        if (absValue >= 3.4028234663852886E38) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "double", Double.toString(value), "float");
        }
        return (float)value;
    }

    @Override
    public double getDouble(int index) {
        return this.vector[index];
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return BigDecimal.valueOf(this.vector[index]);
    }

    @Override
    public BigDecimal getBigDecimal(int index, int precision, int scale) {
        BigDecimal decimalValue = new BigDecimal(Double.toString(this.vector[index]), new MathContext(precision, RoundingMode.HALF_DOWN));
        return decimalValue.setScale(scale, RoundingMode.HALF_DOWN);
    }

    @Override
    public String getString(int index) {
        if (this.isNull[index]) {
            return null;
        }
        return Double.toString(this.vector[index]);
    }

    @Override
    public boolean equals(int index1, int index2) {
        if (this.isRepeating) {
            return true;
        }
        if (this.isNull[index1] && this.isNull[index2]) {
            return true;
        }
        if (this.isNull[index1] || this.isNull[index2]) {
            return false;
        }
        return this.vector[index1] == this.vector[index2];
    }

    @Override
    public boolean equals(int i1, ColumnVector v2, int i2) {
        DoubleColumnVector otherVector = (DoubleColumnVector)v2;
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && otherVector.isNull[index2]) {
            return true;
        }
        if (this.isNull[index1] || otherVector.isNull[index2]) {
            return false;
        }
        return this.vector[index1] == otherVector.vector[index2];
    }

    @Override
    public boolean equals(int index, Object value) {
        return this.vector[index] == ((Number)value).doubleValue();
    }

    @Override
    public int compare(int index1, int index2) {
        if (this.isRepeating) {
            return 0;
        }
        if (this.isNull[index1] && this.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (this.isNull[index2]) {
            return 1;
        }
        if (this.vector[index1] > this.vector[index2]) {
            return 1;
        }
        if (this.vector[index1] == this.vector[index2]) {
            return 0;
        }
        return -1;
    }

    @Override
    public int compare(int i1, ColumnVector v2, int i2) {
        DoubleColumnVector otherVector = (DoubleColumnVector)v2;
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && otherVector.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (otherVector.isNull[index2]) {
            return 1;
        }
        if (this.vector[index1] > otherVector.vector[index2]) {
            return 1;
        }
        if (this.vector[index1] == otherVector.vector[index2]) {
            return 0;
        }
        return -1;
    }

    @Override
    public int compareWithImplicitCast(int i1, ColumnVector v2, int i2) {
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && v2.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (v2.isNull[index2]) {
            return 1;
        }
        double otherValue = v2.getDouble(index2);
        if (this.vector[index1] > otherValue) {
            return 1;
        }
        if (this.vector[index1] == otherValue) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean copyValue(int sIndex, int tIndex, ColumnVector targetVector, boolean addValue) {
        if (!(targetVector instanceof DoubleColumnVector)) {
            return false;
        }
        int sourceIndex = sIndex;
        int targetIndex = tIndex;
        DoubleColumnVector target = (DoubleColumnVector)targetVector;
        if (this.isRepeating) {
            sourceIndex = 0;
        }
        if (targetVector.isRepeating) {
            if (!this.isNull[sourceIndex] && !target.isNull[0] && this.vector[sourceIndex] == target.vector[0]) {
                return true;
            }
            if (this.isNull[sourceIndex] && target.isNull[0]) {
                return true;
            }
            if (targetIndex > 0) {
                if (addValue) {
                    targetVector.materializeRepeatingValues(targetIndex - 1);
                } else {
                    targetVector.materializeRepeatingValues(target.vector.length - 1);
                }
            }
        }
        targetVector.isRepeating = false;
        target.vector[targetIndex] = this.vector[sourceIndex];
        target.isNull[targetIndex] = this.isNull[sourceIndex];
        if (target.isNull[targetIndex]) {
            target.noNulls = false;
        }
        return true;
    }

    @Override
    protected boolean materializeRepeatingValues(int size) {
        if (this.isRepeating) {
            for (int i = 1; i <= size; ++i) {
                this.vector[i] = this.vector[0];
                this.isNull[i] = this.isNull[0];
            }
            return true;
        }
        return false;
    }

    @Override
    public ColumnVector copy(int size) {
        DoubleColumnVector copy = new DoubleColumnVector(this.dataType, this.isSorted, this.vector.length);
        copy.isRepeating = this.isRepeating;
        copy.noNulls = this.noNulls;
        if (this.isRepeating) {
            copy.vector[0] = this.vector[0];
            copy.isNull[0] = this.isNull[0];
        } else {
            for (int i = 0; i < this.vector.length; ++i) {
                copy.vector[i] = this.vector[i];
                copy.isNull[i] = this.isNull[i];
            }
        }
        return copy;
    }

    @Override
    public void expandImpl(int size) {
        double[] newVector = new double[this.vector.length + size];
        System.arraycopy(this.vector, 0, newVector, 0, this.vector.length);
        this.vector = newVector;
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream, int size, int[] selected) throws IOException {
        block11: {
            block10: {
                super.encode(context, oStream, size, selected);
                if (!this.isRepeating) break block10;
                if (this.isNull[0]) break block11;
                oStream.writeDouble(this.vector[0]);
                break block11;
            }
            if (selected != null) {
                if (this.noNulls) {
                    for (int i = 0; i < size; ++i) {
                        oStream.writeDouble(this.vector[selected[i]]);
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        if (this.isNull[selected[i]]) continue;
                        oStream.writeDouble(this.vector[selected[i]]);
                    }
                }
            } else if (this.noNulls) {
                for (int i = 0; i < size; ++i) {
                    oStream.writeDouble(this.vector[i]);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (this.isNull[i]) continue;
                    oStream.writeDouble(this.vector[i]);
                }
            }
        }
    }

    @Override
    public int decode(XDataContext context, DataInput iStream) throws IOException {
        int size;
        block5: {
            block4: {
                size = super.decode(context, iStream);
                if (!this.isRepeating) break block4;
                if (this.isNull[0]) break block5;
                this.vector[0] = iStream.readDouble();
                break block5;
            }
            if (this.noNulls) {
                for (int i = 0; i < size; ++i) {
                    this.vector[i] = iStream.readDouble();
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (this.isNull[i]) continue;
                    this.vector[i] = iStream.readDouble();
                }
            }
        }
        return size;
    }

    @Override
    public int sizeOf() {
        int result = super.sizeOf();
        return result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEDOUBLE) * this.vector.length;
    }

    @Override
    public int hashCode(int i) {
        int index = i;
        if (this.isRepeating) {
            index = 0;
        }
        if (this.isNull[index]) {
            return Integer.MIN_VALUE;
        }
        return Double.hashCode(this.vector[index]);
    }

    @Override
    public void getValue(int index, Value value) {
        value.setFormatId(this.formatId);
        if (this.isNull[index]) {
            value.setNull();
        } else {
            value.set(this.vector[index]);
        }
    }

    @Override
    public void valueToXMLStringImpl(XMLWriter writer, int index) {
        writer.attribute("v", String.valueOf(this.vector[index]));
    }
}

