/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntervalValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampUtil;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class IntervalColumnVector
extends ColumnVector {
    private static final int NFIELDS_YM_INTERVAL = 2;
    private static final int NFIELDS_DT_INTERVAL = 5;
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 0;
    public static final int HOUR = 1;
    public static final int MINUTE = 2;
    public static final int SECOND = 3;
    public static final int NANOSECONDS = 4;
    protected int sign = 1;
    public IntervalStruct[] vector;
    private int nFields;

    public IntervalColumnVector(IDataType dType, boolean isSorted, int vectorSize) {
        super(dType, isSorted, vectorSize);
        this.vector = new IntervalStruct[vectorSize];
        this.nFields = dType.getCCLTypeCode() == 60 ? 5 : 2;
        for (int i = 0; i < vectorSize; ++i) {
            this.vector[i] = new IntervalStruct(dType, this.nFields);
        }
        this.noNulls = true;
    }

    @Override
    public void complete(int nValues) {
        if (!this.isSorted) {
            return;
        }
        this.isRepeating = this.isNull[0] || this.isNull[nValues - 1] ? this.isNull[0] && this.isNull[nValues - 1] : this.vector[0].compareTo(this.vector[nValues - 1]) == 0;
    }

    @Override
    public void copyFrom(int dstIndex, ColumnVector srcVector, int inSrcIndex) {
        int srcIndex = inSrcIndex;
        if (srcVector.isRepeating) {
            srcIndex = 0;
        }
        if (srcVector.isNull[srcIndex]) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        }
        this.vector[dstIndex].copyFrom(((IntervalColumnVector)srcVector).vector[srcIndex]);
    }

    @Override
    public void assign(int index, IValue value) {
        if (value.isNull()) {
            this.isNull[index] = true;
            this.noNulls = false;
            return;
        }
        this.vector[index].sign = ((IntervalValue)value).getSign();
        int[] fields = this.vector[index].fields;
        int[] otherFields = ((IntervalValue)value).getFields();
        System.arraycopy(otherFields, 0, fields, 0, fields.length);
    }

    @Override
    public void assign(int index, Object value) {
        if (value == null) {
            this.isNull[index] = true;
            this.noNulls = false;
            return;
        }
        IntervalValue valueObj = this.dataType.getCCLTypeCode() == 17 ? DataValueFactory.createIntervalYearMonthValue((IntervalYearMonthType)this.dataType) : DataValueFactory.createIntervalDayTimeValue((IntervalDayTimeType)this.dataType);
        valueObj.set((String)value);
        this.assign(index, valueObj);
    }

    @Override
    public void assign(int dstIndex, ColumnVector srcVector, int inSrcIndex) {
        int srcIndex = inSrcIndex;
        if (srcVector.isRepeating) {
            srcIndex = 0;
        }
        if (srcVector.isNull[srcIndex]) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        }
        this.vector[dstIndex].copyFrom(((IntervalColumnVector)srcVector).vector[srcIndex]);
    }

    @Override
    public void vectorCopyImpl(ColumnVector srcVector, int size) {
        IntervalStruct[] inputVector = ((IntervalColumnVector)srcVector).vector;
        if (this.isRepeating) {
            this.vector[0] = inputVector[0];
        } else {
            System.arraycopy(inputVector, 0, this.vector, 0, size);
        }
    }

    public void set(int index, IntervalStruct intervalValue) {
        this.vector[index].copyFrom(intervalValue);
    }

    public void add(int index, int field, int value) {
        int[] fields = this.vector[index].fields;
        switch (field) {
            case 1: {
                fields[0] = fields[0] + value;
                break;
            }
            case 2: {
                fields[1] = fields[1] + value;
                break;
            }
            case 5: {
                fields[0] = fields[0] + value;
                break;
            }
            case 10: {
                fields[1] = fields[1] + value;
                break;
            }
            case 12: {
                fields[2] = fields[2] + value;
                break;
            }
            case 13: {
                fields[3] = fields[3] + value;
                break;
            }
        }
    }

    public void addNanoseconds(int index, int value) {
        this.vector[index].fields[4] = this.vector[index].fields[4] + value;
    }

    @Override
    public Object getObject(int index) {
        if (this.isNull[index]) {
            return null;
        }
        return this.vector[index];
    }

    @Override
    public byte[] getBytes(int index) {
        throw new UnsupportedOperationException();
    }

    public void fill(IntervalStruct value) {
        this.noNulls = true;
        this.isRepeating = true;
        this.vector[0] = value;
    }

    @Override
    public boolean equals(int index1, int index2) {
        if (this.isRepeating) {
            return true;
        }
        if (this.isNull[index1] && this.isNull[index2]) {
            return true;
        }
        if (this.isNull[index1] || this.isNull[index2]) {
            return false;
        }
        return this.vector[index1].equals(this.vector[index2]);
    }

    @Override
    public boolean equals(int i1, ColumnVector v2, int i2) {
        IntervalColumnVector otherVector = (IntervalColumnVector)v2;
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && otherVector.isNull[index2]) {
            return true;
        }
        if (this.isNull[index1] || otherVector.isNull[index2]) {
            return false;
        }
        return this.vector[index1].equals(otherVector.vector[index2]);
    }

    @Override
    public boolean equals(int i, Object value) {
        return false;
    }

    @Override
    public int compare(int index1, int index2) {
        if (this.isRepeating) {
            index1 = 0;
        }
        if (this.isNull[index1] && this.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (this.isNull[index2]) {
            return 1;
        }
        return this.vector[index1].compareTo(this.vector[index2]);
    }

    @Override
    public int compare(int i1, ColumnVector v2, int i2) {
        IntervalColumnVector otherVector = (IntervalColumnVector)v2;
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && otherVector.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (otherVector.isNull[index2]) {
            return 1;
        }
        return this.vector[index1].compareTo(otherVector.vector[index2]);
    }

    @Override
    public int compareWithImplicitCast(int i1, ColumnVector v2, int i2) {
        return this.compare(i1, v2, i2);
    }

    @Override
    public boolean copyValue(int sIndex, int tIndex, ColumnVector targetVector, boolean addValue) {
        int sourceIndex = sIndex;
        int targetIndex = tIndex;
        IntervalColumnVector target = (IntervalColumnVector)targetVector;
        if (this.isRepeating) {
            sourceIndex = 0;
        }
        if (targetVector.isRepeating) {
            if (!this.isNull[sourceIndex] && !target.isNull[0] && this.vector[sourceIndex].compareTo(target.vector[0]) == 0) {
                return true;
            }
            if (this.isNull[sourceIndex] && target.isNull[0]) {
                return true;
            }
            if (targetIndex > 0) {
                if (addValue) {
                    targetVector.materializeRepeatingValues(targetIndex - 1);
                } else {
                    targetVector.materializeRepeatingValues(target.vector.length - 1);
                }
            }
        }
        targetVector.isRepeating = false;
        target.vector[targetIndex].copyFrom(this.vector[sourceIndex]);
        target.isNull[targetIndex] = this.isNull[sourceIndex];
        if (target.isNull[targetIndex]) {
            target.noNulls = false;
        }
        return true;
    }

    public void copySelected(boolean selectedInUse, int[] selected, int size, IntervalColumnVector output) {
        int i;
        int j;
        output.noNulls = this.noNulls;
        output.isRepeating = false;
        if (this.isRepeating) {
            output.vector[0] = this.vector[0];
            output.isNull[0] = this.isNull[0];
            output.isRepeating = true;
            return;
        }
        if (selectedInUse) {
            for (j = 0; j < size; ++j) {
                i = selected[j];
                output.vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, output.vector, 0, size);
        }
        if (!this.noNulls) {
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = selected[j];
                    output.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output.isNull, 0, size);
            }
        }
    }

    @Override
    protected boolean materializeRepeatingValues(int size) {
        if (this.isRepeating) {
            for (int i = 1; i <= size; ++i) {
                this.vector[i].copyFrom(this.vector[0]);
                this.isNull[i] = this.isNull[0];
            }
            return true;
        }
        return false;
    }

    @Override
    public ColumnVector copy(int size) {
        IntervalColumnVector copy = new IntervalColumnVector(this.dataType, this.isSorted, this.vector.length);
        copy.isRepeating = this.isRepeating;
        copy.noNulls = this.noNulls;
        if (this.isRepeating) {
            copy.vector[0].copyFrom(this.vector[0]);
            copy.isNull[0] = this.isNull[0];
        } else {
            for (int i = 0; i < this.vector.length; ++i) {
                copy.vector[i].copyFrom(this.vector[i]);
                copy.isNull[i] = this.isNull[i];
            }
        }
        return copy;
    }

    @Override
    public void expandImpl(int size) {
        IntervalStruct[] newVector = new IntervalStruct[this.vector.length + size];
        for (int i = 0; i < newVector.length; ++i) {
            newVector[i] = new IntervalStruct(this.dataType, this.nFields);
        }
        System.arraycopy(this.vector, 0, newVector, 0, this.vector.length);
        this.vector = newVector;
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream, int size, int[] selected) throws IOException {
        block11: {
            block10: {
                super.encode(context, oStream, size, selected);
                if (!this.isRepeating) break block10;
                if (this.isNull[0]) break block11;
                this.vector[0].encode(context, oStream);
                break block11;
            }
            if (selected != null) {
                if (this.noNulls) {
                    for (int i = 0; i < size; ++i) {
                        int j = selected[i];
                        this.vector[j].encode(context, oStream);
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        int j = selected[i];
                        if (this.isNull[j]) continue;
                        this.vector[j].encode(context, oStream);
                    }
                }
            } else if (this.noNulls) {
                for (int i = 0; i < size; ++i) {
                    this.vector[i].encode(context, oStream);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (this.isNull[i]) continue;
                    this.vector[i].encode(context, oStream);
                }
            }
        }
    }

    @Override
    public int decode(XDataContext context, DataInput iStream) throws IOException {
        int size;
        block5: {
            block4: {
                size = super.decode(context, iStream);
                if (!this.isRepeating) break block4;
                if (this.isNull[0]) break block5;
                this.vector[0].decode(context, iStream);
                break block5;
            }
            if (this.noNulls) {
                for (int i = 0; i < size; ++i) {
                    this.vector[i].decode(context, iStream);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (this.isNull[i]) continue;
                    this.vector[i].decode(context, iStream);
                }
            }
        }
        return size;
    }

    @Override
    public int sizeOf() {
        int result = super.sizeOf();
        result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINT) * (this.nFields + 1) * this.vector.length;
        return result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINT) * 2;
    }

    @Override
    public int hashCode(int ind) {
        int index = ind;
        if (this.isRepeating) {
            index = 0;
        }
        if (this.isNull[index]) {
            return Integer.MIN_VALUE;
        }
        return Arrays.hashCode(this.vector[index].fields);
    }

    @Override
    public void getValue(int index, Value value) {
        value.setFormatId(this.formatId);
        if (this.isNull[index]) {
            value.setNull();
        } else {
            ((IntervalValue)value).set(this.vector[index]);
        }
    }

    @Override
    public void valueToXMLStringImpl(XMLWriter writer, int i) {
    }

    public static class IntervalStruct
    implements Comparable<IntervalStruct>,
    IEncodable {
        public int sign;
        public int[] fields;
        public IDataType dataType;

        public IntervalStruct(IDataType dType, int nFields) {
            this.dataType = dType;
            this.sign = 1;
            this.fields = new int[nFields];
        }

        public IntervalStruct(IDataType dType, int theSign, int[] theFields) {
            this.dataType = dType;
            this.sign = theSign;
            this.fields = theFields;
        }

        public IntervalStruct(int theSign, int[] theFields) {
            this.sign = theSign;
            this.fields = theFields;
        }

        public void set(int theSign, int years, int months) {
            this.sign = theSign;
            this.fields[0] = years;
            this.fields[1] = months;
        }

        public void set(int theSign, int day, int hour, int minute, int second, int nanoseconds) {
            this.sign = theSign;
            this.fields[0] = day;
            this.fields[1] = hour;
            this.fields[2] = minute;
            this.fields[3] = second;
            this.fields[4] = nanoseconds;
        }

        public void normalize() {
            TimestampUtil.normalize(this.dataType, this.sign, this.fields);
        }

        public boolean equals(IntervalStruct iStruct) {
            if (this.sign != iStruct.sign) {
                return false;
            }
            IntervalStruct iStruct1 = this.copyAndNormalize(this.dataType);
            IntervalStruct iStruct2 = iStruct.copyAndNormalize(this.dataType);
            return Arrays.equals(iStruct1.fields, iStruct2.fields);
        }

        @Override
        public int compareTo(IntervalStruct iStruct) {
            if (this.sign > 0 && iStruct.sign < 0) {
                return 1;
            }
            if (this.sign < 0 && iStruct.sign > 0) {
                return -1;
            }
            IntervalStruct iStruct1 = this.copyAndNormalize(this.dataType);
            IntervalStruct iStruct2 = iStruct.copyAndNormalize(this.dataType);
            int nFields = iStruct1.fields.length;
            for (int i = 0; i < nFields; ++i) {
                if (iStruct1.fields[i] > iStruct2.fields[i]) {
                    return 1 * this.sign;
                }
                if (iStruct1.fields[i] >= iStruct2.fields[i]) continue;
                return -1 * this.sign;
            }
            return 0;
        }

        private IntervalStruct copyAndNormalize(IDataType dataType) {
            int nFields = this.fields.length;
            IntervalStruct iStruct2 = new IntervalStruct(dataType, nFields);
            iStruct2.sign = this.sign;
            System.arraycopy(this.fields, 0, iStruct2.fields, 0, nFields);
            TimestampUtil.normalize(dataType, nFields, iStruct2.fields);
            return iStruct2;
        }

        public IntervalStruct copy() {
            IntervalStruct is = new IntervalStruct(this.dataType, this.fields.length);
            is.copyFrom(this);
            return is;
        }

        public void copyFrom(IntervalStruct iStruct) {
            this.sign = iStruct.sign;
            System.arraycopy(iStruct.fields, 0, this.fields, 0, this.fields.length);
        }

        public boolean isYearMonthInterval() {
            return this.fields.length == 2;
        }

        @Override
        public void encode(XDataContext context, DataOutput oStream) throws IOException {
            oStream.writeByte(this.sign);
            for (int i = 0; i < this.fields.length; ++i) {
                oStream.writeInt(this.fields[i]);
            }
        }

        @Override
        public void decode(XDataContext context, DataInput iStream) throws IOException {
            this.sign = iStream.readByte();
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = iStream.readInt();
            }
        }

        @Override
        public int sizeOf() {
            return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINT) * (this.fields.length + 1);
        }

        public String toString() {
            return TimestampUtil.getIntervalString(this.dataType, this.sign, this.fields);
        }
    }
}

