/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.NCharType;
import com.cognos.xqe.data.types.NVarcharType;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.ibm.icu.text.Collator;

public class NFDStringColumnVector
extends StringColumnVector {
    public NFDStringColumnVector(IDataType dType, boolean sorted, int vectorSize, Collator c) {
        super(dType, sorted, vectorSize, c);
    }

    @Override
    public boolean equals(int i1, int i2) {
        if (this.isRepeating) {
            return true;
        }
        if (this.isNull[i1] && this.isNull[i2]) {
            return true;
        }
        if (this.isNull[i1] || this.isNull[i2]) {
            return false;
        }
        return this.compare(this.vector[i1], this.vector[i2], this.getDataType(), this.getDataType()) == 0;
    }

    @Override
    public boolean equals(int i1, ColumnVector v2, int i2) {
        StringColumnVector otherVector = (StringColumnVector)v2;
        if (!otherVector.isNormalized()) {
            return super.equals(i1, v2, i2);
        }
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && otherVector.isNull[index2]) {
            return true;
        }
        if (this.isNull[index1] || otherVector.isNull[index2]) {
            return false;
        }
        return this.compare(this.vector[index1], otherVector.vector[index2], this.getDataType(), otherVector.getDataType()) == 0;
    }

    @Override
    public boolean equals(int index, Object value) {
        return this.compare(this.vector[index], (String)value, this.getDataType(), this.getDataType()) == 0;
    }

    private int compare(String value1, String value2, IDataType thisDT, IDataType otherDT) {
        if ((thisDT instanceof CharType || thisDT instanceof VarcharType || thisDT instanceof NCharType || thisDT instanceof NVarcharType) && (otherDT instanceof CharType || otherDT instanceof VarcharType || otherDT instanceof NCharType || otherDT instanceof NVarcharType)) {
            int thisLength;
            int pLength = value1.length();
            if (pLength < (thisLength = value2.length())) {
                value1 = NFDStringColumnVector.padWhitespace(value1, thisLength);
            } else if (pLength > thisLength) {
                value2 = NFDStringColumnVector.padWhitespace(value2, pLength);
            }
        }
        return value1.compareTo(value2);
    }

    @Override
    protected StringColumnVector newInstance() {
        return new NFDStringColumnVector(this.dataType, this.isSorted, this.vector.length, this.collator);
    }

    @Override
    public int hashCode(int i) {
        int index = i;
        if (this.isRepeating) {
            index = 0;
        }
        if (this.hashCodes[index] == Integer.MIN_VALUE && !this.isNull[index]) {
            this.hashCodes[index] = this.vector[index].hashCode();
        }
        return this.hashCodes[index];
    }

    @Override
    public boolean isNormalized() {
        return true;
    }
}

