/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import java.util.List;
import org.dom4j.Element;

public class XVectorCondense
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorCondenseResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501203;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List elements = inputNode.elements();
        this.vContext = new XVectorContext();
        this.vContext.capture(env, (Element)elements.get(0));
        this.capture(env, inputNode, elements.size() - 1);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }

    private final class XVectorCondenseResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;

        XVectorCondenseResultSet(XDataContext context) {
            super(context, XVectorCondense.this.getId());
            try {
                this.iResultSet = (IHybridResultSet)((IExecutable)((Object)XVectorCondense.this.getChild(0))).execute(context);
                this.rowsetInfo = this.iResultSet.getTabularRowsetInfo();
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public IScrollableIterator getScrollableTabularIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorCondenseIterator(this.getDataContext(), this.iResultSet);
        }

        @Override
        public XVectorContext getVectorizationContext() {
            return XVectorCondense.this.vContext;
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.rowsetInfo = null;
        }

        private final class XVectorCondenseIterator
        extends XVectorTabularIterator {
            private ITabularIterator tabIt;
            private XVectorRowBatch inputBatch;
            private boolean eod;

            private XVectorCondenseIterator(XDataContext context, ITabularResultSet resultSet) {
                super(context, XVectorCondense.this.getId(), XVectorCondenseResultSet.this.rowsetInfo);
                this.eod = false;
                try {
                    this.startTimer();
                    this.tabIt = resultSet.getTabularIterator();
                    this.batch = XVectorRowBatchUtil.createRowBatch(XVectorCondense.this.vContext, XVectorCondenseResultSet.this.rowsetInfo, context.getLocalCollator());
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                this.batch.reset();
                if (this.eod) {
                    this.batch.eod = true;
                } else {
                    while (this.batch.size != this.batch.maxBatchSize) {
                        if (this.inputBatch == null || this.inputBatch.index++ == this.inputBatch.size) {
                            this.inputBatch = (XVectorRowBatch)this.tabIt.nextBatch();
                            if (this.inputBatch.eod) {
                                this.eod = true;
                                break;
                            }
                            this.inputBatch.index = 0;
                        }
                        XVectorRowBatchUtil.copyRow(this.inputBatch.selected[this.inputBatch.index], this.inputBatch, this.batch.size++, this.batch, false);
                    }
                    if (this.eod && this.batch.size == 0) {
                        this.batch.eod = true;
                    }
                }
                return this.batch;
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                super.release();
            }

            @Override
            public Object getVectorizationContext() {
                return XVectorCondense.this.vContext;
            }
        }
    }
}

