/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IntervalValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.VectorOp;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.expressions.XVectorCoalesce;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorCharLength;
import com.cognos.xqe.runtree.relational.vectorization.expressions.character.XVectorTrim;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorBloomFilter;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterInListDecimal;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterInListDouble;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterInListLong;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterInListString;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterIsNotNull;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterIsNull;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterLikeColumnScalar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterLogicalAnd;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorFilterLogicalOr;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateCount;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateCountStar;
import com.cognos.xqe.runtree.relational.vectorization.expressions.set.XVectorAggregateSumDecimal;
import com.cognos.xqe.trace.XQETrace;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XVectorContext {
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String ATTRIBUTE_COLUMNS = "columns";
    private static final String ATTRIBUTE_SCRATCHCOLUMNS = "scratchColumns";
    private static final String ATTRIBUTE_DATATYPE = "dataType";
    private static final String ELEMENT_SCRATCHCOLUMNS = "ScratchColumns";
    private static final String ELEMENT_SCRATCHCOLUMN = "ScratchColumn";
    private static final ConcurrentMap<String, Class<?>> NAME_TO_CLASS_MAP = new ConcurrentHashMap();
    private OutputColumnManager ocm;

    public XVectorContext() {
        this.ocm = new OutputColumnManager(0);
    }

    public XVectorContext(int nColumns) {
        this.ocm = new OutputColumnManager(nColumns);
    }

    public XVectorContext(int nColumns, XVectorContext vContext) {
        this.ocm = vContext.ocm;
    }

    public int allocateOutputColumn(IDataType columnType) {
        return this.ocm.allocateOutputColumn(columnType);
    }

    public Map<Integer, IDataType> getScratchColumnTypeMap() {
        HashMap<Integer, IDataType> map = new HashMap<Integer, IDataType>();
        for (int i = 0; i < this.ocm.nScratchColumns; ++i) {
            IDataType dType = this.ocm.scratchColumnTypes[i];
            map.put(i + this.ocm.firstScratchColumnNo, dType);
        }
        return map;
    }

    public static XVectorExpression createVectorExpression(IPlanningEnvironment environment, XVectorContext vContext, Class<?> clazz, VectorOp vectorOp, IDataType returnType, Object[] arguments) {
        XQEIDGenerator nodeIdGenerator = environment.getNodeFactory().getNodeIdGenerator();
        XVectorExpression vExpr = null;
        Constructor<?> ctor = XVectorContext.getConstructor(clazz, arguments, vectorOp);
        int numParams = ctor.getParameterTypes().length;
        int argsLength = 0;
        if (arguments != null) {
            argsLength = arguments.length;
        }
        try {
            if (numParams == 0) {
                vExpr = (XVectorExpression)ctor.newInstance(new Object[0]);
            } else if (numParams == argsLength) {
                vExpr = (XVectorExpression)ctor.newInstance(arguments);
            } else if (numParams == argsLength + 1) {
                Object[] newArgs = null;
                int outputCol = vContext.allocateOutputColumn(returnType);
                newArgs = Arrays.copyOf(arguments, numParams);
                newArgs[numParams - 1] = outputCol;
                vExpr = (XVectorExpression)ctor.newInstance(newArgs);
            }
            vExpr.setNodeId(nodeIdGenerator.getNextID());
            vExpr.setPlanningEnvironment(environment);
            vExpr.setDataType(returnType);
            return vExpr;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not instantiate " + clazz.getSimpleName() + ", exception: " + ex);
        }
    }

    public static int generateCast(IPlanningEnvironment environment, XVectorContext vContext, IXQEQueryNode child, IDataType returnType) {
        Object[] arguments = new Object[]{((XVectorExpression)child).getColumnNo()};
        Class<?> clazz = SQLCast.getVectorClass(((IValueExpression)child).getDataType(), returnType);
        XVectorExpression vExpr = XVectorContext.createVectorExpression(environment, vContext, clazz, VectorOp.MAP, returnType, arguments);
        child.insertParent(vExpr);
        return vExpr.getColumnNo();
    }

    public static void generateCast(IPlanningEnvironment environment, XVectorContext vContext, IXQEQueryNode child, Class<?> clazz, IDataType returnType) {
        if (child.getType() == 301031) {
            SQLLiteral literalNode = (SQLLiteral)child;
            literalNode.setDataType(returnType);
            literalNode.setValue(literalNode.getValue().getString());
        } else {
            Object[] arguments = new Object[]{child.getType() == 301032 ? Integer.valueOf(((SQLFid)child).getVirtualColumnNo()) : Integer.valueOf(((XVectorExpression)child).getColumnNo())};
            XVectorExpression vExpr = XVectorContext.createVectorExpression(environment, vContext, clazz, VectorOp.MAP, returnType, arguments);
            if (child.getType() == 301032) {
                child.exchange(vExpr);
            } else {
                child.insertParent(vExpr);
            }
        }
    }

    public static Object getObjectForLiteral(SQLLiteral literal) {
        IDataType dType = literal.getDataType();
        Value value = literal.getValue();
        switch (dType.getCCLTypeCode()) {
            case 57: {
                return ((DateValue)value).getMilliseconds();
            }
            case 58: 
            case 59: {
                return new TimestampColumnVector.UnixTimestamp(dType.getCCLTypeCode(), ((DateTimeValue)value).getMilliseconds(), ((DateTimeValue)value).getNanoseconds());
            }
            case 52: 
            case 53: {
                return new TimestampColumnVector.UnixTimestamp(dType.getCCLTypeCode(), ((DateTimeValue)value).getMilliseconds(), ((DateTimeValue)value).getNanoseconds(), ((DateTimeValue)value).getTimeZone().getRawOffset());
            }
            case 17: 
            case 60: {
                return new IntervalColumnVector.IntervalStruct(dType, ((IntervalValue)value).getSign(), ((IntervalValue)value).getFields());
            }
            case 2: 
            case 4: 
            case 6: {
                return ((Number)value.getObject()).longValue();
            }
        }
        return value.getObject();
    }

    private static Constructor<?> getConstructor(Class<?> clazz, Object[] arguments, VectorOp vectorOp) {
        try {
            Constructor<?>[] ctors = clazz.getDeclaredConstructors();
            if (ctors.length == 1) {
                return ctors[0];
            }
            Constructor<?> defaultCtor = clazz.getConstructor(new Class[0]);
            for (Constructor<?> ctor : ctors) {
                if (ctor.getParameterTypes().length != arguments.length + 1) continue;
                return ctor;
            }
            for (Constructor<?> ctor : ctors) {
                if (ctor.getParameterTypes().length != arguments.length) continue;
                return ctor;
            }
            return defaultCtor;
        }
        catch (Exception e) {
            throw new XQERuntimeException(e);
        }
    }

    public static IXQEQueryNode getNodeByName(String name) {
        if (name == null) {
            return null;
        }
        Class<?> clazz = (Class<?>)NAME_TO_CLASS_MAP.get(name);
        if (clazz == null) {
            try {
                String className = "com.cognos.xqe.runtree.relational.vectorization.expressions.generated." + name;
                clazz = Class.forName(className);
                NAME_TO_CLASS_MAP.putIfAbsent(className, clazz);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        try {
            return (IXQEQueryNode)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new XQERuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new XQERuntimeException(e);
        }
    }

    public static String getTypeName(IValueExpression exprNode) {
        return XVectorContext.getTypeName(exprNode.getDataType());
    }

    public static String getTypeName(IDataType dataType) {
        return XVectorRowBatchUtil.getVectorTypeFromDataType(dataType).toString();
    }

    public void capture(PlanningEnvironment env, Element inputNode) {
        Element child;
        Attribute attribute = inputNode.attribute(ATTRIBUTE_COLUMNS);
        this.ocm.firstScratchColumnNo = Integer.valueOf(attribute.getText());
        List children = inputNode.elements();
        if (children.size() > 0 && (child = (Element)children.get(0)).getName().equals(ELEMENT_SCRATCHCOLUMNS)) {
            children = child.elements();
            for (Element column : children) {
                IDataType dataType = DataTypeFactory.getType(column.attribute(ATTRIBUTE_DATATYPE).getValue());
                this.ocm.allocateOutputColumn(dataType);
            }
        }
    }

    public void dumpInfo(XQETrace traceObj) {
        traceObj.beginElement(this.getClass().getSimpleName());
        traceObj.attribute(ATTRIBUTE_COLUMNS, this.ocm.firstScratchColumnNo);
        traceObj.attribute(ATTRIBUTE_SCRATCHCOLUMNS, this.ocm.nScratchColumns);
        if (this.ocm.nScratchColumns > 0) {
            traceObj.beginElement(ELEMENT_SCRATCHCOLUMNS);
            for (int i = 0; i < this.ocm.nScratchColumns; ++i) {
                traceObj.beginElement(ELEMENT_SCRATCHCOLUMN);
                IDataType dType = this.ocm.scratchColumnTypes[i];
                traceObj.attribute(ATTRIBUTE_COLUMNNO, this.ocm.firstScratchColumnNo + i);
                traceObj.attribute(ATTRIBUTE_DATATYPE, dType);
                traceObj.endElement();
            }
            traceObj.endElement();
        }
        traceObj.endElement();
    }

    static {
        NAME_TO_CLASS_MAP.put("XVectorAggregateSumDecimal", XVectorAggregateSumDecimal.class);
        NAME_TO_CLASS_MAP.put("XVectorFilterInListDecimal", XVectorFilterInListDecimal.class);
        NAME_TO_CLASS_MAP.put("XVectorFilterInListDouble", XVectorFilterInListDouble.class);
        NAME_TO_CLASS_MAP.put("XVectorFilterInListLong", XVectorFilterInListLong.class);
        NAME_TO_CLASS_MAP.put("XVectorFilterInListString", XVectorFilterInListString.class);
        NAME_TO_CLASS_MAP.put("XVectorFilterIsNotNull", XVectorFilterIsNotNull.class);
        NAME_TO_CLASS_MAP.put("XVectorFilterIsNull", XVectorFilterIsNull.class);
        NAME_TO_CLASS_MAP.put("XVectorFilterLikeColumnScalar", XVectorFilterLikeColumnScalar.class);
        NAME_TO_CLASS_MAP.put("XVectorFilterLogicalAnd", XVectorFilterLogicalAnd.class);
        NAME_TO_CLASS_MAP.put("XVectorFilterLogicalOr", XVectorFilterLogicalOr.class);
        NAME_TO_CLASS_MAP.put("XVectorCoalesce", XVectorCoalesce.class);
        NAME_TO_CLASS_MAP.put("XVectorInListDecimal", XVectorFilterInListDecimal.class);
        NAME_TO_CLASS_MAP.put("XVectorInListDouble", XVectorFilterInListDouble.class);
        NAME_TO_CLASS_MAP.put("XVectorInListLong", XVectorFilterInListLong.class);
        NAME_TO_CLASS_MAP.put("XVectorInListString", XVectorFilterInListString.class);
        NAME_TO_CLASS_MAP.put("XVectorIsNotNull", XVectorFilterIsNotNull.class);
        NAME_TO_CLASS_MAP.put("XVectorIsNull", XVectorFilterIsNull.class);
        NAME_TO_CLASS_MAP.put("XVectorLikeColumnScalar", XVectorFilterLikeColumnScalar.class);
        NAME_TO_CLASS_MAP.put("XVectorLogicalAnd", XVectorFilterLogicalAnd.class);
        NAME_TO_CLASS_MAP.put("XVectorLogicalOr", XVectorFilterLogicalOr.class);
        NAME_TO_CLASS_MAP.put("XVectorBloomFilter", XVectorBloomFilter.class);
        NAME_TO_CLASS_MAP.put("XVectorCharLength", XVectorCharLength.class);
        NAME_TO_CLASS_MAP.put("XVectorTrim", XVectorTrim.class);
        NAME_TO_CLASS_MAP.put("XVectorAggregateCount", XVectorAggregateCount.class);
        NAME_TO_CLASS_MAP.put("XVectorAggregateCountStar", XVectorAggregateCountStar.class);
    }

    private static class OutputColumnManager {
        private static final int INITIAL_SIZE = 100;
        private int firstScratchColumnNo;
        private int nScratchColumns = 0;
        private IDataType[] scratchColumnTypes = new IDataType[100];

        protected OutputColumnManager(int initialOutputCol) {
            this.firstScratchColumnNo = initialOutputCol;
        }

        public int allocateOutputColumn(IDataType columnType) {
            int newIndex = this.nScratchColumns;
            if (this.nScratchColumns < this.scratchColumnTypes.length) {
                this.scratchColumnTypes[this.nScratchColumns++] = columnType;
            } else {
                this.scratchColumnTypes = Arrays.copyOf(this.scratchColumnTypes, 2 * this.nScratchColumns);
                this.scratchColumnTypes[this.nScratchColumns++] = columnType;
            }
            return this.firstScratchColumnNo + newIndex;
        }
    }
}

