/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.concurrent.ThreadPool;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;

public class XVectorExchangeIterator
extends XVectorTabularIterator {
    private final Thread mainThread = Thread.currentThread();
    private BlockingQueue<XVectorRowBatch> queue;
    private AtomicReference<XQERuntimeException> exception = new AtomicReference();
    private ITabularIterator tabIt;
    private static final int DEFAULT_CAPACITY = 50;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public XVectorExchangeIterator(XDataContext context, ITabularIterator uIterator) {
        this(context, uIterator, 50);
    }

    public XVectorExchangeIterator(XDataContext context, ITabularIterator uIterator, int capacity) {
        this(context, new LinkedBlockingQueue<XVectorRowBatch>(capacity));
        this.tabIt = uIterator;
        ThreadPool.getInstance().submit(new Producer());
    }

    public XVectorExchangeIterator(XDataContext context, LinkedBlockingQueue<XVectorRowBatch> theQueue) {
        super(context, context.getNodeId(), null);
        this.queue = theQueue;
    }

    @Override
    public Object nextBatch() {
        XVectorRowBatch batch = null;
        try {
            batch = this.queue.take();
        }
        catch (InterruptedException e) {
            mErrorLogger.log(e);
            if (this.exception.get() != null) {
                throw this.exception.get();
            }
            batch = null;
        }
        return batch;
    }

    public boolean hasData() {
        return !this.queue.isEmpty();
    }

    @Override
    public void release() {
        super.release();
        if (this.tabIt != null) {
            this.tabIt.release();
        }
    }

    private class Producer
    implements Runnable {
        Producer() {
        }

        @Override
        public void run() {
            ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(XVectorExchangeIterator.this.context.getEnvironment());
            try {
                XVectorRowBatch batch;
                do {
                    batch = (XVectorRowBatch)XVectorExchangeIterator.this.tabIt.nextBatch();
                    XVectorExchangeIterator.this.queue.put(batch.copy());
                } while (!batch.eod);
            }
            catch (InterruptedException e) {
                mErrorLogger.log(e);
            }
            catch (XQERuntimeException e) {
                XVectorExchangeIterator.this.exception.set(e);
                XVectorExchangeIterator.this.mainThread.interrupt();
            }
            finally {
                executionEnvironmentContext.exit();
            }
        }
    }
}

