/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import org.dom4j.Element;

public class XVectorFilter
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_CONTEXTNO = "contextNo";

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorFilterResultSet(context), this.getId());
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.attribute(ATTRIBUTE_CONTEXTNO, String.valueOf(this.contextNo));
    }

    @Override
    public int getType() {
        return 501173;
    }

    public XVectorExpression getPredicate() {
        return (XVectorExpression)this.getChild(1);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List elements = inputNode.elements();
        super.capture(env, inputNode, elements.size() - 2);
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 301089) {
            return true;
        }
        return super.isOfCategory(category);
    }

    private final class XVectorFilterResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;
        private XVectorExpression predicate;

        XVectorFilterResultSet(XDataContext context) {
            super(context, XVectorFilter.this.getId());
            XVectorFilter.this.contextNo = XVectorFilter.this.getContextNo();
            this.iResultSet = (IHybridResultSet)((IExecutable)((Object)XVectorFilter.this.getChild(0))).execute(this.getDataContext());
            super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
            this.predicate = XVectorFilter.this.getPredicate();
            try {
                this.predicate.open(context, this.rowsetInfo);
            }
            catch (XQERuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorFilterIterator(this.getDataContext());
        }

        @Override
        public XVectorContext getVectorizationContext() {
            return ((IVectorContext)((Object)this.iResultSet)).getVectorizationContext();
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.predicate.close(this.getDataContext());
            this.rowsetInfo = null;
        }

        private final class XVectorFilterIterator
        extends XVectorTabularIterator {
            private ITabularIterator tabIt;

            private XVectorFilterIterator(XDataContext context) {
                super(context, XVectorFilter.this.getId(), XVectorFilterResultSet.this.rowsetInfo);
                try {
                    this.startTimer();
                    this.tabIt = XVectorFilterResultSet.this.iResultSet.getTabularIterator();
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                do {
                    this.batch = (XVectorRowBatch)this.tabIt.nextBatch();
                    if (this.batch.eod) break;
                    XVectorFilterResultSet.this.predicate.evaluate(this.context, this.batch);
                } while (this.batch.size <= 0);
                return this.batch;
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                super.release();
            }
        }
    }
}

