/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultsets.tabular.Join;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IReleasable;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class XVectorJoin
extends XTabularResultSet
implements IVectorContext {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PACKET_SIZE = 50;
    protected int packetSize = 50;
    protected static final String ATTRIBUTE_JOINTYPE = "joinType";
    protected static final String ATTRIBUTE_ISLATERAL = "isLateral";
    protected static final String ELEMENT_JOINS = "Joins";
    protected static final String ELEMENT_NULLORDERING = "nullOrdering";
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    protected XJoin.JoinType joinType;
    protected List<Join> joins;
    protected boolean isLateral;
    private SQLSortKey.NullOrdering[] nullOrdering;

    public void setJoinType(XJoin.JoinType theJoinType) {
        this.joinType = theJoinType;
    }

    public void setJoins(List<Join> pJoins) {
        this.joins = pJoins;
    }

    @Override
    public SQLSortKey.NullOrdering[] getNullOrdering() {
        return this.nullOrdering;
    }

    public void setNullOrdering(SQLSortKey.NullOrdering[] nullValueOrdering) {
        this.nullOrdering = nullValueOrdering;
    }

    public boolean isLateralJoin() {
        return this.isLateral;
    }

    public void setLateral(boolean lateralJoin) {
        this.isLateral = lateralJoin;
    }

    public IXQEQueryNode getPredicate() {
        int nChildren = this.getNumberChildren();
        if (nChildren == 2) {
            return null;
        }
        return this.getChild(nChildren - 1);
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return this.vContext;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        this.dumpAttributes(trace);
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        this.vContext.dumpInfo(trace);
        if (this.joins == null) {
            return;
        }
        trace.beginElement(ELEMENT_JOINS);
        for (int i = 0; i < this.joins.size(); ++i) {
            this.joins.get(i).dumpExtraInfo(trace);
        }
        trace.endElement();
    }

    protected void dumpAttributes(XQETrace trace) {
        trace.attribute(ATTRIBUTE_JOINTYPE, this.joinType.getDescriptor());
        trace.attribute(ATTRIBUTE_ISLATERAL, this.isLateral);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        String jType = inputNode.attributeValue(ATTRIBUTE_JOINTYPE);
        this.joinType = jType == null || jType.equals(XJoin.JoinType.INNER.getDescriptor()) ? XJoin.JoinType.INNER : (jType.equals(XJoin.JoinType.LEFT_OUTER.getDescriptor()) ? XJoin.JoinType.LEFT_OUTER : (jType.equals(XJoin.JoinType.RIGHT_OUTER.getDescriptor()) ? XJoin.JoinType.RIGHT_OUTER : XJoin.JoinType.FULL_OUTER));
        String isLateralAttr = inputNode.attributeValue(ATTRIBUTE_ISLATERAL);
        if (isLateralAttr != null) {
            this.isLateral = Boolean.valueOf(isLateralAttr);
        }
        List children = inputNode.elements();
        Element child = (Element)children.get(0);
        this.vContext = new XVectorContext();
        this.vContext.capture(env, child);
        child = (Element)children.get(1);
        if (child.getName().equals(ELEMENT_JOINS)) {
            List joinList = child.elements();
            this.joins = new ArrayList<Join>(joinList.size());
            this.nullOrdering = new SQLSortKey.NullOrdering[joinList.size()];
            for (int i = 0; i < joinList.size(); ++i) {
                Join join = new Join();
                join.capture(env, (Element)joinList.get(i));
                this.joins.add(join);
                this.nullOrdering[i] = SQLSortKey.NullOrdering.NULLS_FIRST;
            }
            super.capture(env, inputNode, 2);
        } else {
            super.capture(env, inputNode, 1);
        }
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_JOINTYPE, (Object)this.joinType);
        ctx.property(ATTRIBUTE_ISLATERAL, this.isLateral);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.joins != null) {
            ctx.elementProperty(ELEMENT_JOINS, this.joins);
        }
        if (this.nullOrdering != null) {
            ctx.elementProperty(ELEMENT_NULLORDERING, this.nullOrdering);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String name = att.getName();
        if (name.equals(ATTRIBUTE_JOINTYPE)) {
            Object val = ctx.attributeValue(att);
            this.joinType = (XJoin.JoinType)((Object)val);
        } else if (name.equals(ATTRIBUTE_ISLATERAL)) {
            Object val = ctx.attributeValue(att);
            this.isLateral = (Boolean)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_JOINS)) {
            Object val = ctx.elementValue(node);
            this.joins = (List)val;
        } else if (pname.equals(ELEMENT_NULLORDERING)) {
            Object val = ctx.elementValue(node);
            this.nullOrdering = (SQLSortKey.NullOrdering[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    protected abstract class ResultSet
    extends XResultSetBase {
        protected IHybridResultSet[] iResultSets;
        protected IRowsetInfo[] iRowsetInfo;
        protected XVectorExpression predicate;

        protected ResultSet(XDataContext theContext, Integer nodeId) {
            super(theContext, nodeId);
        }

        protected ResultSet(XDataContext theContext, int nChildren, Integer nodeId) {
            super(theContext, nodeId);
            try {
                int i;
                this.iResultSets = new IHybridResultSet[nChildren];
                this.iRowsetInfo = new IRowsetInfo[nChildren];
                for (i = 0; i < nChildren; ++i) {
                    this.iResultSets[i] = (IHybridResultSet)((IExecutable)((Object)XVectorJoin.this.getChild(i))).execute(theContext);
                    this.iRowsetInfo[i] = this.iResultSets[i].getTabularRowsetInfo();
                }
                this.rowsetInfo = new RowsetInfo();
                for (i = 0; i < this.iResultSets.length; ++i) {
                    this.rowsetInfo.add(this.iRowsetInfo[i]);
                }
                this.predicate = (XVectorExpression)XVectorJoin.this.getPredicate();
                if (this.predicate != null) {
                    this.predicate.open(theContext, this.rowsetInfo);
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        protected XJoin.State compareValues(XVectorRowBatch outerBatch, XVectorRowBatch innerBatch) {
            int v = 0;
            XJoin.State state = XJoin.State.EQUAL;
            for (int i = 0; i < XVectorJoin.this.joins.size(); ++i) {
                Join join = XVectorJoin.this.joins.get(i);
                ColumnVector vector1 = outerBatch.columns[join.getLeftJoin().getColumnNo()];
                ColumnVector vector2 = innerBatch.columns[join.getRightJoin().getColumnNo()];
                int outerIdx = outerBatch.index;
                int innerIdx = innerBatch.index;
                if (vector1.isRepeating) {
                    outerIdx = 0;
                } else if (outerBatch.selectedInUse) {
                    outerIdx = outerBatch.selected[outerIdx];
                }
                if (vector2.isRepeating) {
                    innerIdx = 0;
                } else if (innerBatch.selectedInUse) {
                    innerIdx = innerBatch.selected[innerIdx];
                }
                v = vector1.isNull[outerIdx] && vector2.isNull[innerIdx] ? (join.isNotDistinctFrom() ? 0 : -1) : (vector1.isNull[outerIdx] ? (XVectorJoin.this.nullOrdering[i] == SQLSortKey.NullOrdering.NULLS_FIRST ? -1 : 1) : (vector2.isNull[innerIdx] ? (XVectorJoin.this.nullOrdering[i] == SQLSortKey.NullOrdering.NULLS_FIRST ? 1 : -1) : ColumnVector.compareWithImplicitCast(vector1, outerIdx, vector2, innerIdx)));
                if (v != 0) break;
            }
            if (v != 0) {
                state = v < 0 ? XJoin.State.LESS_THAN : XJoin.State.GREATER_THAN;
            }
            return state;
        }

        protected void combine(XVectorRowBatch result, XVectorRowBatch outerBatch, XVectorRowBatch innerBatch, XJoin.State state) {
            ColumnVector vector1;
            ColumnVector vector12;
            int i;
            int dstIndex = result.size++;
            int nLeftValues = this.iRowsetInfo[0].getNumColumns();
            if (state == XJoin.State.GREATER_THAN) {
                for (i = 0; i < nLeftValues; ++i) {
                    vector12 = result.columns[i];
                    vector12.isNull[dstIndex] = true;
                    vector12.noNulls = false;
                }
            } else {
                for (i = 0; i < nLeftValues; ++i) {
                    vector12 = result.columns[i];
                    ColumnVector vector2 = outerBatch.columns[i];
                    int srcRow = outerBatch.index;
                    if (vector2.isRepeating) {
                        srcRow = 0;
                    }
                    vector12.assign(dstIndex, vector2, srcRow);
                }
            }
            int nRightValues = this.iRowsetInfo[1].getNumColumns();
            if (state == XJoin.State.LESS_THAN) {
                for (int i2 = 0; i2 < nRightValues; ++i2) {
                    vector1 = result.columns[i2 + nLeftValues];
                    vector1.isNull[dstIndex] = true;
                    vector1.noNulls = false;
                }
            } else {
                for (int i3 = 0; i3 < nRightValues; ++i3) {
                    vector1 = result.columns[i3 + nLeftValues];
                    ColumnVector vector2 = innerBatch.columns[i3];
                    int srcRow = innerBatch.index;
                    if (vector2.isRepeating) {
                        srcRow = 0;
                    }
                    vector1.assign(dstIndex, vector2, srcRow);
                }
            }
        }

        protected void combine(XVectorRowBatch result, XVectorRowBatch[] batches) {
            int dstIndex = result.size++;
            int nLeftValues = 0;
            for (int i = 0; i < batches.length; ++i) {
                for (int j = 0; j < this.iRowsetInfo[i].getNumColumns(); ++j) {
                    XVectorRowBatch batch = batches[i];
                    ColumnVector vector1 = result.columns[j + nLeftValues];
                    ColumnVector vector2 = batch.columns[j];
                    int srcRow = vector2.isRepeating ? 0 : (batch.selectedInUse ? batch.selected[batch.index] : batch.index);
                    vector1.assign(dstIndex, vector2, srcRow);
                }
                nLeftValues += this.iRowsetInfo[i].getNumColumns();
            }
        }

        @Override
        public void releaseImpl() {
            if (this.predicate != null) {
                this.predicate.close(this.getDataContext());
            }
            if (this.iResultSets != null) {
                ResultSet.releaseNonNullReleasables((IReleasable[])this.iResultSets);
                this.iResultSets = null;
            }
            this.iRowsetInfo = null;
            this.rowsetInfo = null;
        }
    }
}

