/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntervalValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import org.dom4j.Element;

public class XVectorLiteral
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int outputColumnNo;
    private Value valueObj;
    protected long longValue = 0L;
    private double doubleValue = 0.0;
    private String stringValue = null;
    private BigDecimal decimalValue = null;
    private TimestampColumnVector.UnixTimestamp uxTimestamp;
    private IntervalColumnVector.IntervalStruct intervalValue;
    private byte type;

    @Override
    public int getType() {
        return 501175;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        Value returnValue = this.valueObj;
        if (this.valueObj instanceof TextValue && ((TextValue)this.valueObj).getCollator() == null) {
            returnValue = (Value)this.valueObj.getDataType().createValue(context.getLocalCollator());
            returnValue.set(this.valueObj.getString());
        }
        return returnValue;
    }

    public void setValue(int outputColumn, IDataType dType, Value inValue) {
        this.valueObj = inValue;
        this.outputColumnNo = outputColumn;
        if (dType.isBoolean() || dType.isInteger()) {
            this.setValue(inValue.getLong());
        } else if (dType.isApproximateNumeric()) {
            this.setValue(inValue.getDouble());
        } else if (dType.isTextType()) {
            this.setValue(inValue.getString());
        } else if (dType.isDate()) {
            this.setValue(((DateValue)inValue).getMilliseconds());
        } else if (dType.isTime() || dType.isTimestamp()) {
            this.setValue((DateTimeValue)inValue);
        } else if (dType.isInterval()) {
            this.setValue((IntervalValue)inValue);
        } else {
            this.setValue(inValue.getBigDecimal());
        }
    }

    private void setValue(long value) {
        this.type = (byte)8;
        this.stringValue = String.valueOf(value);
        this.longValue = value;
    }

    private void setValue(double value) {
        this.type = (byte)11;
        this.stringValue = String.valueOf(value);
        this.doubleValue = value;
    }

    private void setValue(String value) {
        this.type = 1;
        this.stringValue = value;
    }

    private void setValue(BigDecimal value) {
        this.type = (byte)12;
        this.stringValue = String.valueOf(value);
        this.decimalValue = value;
    }

    public void setValue(int outputColumn, BigDecimal value) {
        this.setValue(value);
        this.outputColumnNo = outputColumn;
    }

    public Object getValue() {
        switch (this.type) {
            case 12: {
                return this.decimalValue;
            }
            case 1: {
                return this.stringValue;
            }
            case 11: {
                return this.doubleValue;
            }
            case 8: {
                return this.longValue;
            }
            case 52: 
            case 53: 
            case 58: 
            case 59: {
                return this.uxTimestamp;
            }
            case 17: 
            case 60: {
                return this.intervalValue;
            }
        }
        return null;
    }

    private void setValue(DateTimeValue value) {
        this.type = value.getDataType().getCCLTypeCode();
        this.stringValue = value.getString();
        this.uxTimestamp = new TimestampColumnVector.UnixTimestamp(this.type, value.getMilliseconds(), value.getNanoseconds());
        if (this.type == 52 || this.type == 53) {
            this.uxTimestamp.setTimeZoneOffset(value.getTimeZone().getRawOffset());
        }
    }

    private void setValue(IntervalValue value) {
        this.type = value.getDataType().getCCLTypeCode();
        this.stringValue = value.getString();
        this.intervalValue = new IntervalColumnVector.IntervalStruct(value.getSign(), value.getFields());
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        ColumnVector outputColumnVector = batch.columns[this.outputColumnNo];
        outputColumnVector.isRepeating = true;
        outputColumnVector.noNulls = true;
        switch (this.type) {
            case 8: {
                ((LongColumnVector)outputColumnVector).set(0, this.longValue);
                break;
            }
            case 11: {
                ((DoubleColumnVector)outputColumnVector).set(0, this.doubleValue);
                break;
            }
            case 1: {
                ((StringColumnVector)outputColumnVector).set(0, this.stringValue);
                break;
            }
            case 12: {
                ((DecimalColumnVector)outputColumnVector).set(0, this.decimalValue);
                break;
            }
            case 52: 
            case 53: 
            case 58: 
            case 59: {
                ((TimestampColumnVector)outputColumnVector).set(0, this.uxTimestamp);
                break;
            }
            case 17: 
            case 60: {
                ((IntervalColumnVector)outputColumnVector).set(0, this.intervalValue);
                break;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType);
        trace.attribute("value", this.stringValue);
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        super.capture(env, inputNode);
    }
}

