/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.runtree.relational.vectorization.XVectorJoin;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;

public class XVectorMergeJoin
extends XVectorJoin {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) throws XQERuntimeException {
        return new TabularHybridResultSet(context, new XVectorMergeJoinResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501182;
    }

    private final class XVectorMergeJoinResultSet
    extends XVectorJoin.ResultSet
    implements ITabularResultSet {
        XVectorMergeJoinResultSet(XDataContext context) {
            super(context, 2, XVectorMergeJoin.this.getId());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorMergeJoinIterator(this.getDataContext());
        }

        private final class XVectorMergeJoinIterator
        extends XVectorTabularIterator {
            private XTabularIterator outerTabIt;
            private XTabularIterator innerTabIt;
            private XVectorRowBatch outerBatch;
            private XVectorRowBatch innerBatch;
            private XVectorRowBatch cachedRows;
            private XJoin.State state;
            private boolean firstRow;
            private boolean eod;
            private boolean leftEod;
            private boolean rightEod;

            private XVectorMergeJoinIterator(XDataContext context) {
                super(context, XVectorMergeJoin.this.getId(), XVectorMergeJoinResultSet.this.rowsetInfo);
                try {
                    this.startTimer();
                    this.outerTabIt = (XTabularIterator)XVectorMergeJoinResultSet.this.iResultSets[0].getTabularIterator();
                    this.innerTabIt = (XTabularIterator)XVectorMergeJoinResultSet.this.iResultSets[1].getTabularIterator();
                    this.batch = XVectorRowBatchUtil.createRowBatch(XVectorMergeJoin.this.vContext, XVectorMergeJoinResultSet.this.rowsetInfo, context.getLocalCollator());
                    this.firstRow = true;
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                if (this.eod) {
                    this.batch.eod = true;
                    return this.batch;
                }
                if (this.firstRow) {
                    this.firstRow = false;
                    this.outerBatch = (XVectorRowBatch)this.outerTabIt.nextBatch();
                    if (this.outerBatch.eod) {
                        if (XVectorMergeJoin.this.joinType == XJoin.JoinType.INNER || XVectorMergeJoin.this.joinType == XJoin.JoinType.LEFT_OUTER) {
                            this.batch.eod = true;
                            return this.batch;
                        }
                        this.leftEod = true;
                    } else {
                        ++this.outerBatch.index;
                    }
                    this.innerBatch = (XVectorRowBatch)this.innerTabIt.nextBatch();
                    this.cachedRows = XVectorRowBatchUtil.copyRowBatchStructure(this.innerBatch, 1024);
                    this.state = XJoin.State.EQUAL;
                }
                this.batch.reset();
                while (this.batch.size != this.batch.maxBatchSize) {
                    if (this.state == XJoin.State.LESS_THAN) {
                        if (this.cachedRows.size > 0) {
                            if (this.cachedRows.index < 0 || this.cachedRows.index >= this.cachedRows.size) {
                                this.cachedRows.index = 0;
                                if (++this.outerBatch.index == this.outerBatch.size) {
                                    this.outerBatch = (XVectorRowBatch)this.outerTabIt.nextBatch();
                                    if (this.outerBatch.eod) {
                                        this.leftEod = true;
                                    } else {
                                        this.outerBatch.index = 0;
                                    }
                                }
                            }
                            if (!this.leftEod && XVectorMergeJoinResultSet.this.compareValues(this.outerBatch, this.cachedRows) == XJoin.State.EQUAL) {
                                XVectorMergeJoinResultSet.this.combine(this.batch, this.outerBatch, this.cachedRows, XJoin.State.EQUAL);
                                ++this.cachedRows.index;
                                continue;
                            }
                            this.cachedRows.reset();
                            this.cachedRows.index = -1;
                        } else if (!this.leftEod && ++this.outerBatch.index == this.outerBatch.size) {
                            this.outerBatch = (XVectorRowBatch)this.outerTabIt.nextBatch();
                            if (this.outerBatch.eod) {
                                this.leftEod = true;
                            } else {
                                this.outerBatch.index = 0;
                            }
                        }
                    } else if (!this.rightEod && ++this.innerBatch.index == this.innerBatch.size) {
                        this.innerBatch = (XVectorRowBatch)this.innerTabIt.nextBatch();
                        if (this.innerBatch.eod) {
                            this.rightEod = true;
                        } else {
                            this.innerBatch.index = 0;
                        }
                    }
                    if (this.leftEod && this.rightEod) {
                        this.eod = true;
                        if (this.batch.size != 0) break;
                        this.batch.eod = true;
                        break;
                    }
                    if (this.leftEod) {
                        if (XVectorMergeJoin.this.joinType == XJoin.JoinType.INNER || XVectorMergeJoin.this.joinType == XJoin.JoinType.LEFT_OUTER) {
                            this.eod = true;
                            break;
                        }
                        this.state = XJoin.State.GREATER_THAN;
                    } else if (this.rightEod) {
                        if (XVectorMergeJoin.this.joinType == XJoin.JoinType.INNER && this.cachedRows.size == 0) {
                            this.eod = true;
                            break;
                        }
                        this.state = XJoin.State.LESS_THAN;
                    } else {
                        this.state = XVectorMergeJoinResultSet.this.compareValues(this.outerBatch, this.innerBatch);
                    }
                    if (this.state == XJoin.State.EQUAL) {
                        XVectorMergeJoinResultSet.this.combine(this.batch, this.outerBatch, this.innerBatch, this.state);
                        if (this.cachedRows.size == this.cachedRows.maxBatchSize) {
                            XVectorRowBatchUtil.expandRowBatch(this.cachedRows, 1024);
                        }
                        XVectorRowBatchUtil.copyRow(this.innerBatch.index, this.innerBatch, this.cachedRows.size++, this.cachedRows, false);
                        continue;
                    }
                    if (this.state == XJoin.State.LESS_THAN) {
                        if (XVectorMergeJoin.this.joinType != XJoin.JoinType.LEFT_OUTER && XVectorMergeJoin.this.joinType != XJoin.JoinType.FULL_OUTER || this.cachedRows.size != 0) continue;
                        XVectorMergeJoinResultSet.this.combine(this.batch, this.outerBatch, this.innerBatch, this.state);
                        continue;
                    }
                    if (this.state != XJoin.State.GREATER_THAN || XVectorMergeJoin.this.joinType != XJoin.JoinType.RIGHT_OUTER && XVectorMergeJoin.this.joinType != XJoin.JoinType.FULL_OUTER) continue;
                    XVectorMergeJoinResultSet.this.combine(this.batch, this.outerBatch, this.innerBatch, this.state);
                }
                if (this.batch.size == 0) {
                    this.batch.eod = true;
                }
                return this.batch;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                if (this.outerTabIt != null) {
                    try {
                        this.outerTabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.outerTabIt = null;
                    }
                }
                if (this.innerTabIt != null) {
                    try {
                        this.innerTabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.innerTabIt = null;
                    }
                }
                this.batch = null;
                super.release();
            }

            @Override
            public Object getVectorizationContext() {
                return XVectorMergeJoin.this.vContext;
            }
        }
    }
}

