/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.IXExpression;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorBatchPartition;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class XVectorSetFunction
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    protected int columnNo;

    public XVectorSetFunction(int inputColumnNo) {
        this.columnNo = inputColumnNo;
        this.saveNodeType(501038);
    }

    public XVectorSetFunction() {
        this(0);
    }

    @Override
    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
        for (IXQEQueryNode child : this.getChildren()) {
            if (!(child instanceof XExpression)) continue;
            ((IXExpression)((Object)child)).open(context, rowsetInfo);
        }
    }

    @Override
    public void close(XDataContext context) {
        for (IXQEQueryNode child : this.getChildren()) {
            ((IXExpression)((Object)child)).close(context);
        }
    }

    public abstract AggregateState getAggregateState();

    public void aggregate(XDataContext context, AggregateState state, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        int[] selected = batch.selected;
        ColumnVector inputVector = batch.columns[this.columnNo];
        if (inputVector.noNulls) {
            if (inputVector.isRepeating) {
                for (int i = 0; i < n; ++i) {
                    state.iterateNoNulls(context, inputVector, 0);
                }
            } else if (batch.selectedInUse) {
                for (int i = 0; i < n; ++i) {
                    state.iterateNoNulls(context, inputVector, selected[i]);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    state.iterateNoNulls(context, inputVector, i);
                }
            }
        } else if (inputVector.isRepeating) {
            for (int i = 0; i < n; ++i) {
                state.iterate(context, inputVector, 0);
            }
        } else if (batch.selectedInUse) {
            for (int i = 0; i < n; ++i) {
                state.iterate(context, inputVector, selected[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                state.iterate(context, inputVector, i);
            }
        }
    }

    public void aggregate(XDataContext context, XVectorBatchPartition partition, int index, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        AggregateState state = partition.getAggregateState(index);
        int[] selected = batch.selected;
        ColumnVector inputVector = batch.columns[this.columnNo];
        if (inputVector.isRepeating) {
            for (int i = 0; i < n; ++i) {
                state.iterate(context, inputVector, 0);
            }
        } else if (batch.selectedInUse) {
            for (int i = 0; i < n; ++i) {
                state.iterate(context, inputVector, selected[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                state.iterate(context, inputVector, i);
            }
        }
    }

    public void aggregate(XDataContext context, XVectorBatchPartition[] partitions, int index, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        int[] selected = batch.selected;
        ColumnVector inputVector = batch.columns[this.columnNo];
        if (inputVector.isRepeating) {
            for (int i = 0; i < n; ++i) {
                AggregateState state = this.getState(partitions, index, i);
                state.iterate(context, inputVector, 0);
            }
        } else if (batch.selectedInUse) {
            for (int i = 0; i < n; ++i) {
                AggregateState state = this.getState(partitions, index, i);
                state.iterate(context, inputVector, selected[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                AggregateState state = this.getState(partitions, index, i);
                state.iterate(context, inputVector, i);
            }
        }
    }

    protected AggregateState getState(XVectorBatchPartition[] partitions, int index, int row) {
        return partitions[row].getAggregateState(index);
    }

    public void getResult(XDataContext context, XVectorRowBatch batch, int targetIndex, AggregateState aggrState) {
        aggrState.getResult(context, batch, targetIndex);
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNodeTypeName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getType() {
        return 501038;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property("columnNo", this.columnNo);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals("columnNo")) {
            Object val = ctx.attributeValue(att);
            this.columnNo = (Integer)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    public static interface AggregateState {
        public void reset();

        public void iterate(XDataContext var1, ColumnVector var2, int var3);

        public void iterateNoNulls(XDataContext var1, ColumnVector var2, int var3);

        public void getResult(XDataContext var1, XVectorRowBatch var2, int var3);
    }
}

