/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.runtree.relational.vectorization.XVectorJoin;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;

public class XVectorStitchJoin
extends XVectorJoin {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorStitchJoinResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501185;
    }

    private final class XVectorStitchJoinResultSet
    extends XVectorJoin.ResultSet
    implements ITabularResultSet {
        XVectorStitchJoinResultSet(XDataContext context) {
            super(context, 2, XVectorStitchJoin.this.getId());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorStitchJoinIterator(this.getDataContext());
        }

        private final class XVectorStitchJoinIterator
        extends XVectorTabularIterator {
            private XTabularIterator outerTabIt;
            private XTabularIterator innerTabIt;
            private XVectorRowBatch outerBatch;
            private XVectorRowBatch innerBatch;
            private XJoin.State state;

            private XVectorStitchJoinIterator(XDataContext context) {
                super(context, XVectorStitchJoin.this.getId(), XVectorStitchJoinResultSet.this.rowsetInfo);
                this.state = XJoin.State.EQUAL;
                try {
                    this.startTimer();
                    this.outerTabIt = (XTabularIterator)XVectorStitchJoinResultSet.this.iResultSets[0].getTabularIterator();
                    this.innerTabIt = (XTabularIterator)XVectorStitchJoinResultSet.this.iResultSets[1].getTabularIterator();
                    this.outerBatch = (XVectorRowBatch)this.outerTabIt.nextBatch();
                    this.innerBatch = (XVectorRowBatch)this.innerTabIt.nextBatch();
                    this.batch = XVectorRowBatchUtil.createRowBatch(XVectorStitchJoin.this.vContext, XVectorStitchJoinResultSet.this.rowsetInfo, context.getLocalCollator());
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                if (this.outerTabIt == null && this.innerTabIt == null) {
                    this.batch.eod = true;
                    return this.batch;
                }
                this.batch.reset();
                do {
                    if ((this.state == XJoin.State.EQUAL || this.state == XJoin.State.LESS_THAN) && this.outerTabIt != null) {
                        if (++this.outerBatch.index == this.outerBatch.size) {
                            this.outerBatch = (XVectorRowBatch)this.outerTabIt.nextBatch();
                            this.outerBatch.index = 0;
                        }
                        if (this.outerBatch.eod) {
                            try {
                                this.outerTabIt.release();
                            }
                            catch (Exception e) {
                                mErrorLogger.log(e);
                            }
                            finally {
                                this.outerTabIt = null;
                            }
                            if (this.innerTabIt == null) break;
                        }
                    }
                    if ((this.state == XJoin.State.EQUAL || this.state == XJoin.State.GREATER_THAN) && this.innerTabIt != null) {
                        if (++this.innerBatch.index == this.innerBatch.size) {
                            this.innerBatch = (XVectorRowBatch)this.innerTabIt.nextBatch();
                            this.innerBatch.index = 0;
                        }
                        if (this.innerBatch.eod) {
                            try {
                                this.innerTabIt.release();
                            }
                            catch (Exception e) {
                                mErrorLogger.log(e);
                            }
                            finally {
                                this.innerTabIt = null;
                            }
                            if (this.outerTabIt == null) break;
                        }
                    }
                    if (this.outerTabIt == null) {
                        this.state = XJoin.State.GREATER_THAN;
                    } else if (this.innerTabIt == null) {
                        this.state = XJoin.State.LESS_THAN;
                    } else if (XVectorStitchJoin.this.joins != null) {
                        this.state = XVectorStitchJoinResultSet.this.compareValues(this.outerBatch, this.innerBatch);
                    }
                    XVectorStitchJoinResultSet.this.combine(this.batch, this.outerBatch, this.innerBatch, this.state);
                } while (this.batch.size != this.batch.maxBatchSize);
                return this.batch;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                if (this.outerTabIt != null) {
                    try {
                        this.outerTabIt.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log(e);
                    }
                    finally {
                        this.outerTabIt = null;
                    }
                }
                if (this.innerTabIt != null) {
                    try {
                        this.innerTabIt.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log(e);
                    }
                    finally {
                        this.innerTabIt = null;
                    }
                }
                super.release();
            }

            @Override
            public Object getVectorizationContext() {
                return XVectorStitchJoin.this.vContext;
            }
        }
    }
}

