/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XVectorTop
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_CONTEXTNO = "contextNo";
    private static final String ATTRIBUTE_LIMIT = "limit";
    protected int rowLimit = 0;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorTopResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501171;
    }

    public int getRowlimit() {
        return this.rowLimit;
    }

    public void setRowlimit(int theRowlimit) {
        this.rowLimit = theRowlimit;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_LIMIT, this.getRowlimit());
        trace.attribute(ATTRIBUTE_CONTEXTNO, this.getContextNo());
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.setRowlimit(Integer.valueOf(inputNode.attribute(ATTRIBUTE_LIMIT).getValue()));
        super.capture(env, inputNode);
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_LIMIT, this.rowLimit);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_LIMIT)) {
            Object val = ctx.attributeValue(att);
            this.rowLimit = (Integer)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    private final class XVectorTopResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;

        XVectorTopResultSet(XDataContext context) {
            super(context, XVectorTop.this.getId());
            try {
                this.iResultSet = (IHybridResultSet)((IExecutable)((Object)XVectorTop.this.getChild(0))).execute(context);
                super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public IScrollableIterator getScrollableTabularIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorTopIterator(this.getDataContext(), this.iResultSet);
        }

        @Override
        public XVectorContext getVectorizationContext() {
            return ((IVectorContext)((Object)this.iResultSet)).getVectorizationContext();
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.rowsetInfo = null;
        }

        private final class XVectorTopIterator
        extends XVectorTabularIterator {
            private ITabularIterator tabIt;
            private int nRows;

            private XVectorTopIterator(XDataContext context, ITabularResultSet resultSet) {
                super(context, XVectorTop.this.getId(), XVectorTopResultSet.this.rowsetInfo);
                try {
                    this.startTimer();
                    this.tabIt = resultSet.getTabularIterator();
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                XVectorRowBatch batch = (XVectorRowBatch)this.tabIt.nextBatch();
                if (this.nRows < XVectorTop.this.rowLimit) {
                    batch.size = Math.min(batch.size, XVectorTop.this.rowLimit - this.nRows);
                    this.nRows += batch.size;
                } else {
                    batch.eod = true;
                }
                return batch;
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                super.release();
            }
        }
    }
}

