/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;

public class XVectorCoalesce
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    public static final String ELEMENT_COLUMNLIST = "ColumnList";
    public static final String ELEMENT_COLUMN = "Column";
    private int[] inputColumns;
    private int outputColumnNo;

    public XVectorCoalesce(int[] theInputColumns, int theOutputColumnNo) {
        this.inputColumns = theInputColumns;
        this.outputColumnNo = theOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        ColumnVector outputVector = batch.columns[this.outputColumnNo];
        outputVector.noNulls = false;
        outputVector.isRepeating = false;
        if (batch.selectedInUse) {
            block0: for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputVector.isNull[i] = true;
                for (int k = 0; k < this.inputColumns.length; ++k) {
                    ColumnVector vector = batch.columns[this.inputColumns[k]];
                    if (vector.isRepeating && (vector.noNulls || !vector.isNull[0])) {
                        outputVector.isNull[i] = false;
                        outputVector.assign(i, vector, 0);
                        continue block0;
                    }
                    if (vector.isRepeating || !vector.noNulls && vector.isNull[i]) continue;
                    outputVector.isNull[i] = false;
                    outputVector.assign(i, vector, i);
                    continue block0;
                }
            }
        } else {
            block2: for (int i = 0; i != n; ++i) {
                outputVector.isNull[i] = true;
                for (int k = 0; k < this.inputColumns.length; ++k) {
                    ColumnVector vector = batch.columns[this.inputColumns[k]];
                    if (vector.isRepeating && (vector.noNulls || !vector.isNull[0])) {
                        outputVector.isNull[i] = false;
                        outputVector.assign(i, vector, 0);
                        continue block2;
                    }
                    if (vector.isRepeating || !vector.noNulls && vector.isNull[i]) continue;
                    outputVector.isNull[i] = false;
                    outputVector.assign(i, vector, i);
                    continue block2;
                }
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("outputColumnNo", String.valueOf(this.outputColumnNo));
        trace.beginElement(ELEMENT_COLUMNLIST);
        for (int i = 0; i < this.inputColumns.length; ++i) {
            trace.beginElement(ELEMENT_COLUMN);
            trace.attribute("columnNo", String.valueOf(this.inputColumns[i]));
            trace.endElement();
        }
        trace.endElement();
    }
}

