/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;

public abstract class XVectorFunctionStringToLong
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;

    protected abstract long getResult(String var1, boolean[] var2, int var3);

    public XVectorFunctionStringToLong(int inColumnNo, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
    }

    public XVectorFunctionStringToLong() {
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        StringColumnVector inputColVector = (StringColumnVector)batch.columns[this.columnNo];
        LongColumnVector outputColVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector.noNulls;
        String[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (inputColVector.isRepeating) {
            outputVector[0] = this.getResult(vector[0], outputIsNull, 0);
            outputIsNull[0] = inputIsNull[0];
            outputColVector.isRepeating = true;
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = this.getResult(vector[i], outputIsNull, i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.getResult(vector[i], outputIsNull, i);
                }
            }
            outputColVector.isRepeating = false;
        } else {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = this.getResult(vector[i], outputIsNull, i);
                    outputIsNull[i] = inputIsNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.getResult(vector[i], outputIsNull, i);
                }
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            }
            outputColVector.isRepeating = false;
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType.toString());
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }
}

