/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.exception.XCardinalityViolation;
import com.cognos.xqe.runtree.relational.SubQueryState;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.expressions.XVectorSubQuery;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IReleasable;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class XVectorScalarSubQuery
extends XVectorSubQuery {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_DATATYPE = "dataType";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ELEMENT_PARAMETERS = "Parameters";
    private static final String ELEMENT_PARAMETER = "Parameter";
    private int outputColumnNo;

    @Override
    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
        context.setStateObject(this, new SubQueryState(context, this.getParameters()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        SubQueryState state = (SubQueryState)context.getStateObject(this);
        Object value = null;
        ColumnVector vector = batch.columns[this.outputColumnNo];
        if (!state.isValid()) {
            this.lock.writeLock().lock();
            try {
                ITabularResultSet resultSet = null;
                IReleasable tabIt = null;
                try {
                    resultSet = (ITabularResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
                    tabIt = resultSet.getTabularIterator();
                    XVectorRowBatch inputBatch = (XVectorRowBatch)tabIt.nextBatch();
                    if (inputBatch.size > 1) {
                        throw new XCardinalityViolation(XQEMessageKeys.EXE_InvalidSubQuery);
                    }
                    if (!inputBatch.eod) {
                        int index = 0;
                        if (inputBatch.selectedInUse) {
                            index = inputBatch.selected[0];
                        }
                        value = inputBatch.columns[0].getObject(index);
                    }
                    state.setValue(value);
                }
                finally {
                    if (tabIt != null) {
                        tabIt.release();
                        tabIt = null;
                    }
                    if (resultSet != null) {
                        resultSet.release();
                        resultSet = null;
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        value = state.getValue();
        vector.isRepeating = true;
        vector.isNull[0] = value == null;
        vector.noNulls = value != null;
        vector.assign(0, state.getValue());
    }

    @Override
    public void close(XDataContext context) {
        context.removeStateObject(this);
    }

    @Override
    public int getType() {
        return 501197;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List elements;
        this.setContextNo(Integer.valueOf(inputNode.attribute("contextNo").getValue()));
        String dataTypeStr = inputNode.attributeValue(ATTRIBUTE_DATATYPE);
        if (dataTypeStr != null) {
            this.setDataType(DataTypeFactory.getType(dataTypeStr));
        }
        if ((elements = inputNode.elements()).size() > 1) {
            this.parameters = new ArrayList();
            List parameterList = ((Element)elements.get(0)).elements();
            for (Element parameter : parameterList) {
                String name = parameter.attributeValue(ATTRIBUTE_NAME);
                this.parameters.add(name);
            }
        }
        super.capture(env, inputNode, elements.size() - 1);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("contextNo", this.getContextNo());
        trace.attribute(ATTRIBUTE_DATATYPE, this.getDataType().toString());
        if (this.parameters != null) {
            trace.beginElement(ELEMENT_PARAMETERS);
            for (String name : this.parameters) {
                trace.beginElement(ELEMENT_PARAMETER);
                trace.attribute(ATTRIBUTE_NAME, name);
                trace.endElement();
            }
            trace.endElement();
        }
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    public void setOutputColumnNo(int columnNo) {
        this.outputColumnNo = columnNo;
    }
}

