/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.cast;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.values.BigDecimalValue;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class XVectorCastStringToDecimal
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;

    public XVectorCastStringToDecimal(int inColumnNo, int outColumnNo) {
        this.columnNo = inColumnNo;
        this.outputColumnNo = outColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        StringColumnVector inputColumnVector = (StringColumnVector)batch.columns[this.columnNo];
        DecimalColumnVector outputColumnVector = (DecimalColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        if (inputColumnVector.noNulls) {
            outputColumnVector.noNulls = true;
            if (inputColumnVector.isRepeating) {
                outputColumnVector.isRepeating = true;
                this.getResult(outputColumnVector, inputColumnVector, 0);
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    this.getResult(outputColumnVector, inputColumnVector, i);
                }
                outputColumnVector.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    this.getResult(outputColumnVector, inputColumnVector, i);
                }
                outputColumnVector.isRepeating = false;
            }
        } else {
            outputColumnVector.noNulls = false;
            if (inputColumnVector.isRepeating) {
                outputColumnVector.isRepeating = true;
                outputColumnVector.isNull[0] = inputColumnVector.isNull[0];
                if (!inputColumnVector.isNull[0]) {
                    this.getResult(outputColumnVector, inputColumnVector, 0);
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                    if (inputColumnVector.isNull[i]) continue;
                    this.getResult(outputColumnVector, inputColumnVector, i);
                }
                outputColumnVector.isRepeating = false;
            } else {
                System.arraycopy(inputColumnVector.isNull, 0, outputColumnVector.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputColumnVector.isNull[i]) continue;
                    this.getResult(outputColumnVector, inputColumnVector, i);
                }
                outputColumnVector.isRepeating = false;
            }
        }
    }

    private void getResult(DecimalColumnVector outputVector, StringColumnVector inputVector, int i) {
        BigDecimal b;
        String value = inputVector.vector[i];
        if (inputVector.isNull[i] || value.isEmpty()) {
            outputVector.setNull(i);
            return;
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        df.setParseBigDecimal(true);
        value = value.trim();
        if (value.charAt(0) == '+') {
            value = value.substring(1);
        }
        int decMaxIndex = this.dataType.getPrecision() - this.dataType.getScale();
        try {
            b = (BigDecimal)df.parse(value);
        }
        catch (Exception e) {
            if (this.getOnErrorPolicy() == SQLAbstractFunction.OnErrorPolicy.ERROR) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", value, "decimal");
            }
            outputVector.setNull(i);
            return;
        }
        b = BigDecimalValue.getScaledValue(b, this.dataType.getScale(), 1);
        if (BigDecimalValue.notWithinRange(decMaxIndex, b) && BigDecimalValue.notWithinRange(decMaxIndex, b = BigDecimalValue.getScaledValue(b, 0, 1))) {
            if (this.getOnErrorPolicy() == SQLAbstractFunction.OnErrorPolicy.ERROR) {
                throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, value, Integer.toString(this.dataType.getPrecision()), Integer.toString(this.dataType.getScale()));
            }
            outputVector.setNull(i);
            return;
        }
        outputVector.set(i, b);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType.toString());
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        trace.attribute("outputColumnNo", String.valueOf(this.outputColumnNo));
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }
}

