/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.cast;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorFunctionStringToDouble;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class XVectorCastStringToDouble
extends XVectorFunctionStringToDouble {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            StringBuilder format = new StringBuilder("@");
            for (int i = 0; i < 14; ++i) {
                format.append('#');
            }
            format.append("E0");
            DecimalFormat x = (DecimalFormat)NumberFormat.getNumberInstance((Locale)Locale.US);
            x.applyPattern(format.toString());
            return x;
        }
    };

    public XVectorCastStringToDouble(int inColumnNo, int outColumnNo) {
        super(inColumnNo, outColumnNo);
    }

    @Override
    protected void getResult(DoubleColumnVector outputVector, StringColumnVector inputVector, int i) {
        double d;
        String value = inputVector.vector[i];
        if (inputVector.isNull[i] || value.isEmpty()) {
            outputVector.setNull(i);
            return;
        }
        try {
            Number number = DECIMAL_FORMAT.get().parse(value.replace("e", "E").replace("+", ""));
            d = number.doubleValue();
        }
        catch (ParseException e) {
            if (this.getOnErrorPolicy() == SQLAbstractFunction.OnErrorPolicy.ERROR) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", value, "double");
            }
            outputVector.setNull(i);
            return;
        }
        outputVector.set(i, d);
    }
}

