/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.cast;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.providers.relational.LOCALCastFormatter;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.XVectorFunctionStringToTimestamp;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.ArrayList;

public class XVectorCastStringToTimeWithFormat
extends XVectorFunctionStringToTimestamp {
    private static final long serialVersionUID = 1L;
    private DateTimeFormatter dtf;
    private ArrayList<ChronoField> accessors;

    public XVectorCastStringToTimeWithFormat(int inColumnNo, ObjectValue o, int outColumnNo) {
        super(inColumnNo, outColumnNo);
        Object[] objArray = (Object[])o.getObject();
        this.dtf = (DateTimeFormatter)objArray[0];
        this.accessors = (ArrayList)objArray[1];
    }

    @Override
    protected void getResult(TimestampColumnVector outputVector, StringColumnVector inputVector, int i) {
        String value = inputVector.vector[i];
        if (inputVector.isNull[i] || value.isEmpty()) {
            outputVector.setNull(i);
            return;
        }
        try {
            value = LOCALCastFormatter.getInstance().convertToISOStandardFormat(value, DataTypeFactory.getTimeType(), this.accessors, this.dtf);
            this.tsUtil.parseTime(value, outputVector.vector[i]);
        }
        catch (RuntimeException e) {
            if (this.getOnErrorPolicy() == SQLAbstractFunction.OnErrorPolicy.ERROR) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", value, "time");
            }
            outputVector.setNull(i);
        }
    }
}

