/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.character;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorStringColumnConcatStringColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo1;
    private int columnNo2;
    private int outputColumnNo;

    public XVectorStringColumnConcatStringColumn(int inColNum1, int inColNum2, int inOutputColumnNo) {
        this.columnNo1 = inColNum1;
        this.columnNo2 = inColNum2;
        this.outputColumnNo = inOutputColumnNo;
    }

    public XVectorStringColumnConcatStringColumn() {
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        super.evaluate(context, batch);
        int[] selected = batch.selected;
        StringColumnVector inputColumnVector1 = (StringColumnVector)batch.columns[this.columnNo1];
        StringColumnVector inputColumnVector2 = (StringColumnVector)batch.columns[this.columnNo2];
        StringColumnVector outputColumnVector = (StringColumnVector)batch.columns[this.outputColumnNo];
        String[] vector1 = inputColumnVector1.vector;
        String[] vector2 = inputColumnVector2.vector;
        outputColumnVector.isRepeating = false;
        if (inputColumnVector1.noNulls && !inputColumnVector2.noNulls) {
            outputColumnVector.noNulls = false;
            if (inputColumnVector2.isRepeating) {
                if (inputColumnVector2.isNull[0]) {
                    outputColumnVector.isNull[0] = true;
                    outputColumnVector.isRepeating = true;
                }
            } else {
                XVectorStringColumnConcatStringColumn.propagateNulls(batch.selectedInUse, n, selected, inputColumnVector2, outputColumnVector);
            }
            if (inputColumnVector1.isRepeating && inputColumnVector2.isRepeating) {
                if (!inputColumnVector2.isNull[0]) {
                    outputColumnVector.append(0, vector1[0], vector2[0]);
                }
                outputColumnVector.isRepeating = true;
            } else if (inputColumnVector1.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = selected[j];
                        if (inputColumnVector2.isNull[i]) continue;
                        outputColumnVector.append(i, vector1[0], vector2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inputColumnVector2.isNull[0]) continue;
                        outputColumnVector.append(i, vector1[0], vector2[i]);
                    }
                }
            } else if (inputColumnVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = selected[j];
                        if (inputColumnVector2.isNull[i]) continue;
                        outputColumnVector.append(i, vector1[i], vector2[0]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inputColumnVector2.isNull[i]) continue;
                        outputColumnVector.append(i, vector1[i], vector2[0]);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    if (inputColumnVector2.isNull[i]) continue;
                    outputColumnVector.append(i, vector1[i], vector2[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (inputColumnVector2.isNull[i]) continue;
                    outputColumnVector.append(i, vector1[i], vector2[i]);
                }
            }
        } else if (!inputColumnVector1.noNulls && inputColumnVector2.noNulls) {
            outputColumnVector.noNulls = false;
            if (inputColumnVector1.isRepeating) {
                outputColumnVector.isRepeating = true;
                outputColumnVector.isNull[0] = true;
            } else {
                XVectorStringColumnConcatStringColumn.propagateNulls(batch.selectedInUse, n, selected, inputColumnVector1, outputColumnVector);
            }
            if (inputColumnVector1.isRepeating && inputColumnVector2.isRepeating) {
                if (!inputColumnVector1.isNull[0]) {
                    outputColumnVector.append(0, vector1[0], vector2[0]);
                }
                outputColumnVector.isRepeating = true;
            } else if (inputColumnVector1.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = selected[j];
                        if (inputColumnVector1.isNull[0]) continue;
                        outputColumnVector.append(i, vector1[0], vector2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inputColumnVector1.isNull[0]) continue;
                        outputColumnVector.append(i, vector1[0], vector2[i]);
                    }
                }
            } else if (inputColumnVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = selected[j];
                        if (inputColumnVector1.isNull[i]) continue;
                        outputColumnVector.append(i, vector1[i], vector2[0]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inputColumnVector1.isNull[i]) continue;
                        outputColumnVector.append(i, vector1[i], vector2[0]);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    if (inputColumnVector1.isNull[i]) continue;
                    outputColumnVector.append(i, vector1[i], vector2[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (inputColumnVector1.isNull[i]) continue;
                    outputColumnVector.append(i, vector1[i], vector2[i]);
                }
            }
        } else if (!inputColumnVector1.noNulls && !inputColumnVector2.noNulls) {
            outputColumnVector.noNulls = false;
            if (inputColumnVector1.isRepeating && inputColumnVector2.isRepeating) {
                outputColumnVector.isNull[0] = inputColumnVector1.isNull[0] || inputColumnVector2.isNull[0];
                outputColumnVector.isRepeating = true;
                if (outputColumnVector.isNull[0]) {
                    return;
                }
            } else if (inputColumnVector1.isRepeating) {
                if (inputColumnVector1.isNull[0]) {
                    outputColumnVector.isRepeating = true;
                    outputColumnVector.isNull[0] = true;
                } else {
                    outputColumnVector.isRepeating = false;
                    XVectorStringColumnConcatStringColumn.propagateNulls(batch.selectedInUse, n, selected, inputColumnVector2, outputColumnVector);
                }
            } else if (inputColumnVector2.isRepeating) {
                if (inputColumnVector2.isNull[0]) {
                    outputColumnVector.isRepeating = true;
                    outputColumnVector.isNull[0] = true;
                    return;
                }
                outputColumnVector.isRepeating = false;
                XVectorStringColumnConcatStringColumn.propagateNulls(batch.selectedInUse, n, selected, inputColumnVector1, outputColumnVector);
            } else {
                XVectorStringColumnConcatStringColumn.propagateNullsCombine(batch.selectedInUse, n, selected, inputColumnVector1, inputColumnVector2, outputColumnVector);
            }
            if (inputColumnVector1.isRepeating && inputColumnVector2.isRepeating) {
                if (!inputColumnVector1.isNull[0] && !inputColumnVector2.isNull[0]) {
                    outputColumnVector.append(0, vector1[0], vector2[0]);
                }
                outputColumnVector.isRepeating = true;
            } else if (inputColumnVector1.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = selected[j];
                        if (inputColumnVector1.isNull[0] || inputColumnVector2.isNull[i]) continue;
                        outputColumnVector.append(i, vector1[0], vector2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inputColumnVector1.isNull[0] || inputColumnVector2.isNull[i]) continue;
                        outputColumnVector.append(i, vector1[0], vector2[i]);
                    }
                }
            } else if (inputColumnVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = selected[j];
                        if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[0]) continue;
                        outputColumnVector.append(i, vector1[i], vector2[0]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[0]) continue;
                        outputColumnVector.append(i, vector1[i], vector2[0]);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i]) continue;
                    outputColumnVector.append(i, vector1[i], vector2[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i]) continue;
                    outputColumnVector.append(i, vector1[i], vector2[i]);
                }
            }
        } else {
            outputColumnVector.noNulls = true;
            if (inputColumnVector1.isRepeating && inputColumnVector2.isRepeating) {
                outputColumnVector.append(0, vector1[0], vector2[0]);
                outputColumnVector.isRepeating = true;
            } else if (inputColumnVector1.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = selected[j];
                        outputColumnVector.append(i, vector1[0], vector2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputColumnVector.append(i, vector1[0], vector2[i]);
                    }
                }
            } else if (inputColumnVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = selected[j];
                        outputColumnVector.append(i, vector1[i], vector2[0]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputColumnVector.append(i, vector1[i], vector2[0]);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputColumnVector.append(i, vector1[i], vector2[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputColumnVector.append(i, vector1[i], vector2[i]);
                }
            }
        }
    }

    private static void propagateNullsCombine(boolean selectedInUse, int n, int[] selected, ColumnVector inputVector1, ColumnVector inputVector2, StringColumnVector outputVector) {
        if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputVector.isNull[i] = inputVector1.isNull[i] || inputVector2.isNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector.isNull[i] = inputVector1.isNull[i] || inputVector2.isNull[i];
            }
        }
    }

    private static void propagateNulls(boolean selectedInUse, int n, int[] selected, ColumnVector inputVector, ColumnVector outputVector) {
        if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputVector.isNull[i] = inputVector.isNull[i];
            }
        } else {
            System.arraycopy(inputVector.isNull, 0, outputVector.isNull, 0, n);
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType);
        trace.attribute("leftColumnNo", this.columnNo1);
        trace.attribute("rightColumnNo", this.columnNo2);
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
        this.columnNo1 = Integer.valueOf(inputNode.attributeValue("leftColumnNo"));
        this.columnNo2 = Integer.valueOf(inputNode.attributeValue("rightColumnNo"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        super.capture(env, inputNode);
    }
}

