/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.character;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.ArrayUtil;
import com.ibm.icu.text.Collator;
import org.dom4j.Element;

public class XVectorStringColumnNullIfStringScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;
    private String value;

    public XVectorStringColumnNullIfStringScalar(int inColumnNo, String inValue, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.value = inValue;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        Collator collator = context.getLocalCollator();
        StringColumnVector inputColumnVector = (StringColumnVector)batch.columns[this.columnNo];
        StringColumnVector outputColumnVector = (StringColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        boolean[] outputIsNull = outputColumnVector.isNull;
        String[] vector1 = inputColumnVector.vector;
        String[] vector2 = outputColumnVector.vector;
        if (inputColumnVector.isRepeating) {
            if (!outputIsNull[0]) {
                outputIsNull[0] = collator.compare(vector1[0], this.value) == 0;
                vector2[0] = vector1[0];
            }
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputIsNull[i] = collator.compare(vector1[i], this.value) == 0;
                    vector2[i] = vector1[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputIsNull[i] = collator.compare(vector1[i], this.value) == 0;
                    vector2[i] = vector1[i];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                if (outputIsNull[i]) continue;
                outputIsNull[i] = collator.compare(vector1[i], this.value) == 0;
                vector2[i] = vector1[i];
            }
        } else {
            boolean[] inputIsNull = inputColumnVector.isNull;
            for (int i = 0; i != n; ++i) {
                if (inputIsNull[i]) {
                    outputIsNull[i] = false;
                    vector2[i] = vector1[i];
                    continue;
                }
                if (outputIsNull[i]) continue;
                outputIsNull[i] = collator.compare(vector1[i], this.value) == 0;
                vector2[i] = vector1[i];
            }
        }
        outputColumnVector.noNulls = !ArrayUtil.contains(outputIsNull, true);
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.columnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = inputNode.attributeValue("value");
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        this.setDataType(DataTypeFactory.getType(inputNode.attribute("dataType").getValue()));
        super.capture(env, inputNode);
    }
}

