/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.IVectorInList;
import com.cognos.xqe.trace.XQETrace;

public abstract class XVectorFilterInList
extends XVectorExpression
implements IVectorInList {
    private static final long serialVersionUID = 1L;
    public static final String ELEMENT_VALUELIST = "ValueList";
    public static final String ELEMENT_VALUE = "Value";
    private static final String ATTRIBUTE_NOT = "not";
    private boolean notIn;
    protected int columnNo;

    public XVectorFilterInList(int inColumnNo) {
        this.columnNo = inColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        ColumnVector inputColumnVector = batch.columns[this.columnNo];
        boolean[] isNull = inputColumnVector.isNull;
        if (!this.notIn) {
            if (inputColumnVector.noNulls) {
                if (inputColumnVector.isRepeating) {
                    if (!this.contains(inputColumnVector, 0)) {
                        batch.size = 0;
                    }
                } else if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j < n; ++j) {
                        int i = selected[j];
                        if (!this.contains(inputColumnVector, i)) continue;
                        selected[newSize++] = i;
                    }
                    if (newSize < n) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                } else {
                    int newSize = 0;
                    for (int i = 0; i < n; ++i) {
                        if (!this.contains(inputColumnVector, i)) continue;
                        selected[newSize++] = i;
                    }
                    if (newSize < n) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColumnVector.isRepeating) {
                if (!isNull[0]) {
                    if (!this.contains(inputColumnVector, 0)) {
                        batch.size = 0;
                    }
                } else {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    if (isNull[i] || !this.contains(inputColumnVector, i)) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            } else {
                int newSize = 0;
                for (int i = 0; i < n; ++i) {
                    if (isNull[i] || !this.contains(inputColumnVector, i)) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColumnVector.noNulls) {
            if (inputColumnVector.isRepeating) {
                if (!this.contains(inputColumnVector, 0)) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    if (this.contains(inputColumnVector, i)) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            } else {
                int newSize = 0;
                for (int i = 0; i < n; ++i) {
                    if (this.contains(inputColumnVector, i)) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColumnVector.isRepeating) {
            if (!isNull[0]) {
                if (!this.contains(inputColumnVector, 0)) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j < n; ++j) {
                int i = selected[j];
                if (isNull[i] || this.contains(inputColumnVector, i)) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        } else {
            int newSize = 0;
            for (int i = 0; i < n; ++i) {
                if (isNull[i] || this.contains(inputColumnVector, i)) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute(ATTRIBUTE_NOT, this.notIn);
        this.dumpValues(trace);
    }

    protected abstract void dumpValues(XQETrace var1);

    protected abstract boolean contains(ColumnVector var1, int var2);

    @Override
    public void setNotIn(boolean not) {
        this.notIn = not;
    }
}

