/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.date;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorCurrentDate
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_OUTPUTCOLUMNNO = "outputColumnNo";
    protected int outputColumnNo;

    public XVectorCurrentDate(int inOutputColumnNo) {
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public int getType() {
        return -1;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        outputColumnVector.isRepeating = true;
        outputColumnVector.noNulls = true;
        DateValue dateValue = DataValueFactory.createDateValue();
        dateValue.set(context.getExecutionTime());
        outputColumnVector.vector[0] = dateValue.getLong();
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_OUTPUTCOLUMNNO, this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_OUTPUTCOLUMNNO));
    }
}

