/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.date;

import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IDateColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorDuration;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class XVectorYMDIntBetween
extends XVectorDuration {
    private static final long serialVersionUID = 1L;
    private static final int YEAR_MULTIPLIER = 10000;
    private static final int MONTH_MULTIPLIER = 100;
    private Calendar end = (Calendar)GC_VALUE.clone();
    private Calendar start = (Calendar)GC_VALUE.clone();

    public XVectorYMDIntBetween(int columnNo1, int columnNo2, int outputColumnNo) {
        super(columnNo1, columnNo2, outputColumnNo);
    }

    @Override
    protected long getResult(ColumnVector columnVector1, int index1, ColumnVector columnVector2, int index2) {
        long ms1 = ((IDateColumnVector)((Object)columnVector1)).getMilliseconds(index1);
        long ms2 = ((IDateColumnVector)((Object)columnVector2)).getMilliseconds(index2);
        this.end.setTimeInMillis(ms1);
        this.start.setTimeInMillis(ms2);
        int months = (this.end.get(1) - this.start.get(1)) * 12;
        int days = this.end.get(5) - this.start.get(5);
        GregorianCalendar t = new GregorianCalendar(this.end.get(1), this.end.get(2), this.end.getActualMinimum(5));
        if ((months += this.end.get(2) + 1 - (this.start.get(2) + 1)) > 0 && days < 0) {
            --months;
            t.add(2, -1);
            days += t.getActualMaximum(5);
        } else if (months < 0 && days > 0) {
            ++months;
            days -= t.getActualMaximum(5);
        }
        int years = months / 12;
        int result = years * 10000 + (months %= 12) * 100 + days;
        if (result < 0) {
            result = -result;
        }
        return result;
    }
}

