/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSetFunction;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import org.dom4j.Element;

public class XVectorAggregateAvgLong
extends XVectorSetFunction {
    private static final long serialVersionUID = 1L;

    public XVectorAggregateAvgLong(int inputColumnNo) {
        super(inputColumnNo);
    }

    public XVectorAggregateAvgLong() {
    }

    @Override
    public XVectorSetFunction.AggregateState getAggregateState() {
        return new State();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        trace.attribute("dataType", this.dataType);
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
    }

    private static final class State
    implements XVectorSetFunction.AggregateState {
        private long sum;
        private boolean isNull = true;
        private int nonNullCount = 0;
        private int nullCount = 0;
        private int count = 0;
        private FormatId formatId = FormatId.INVALID_FORMAT_FID;

        private State() {
        }

        @Override
        public void iterate(XDataContext context, ColumnVector inputColumnVector, int index) {
            if (this.count == 0) {
                this.calculateFormatId(inputColumnVector);
            }
            ++this.count;
            if (inputColumnVector.isNull[index]) {
                ++this.nullCount;
                return;
            }
            long value = ((LongColumnVector)inputColumnVector).vector[index];
            if (this.isNull) {
                this.sum = value;
                this.isNull = false;
            } else {
                this.sum += value;
            }
            ++this.nonNullCount;
        }

        @Override
        public void iterateNoNulls(XDataContext context, ColumnVector inputColumnVector, int index) {
            if (this.count == 0) {
                this.calculateFormatId(inputColumnVector);
            }
            ++this.count;
            long value = ((LongColumnVector)inputColumnVector).vector[index];
            if (this.isNull) {
                this.sum = value;
                this.isNull = false;
            } else {
                this.sum += value;
            }
            ++this.nonNullCount;
        }

        @Override
        public void getResult(XDataContext context, XVectorRowBatch batch, int targetIndex) {
            DoubleColumnVector outputColumnVector = (DoubleColumnVector)batch.columns[targetIndex];
            if (this.count == 0 || this.nullCount == this.count) {
                outputColumnVector.setNull(batch.size);
            } else {
                outputColumnVector.vector[batch.size] = this.sum / (long)this.nonNullCount;
            }
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.count = 0;
            this.sum = 0L;
            this.nullCount = 0;
            this.nonNullCount = 0;
        }

        private void calculateFormatId(ColumnVector inputVector) {
            this.formatId = this.getFormatId("Divide", this.getFormatId("Sum", inputVector.getFormatId()), FormatId.EMPTY_FORMAT_FID);
        }

        private FormatId getFormatId(String keyWord, FormatId ... operandId) {
            ArrayList<FormatId> ids = new ArrayList<FormatId>();
            for (FormatId id : operandId) {
                ids.add(id);
            }
            return FormatService.getInstance().formatResult(keyWord, ids);
        }
    }
}

