/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.ArrayUtil;
import java.math.BigDecimal;
import org.dom4j.Element;

public class XVectorDecimalColumnNullIfDecimalScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;
    private BigDecimal value;

    public XVectorDecimalColumnNullIfDecimalScalar() {
    }

    public XVectorDecimalColumnNullIfDecimalScalar(int inColumnNo, BigDecimal inValue, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.value = inValue;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        DecimalColumnVector inputColumnVector = (DecimalColumnVector)batch.columns[this.columnNo];
        DecimalColumnVector outputColumnVector = (DecimalColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColumnVector.isNull;
        BigDecimal[] vector1 = inputColumnVector.vector;
        BigDecimal[] vector2 = outputColumnVector.vector;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        if (inputColumnVector.isRepeating) {
            outputIsNull[0] = inputIsNull[0] || this.isEqual(vector1[0], this.value);
            vector2[0] = vector1[0];
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputIsNull[i] = this.isEqual(vector1[i], this.value);
                    vector2[i] = vector1[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputIsNull[i] = this.isEqual(vector1[i], this.value);
                    vector2[i] = vector1[i];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputIsNull[i] = inputIsNull[i] || this.isEqual(vector1[i], this.value);
                vector2[i] = vector1[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputIsNull[i] = inputIsNull[i] || this.isEqual(vector1[i], this.value);
                vector2[i] = vector1[i];
            }
        }
        outputColumnVector.noNulls = !ArrayUtil.contains(outputIsNull, true);
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.columnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = new BigDecimal(inputNode.attributeValue("value"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        this.setDataType(DataTypeFactory.getType(inputNode.attribute("dataType").getValue()));
        super.capture(env, inputNode);
    }

    private boolean isEqual(BigDecimal parm1, BigDecimal parm2) {
        return parm1.compareTo(parm2) == 0;
    }
}

