/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorDoubleColumnSubtractLongScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;
    private long value;

    public XVectorDoubleColumnSubtractLongScalar() {
    }

    public XVectorDoubleColumnSubtractLongScalar(int inColumnNo, Number inValue, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.value = inValue.longValue();
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        DoubleColumnVector inputColumnVector = (DoubleColumnVector)batch.columns[this.columnNo];
        DoubleColumnVector outputColumnVector = (DoubleColumnVector)batch.columns[this.outputColumnNo];
        if (outputColumnVector.getFormatId() == FormatId.INVALID_FORMAT_FID) {
            outputColumnVector.setFormatID("Subtract", inputColumnVector.getFormatId(), FormatId.INVALID_FORMAT_FID);
        }
        int[] selected = batch.selected;
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColumnVector.isNull;
        double[] vector = inputColumnVector.vector;
        double[] outputVector = outputColumnVector.vector;
        outputColumnVector.noNulls = inputColumnVector.noNulls;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        if (inputColumnVector.isRepeating) {
            outputVector[0] = vector[0] - (double)this.value;
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = vector[i] - (double)this.value;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector[i] - (double)this.value;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputVector[i] = vector[i] - (double)this.value;
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            for (int i = 0; i != n; ++i) {
                outputVector[i] = vector[i] - (double)this.value;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.outputColumnNo);
        trace.attribute("dataType", this.dataType.toString());
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = Long.valueOf(inputNode.attributeValue("value"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        super.capture(env, inputNode);
    }
}

