/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.icu.text.Collator;
import org.dom4j.Element;

public class XVectorFilterStringScalarLessThanStringColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String ATTRIBUTE_VALUE = "value";
    private int columnNo;
    private String value;
    private Collator collator;

    public XVectorFilterStringScalarLessThanStringColumn(String inValue, int inColumnNo) {
        this.value = inValue;
        this.columnNo = inColumnNo;
    }

    public XVectorFilterStringScalarLessThanStringColumn() {
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        this.collator = context.getLocalCollator();
        int[] selected = batch.selected;
        StringColumnVector columns = (StringColumnVector)batch.columns[this.columnNo];
        boolean[] isNull = columns.isNull;
        String[] vector = columns.vector;
        if (columns.noNulls) {
            if (columns.isRepeating) {
                if (StringUtil.compare(this.collator, this.value, vector[0]) >= 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    if (StringUtil.compare(this.collator, this.value, vector[i]) >= 0) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            } else {
                int newSize = 0;
                for (int i = 0; i < n; ++i) {
                    if (StringUtil.compare(this.collator, this.value, vector[i]) >= 0) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (columns.isRepeating) {
            if (!isNull[0]) {
                if (StringUtil.compare(this.collator, this.value, vector[0]) < 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j < n; ++j) {
                int i = selected[j];
                if (isNull[i] || StringUtil.compare(this.collator, this.value, vector[i]) >= 0) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        } else {
            int newSize = 0;
            for (int i = 0; i < n; ++i) {
                if (isNull[i] || StringUtil.compare(this.collator, this.value, vector[i]) >= 0) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_COLUMNNO, this.columnNo);
        trace.attribute(ATTRIBUTE_VALUE, this.value);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_COLUMNNO));
        this.value = inputNode.attributeValue(ATTRIBUTE_VALUE);
    }
}

