/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import org.dom4j.Element;

public class XVectorFunctionAbsDecimal
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;

    public XVectorFunctionAbsDecimal(int inColumnNo, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        DecimalColumnVector inputColVector = (DecimalColumnVector)batch.columns[this.columnNo];
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.columns[this.outputColumnNo];
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector.noNulls;
        BigDecimal[] vector = inputColVector.vector;
        outputColVector.isRepeating = inputColVector.isRepeating;
        if (inputColVector.isRepeating) {
            DecimalUtil.abs(0, vector[0], outputColVector);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    DecimalUtil.abs(i, vector[i], outputColVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.abs(i, vector[i], outputColVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                DecimalUtil.abs(i, vector[i], outputColVector);
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                DecimalUtil.abs(i, vector[i], outputColVector);
            }
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        super.capture(env, inputNode);
    }
}

