/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.util.Arrays;

public class XVectorIfExpressionLongScalarLongScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_THENVALUE = "thenValue";
    private static final String ATTRIBUTE_ELSEVALUE = "elseValue";
    private int columnNo;
    private long thenValue;
    private long elseValue;
    private int outputColumnNo;

    public XVectorIfExpressionLongScalarLongScalar(int inColumnNo, long inThenValue, long inElseValue, int theOutputColumn) {
        this.columnNo = inColumnNo;
        this.thenValue = inThenValue;
        this.elseValue = inElseValue;
        this.outputColumnNo = theOutputColumn;
    }

    public XVectorIfExpressionLongScalarLongScalar() {
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        LongColumnVector conditionColumnVector = (LongColumnVector)batch.columns[this.columnNo];
        LongColumnVector outputColVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        boolean[] conditionIsNull = conditionColumnVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        long[] conditionVector = conditionColumnVector.vector;
        outputColVector.noNulls = false;
        outputColVector.isRepeating = false;
        long[] outputVector = outputColVector.vector;
        if (conditionColumnVector.isRepeating) {
            if (conditionVector[0] == 1L) {
                outputColVector.fill(this.thenValue);
            } else {
                outputColVector.fill(this.elseValue);
            }
            return;
        }
        if (conditionColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = conditionVector[i] == 1L ? this.thenValue : this.elseValue;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = conditionVector[i] == 1L ? this.thenValue : this.elseValue;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputVector[i] = !conditionIsNull[i] && conditionVector[i] == 1L ? this.thenValue : this.elseValue;
                outputIsNull[i] = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = !conditionIsNull[i] && conditionVector[i] == 1L ? this.thenValue : this.elseValue;
                Arrays.fill(outputIsNull, 0, n, false);
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType.toString());
        trace.attribute("columnNo", this.columnNo);
        trace.attribute(ATTRIBUTE_THENVALUE, this.thenValue);
        trace.attribute(ATTRIBUTE_ELSEVALUE, this.elseValue);
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }
}

