/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorIntervalColumnDivideDoubleScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private double value;
    private int outputColumnNo;
    private TimestampUtil tsUtil = new TimestampUtil();

    public XVectorIntervalColumnDivideDoubleScalar(int inColumnNo, double theValue, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.value = theValue;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        IntervalColumnVector inputColumnVector = (IntervalColumnVector)batch.columns[this.columnNo];
        IntervalColumnVector outputColumnVector = (IntervalColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColumnVector.isNull;
        outputColumnVector.noNulls = inputColumnVector.noNulls;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        IntervalColumnVector.IntervalStruct[] vector = inputColumnVector.vector;
        if (inputColumnVector.isRepeating) {
            this.tsUtil.divide(0, vector[0], this.value, outputColumnVector);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    this.tsUtil.divide(i, vector[i], this.value, outputColumnVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.tsUtil.divide(i, vector[i], this.value, outputColumnVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                this.tsUtil.divide(i, vector[i], this.value, outputColumnVector);
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.tsUtil.divide(i, vector[i], this.value, outputColumnVector);
                outputIsNull[i] = inputIsNull[i];
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType.toString());
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = Long.valueOf(inputNode.attributeValue("value")).longValue();
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        super.capture(env, inputNode);
    }
}

