/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;

public class XVectorIntervalScalarAddDateColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private IntervalColumnVector.IntervalStruct value;
    private int columnNo;
    private int outputColumnNo;
    private TimestampUtil tsUtil = new TimestampUtil();

    public XVectorIntervalScalarAddDateColumn(IntervalColumnVector.IntervalStruct inValue, int inColumnNo, int inOutputColumnNo) {
        this.value = inValue;
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        LongColumnVector inputColumnVector = (LongColumnVector)batch.columns[this.columnNo];
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        long[] vector = inputColumnVector.vector;
        outputColumnVector.noNulls = inputColumnVector.noNulls;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColumnVector.isNull;
        if (inputColumnVector.isRepeating) {
            this.tsUtil.add(0, this.value, vector[0], outputColumnVector);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    this.tsUtil.add(i, this.value, vector[i], outputColumnVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.tsUtil.add(i, this.value, vector[i], outputColumnVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                if (!inputIsNull[i]) {
                    this.tsUtil.add(i, this.value, vector[i], outputColumnVector);
                }
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inputIsNull[i]) {
                    this.tsUtil.add(i, this.value, vector[i], outputColumnVector);
                }
                outputIsNull[i] = inputIsNull[i];
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("outputColumnNo", this.outputColumnNo);
        trace.attribute("dataType", this.dataType.toString());
    }
}

