/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.ArrayUtil;
import org.dom4j.Element;

public class XVectorLongColumnNullIfDoubleScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;
    private double value;

    public XVectorLongColumnNullIfDoubleScalar() {
    }

    public XVectorLongColumnNullIfDoubleScalar(int inColumnNo, double inValue, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.value = inValue;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        LongColumnVector inputColumnVector = (LongColumnVector)batch.columns[this.columnNo];
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColumnVector.isNull;
        long[] vector1 = inputColumnVector.vector;
        long[] vector2 = outputColumnVector.vector;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        if (inputColumnVector.isRepeating) {
            outputIsNull[0] = inputIsNull[0] || this.isEqual(vector1[0], this.value);
            vector2[0] = vector1[0];
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputIsNull[i] = this.isEqual(vector1[i], this.value);
                    vector2[i] = vector1[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputIsNull[i] = this.isEqual(vector1[i], this.value);
                    vector2[i] = vector1[i];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputIsNull[i] = inputIsNull[i] || this.isEqual(vector1[i], this.value);
                vector2[i] = vector1[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputIsNull[i] = inputIsNull[i] || this.isEqual(vector1[i], this.value);
                vector2[i] = vector1[i];
            }
        }
        outputColumnVector.noNulls = !ArrayUtil.contains(outputIsNull, true);
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.columnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = Long.valueOf(inputNode.attributeValue("value")).longValue();
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        this.setDataType(DataTypeFactory.getType(inputNode.attribute("dataType").getValue()));
        super.capture(env, inputNode);
    }

    private boolean isEqual(long parm1, double parm2) {
        return (double)parm1 == parm2;
    }
}

