/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.NullUtil;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorTimestampColumnAddIntervalColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int leftColumnNo;
    private int rightColumnNo;
    private int outputColumnNo;
    private TimestampUtil tsUtil = new TimestampUtil();

    public XVectorTimestampColumnAddIntervalColumn(int inLeftColumnNo, int inRightColumnNo, int inOutputColumnNo) {
        this.leftColumnNo = inLeftColumnNo;
        this.rightColumnNo = inRightColumnNo;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        TimestampColumnVector inputColVector1 = (TimestampColumnVector)batch.columns[this.leftColumnNo];
        IntervalColumnVector inputColVector2 = (IntervalColumnVector)batch.columns[this.rightColumnNo];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        TimestampColumnVector.UnixTimestamp[] vector1 = inputColVector1.vector;
        IntervalColumnVector.IntervalStruct[] vector2 = inputColVector2.vector;
        outputColVector.isRepeating = inputColVector1.isRepeating && inputColVector2.isRepeating || inputColVector1.isRepeating && !inputColVector1.noNulls && inputColVector1.isNull[0] || inputColVector2.isRepeating && !inputColVector2.noNulls && inputColVector2.isNull[0];
        NullUtil.propagateNulls(inputColVector1, inputColVector2, outputColVector, selected, n, batch.selectedInUse);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            this.tsUtil.add(0, vector1[0], vector2[0], outputColVector);
        } else if (inputColVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    this.tsUtil.add(i, vector1[0], vector2[i], outputColVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.tsUtil.add(i, vector1[0], vector2[i], outputColVector);
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    this.tsUtil.add(i, vector1[i], vector2[0], outputColVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.tsUtil.add(i, vector1[i], vector2[0], outputColVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                this.tsUtil.add(i, vector1[i], vector2[i], outputColVector);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.tsUtil.add(i, vector1[i], vector2[i], outputColVector);
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("leftColumnNo", this.leftColumnNo);
        trace.attribute("rightColumnNo", this.rightColumnNo);
        trace.attribute("outputColumnNo", this.outputColumnNo);
        trace.attribute("dataType", this.dataType.toString());
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
        this.leftColumnNo = Integer.valueOf(inputNode.attributeValue("leftColumnNo"));
        this.rightColumnNo = Integer.valueOf(inputNode.attributeValue("rightColumnNo"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        super.capture(env, inputNode);
    }
}

