/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.ArrayUtil;

public class XVectorTimestampColumnNullIfTimestampScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private TimestampColumnVector.UnixTimestamp value;
    private int outputColumnNo;

    public XVectorTimestampColumnNullIfTimestampScalar(int inColumnNo, TimestampColumnVector.UnixTimestamp inValue, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.value = inValue;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        TimestampColumnVector inputColumnVector = (TimestampColumnVector)batch.columns[this.columnNo];
        TimestampColumnVector outputColumnVector = (TimestampColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColumnVector.isNull;
        TimestampColumnVector.UnixTimestamp[] vector1 = inputColumnVector.vector;
        TimestampColumnVector.UnixTimestamp[] vector2 = outputColumnVector.vector;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        if (inputColumnVector.isRepeating) {
            outputIsNull[0] = inputIsNull[0] || vector1[0].compareTo(this.value) == 0;
            vector2[0] = vector1[0];
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputIsNull[i] = vector1[i].compareTo(this.value) == 0;
                    vector2[i] = vector1[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputIsNull[i] = vector1[i].compareTo(this.value) == 0;
                    vector2[i] = vector1[i];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputIsNull[i] = inputIsNull[i] || vector1[i].compareTo(this.value) == 0;
                vector2[i] = vector1[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputIsNull[i] = inputIsNull[i] || vector1[i].compareTo(this.value) == 0;
                vector2[i] = vector1[i];
            }
        }
        outputColumnVector.noNulls = !ArrayUtil.contains(outputIsNull, true);
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.outputColumnNo);
        trace.attribute("dataType", this.dataType.toString());
    }
}

