/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.regex;

import com.cognos.xqe.runtree.relational.vectorization.expressions.XVectorStringFunction;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.adapters.dom.DOMAdapter;
import com.ibm.xml.xci.exec.BasicMutableDynamicContext;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.NodeList;

public class XVectorSubstringRegex
extends XVectorStringFunction {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_PATTERN = "pattern";
    private static final String ATTRIBUTE_FROM = "from";
    private static final String ATTRIBUTE_OCCURRENCE = "occurrence";
    private static final String ATTRIBUTE_FLAGS = "flags";
    private static QName p = new QName("regex");
    private static QName f = new QName("flags");
    private SessionContext session;
    private CursorFactory factory;
    private StaticContext staticCxt;
    private Executable xsltExec;
    private String pattern;
    private int fromPos;
    private int occurrence;
    private String flags;
    private boolean nullArgs;

    public XVectorSubstringRegex(String inPattern, int columnNo, int outputColumnNo) {
        this(inPattern, columnNo, 1, 1, "", outputColumnNo);
    }

    public XVectorSubstringRegex(String inPattern, int columnNo, Object inFromPos, int outputColumnNo) {
        this(inPattern, columnNo, inFromPos, 1, "", outputColumnNo);
    }

    public XVectorSubstringRegex(String inPattern, int columnNo, Object inFromPos, Object inOccurrence, int outputColumnNo) {
        this(inPattern, columnNo, inFromPos, inOccurrence, "", outputColumnNo);
    }

    public XVectorSubstringRegex(String inPattern, int columnNo, Object inFromPos, Object inOccurrence, String inFlags, int outputColumnNo) {
        super(columnNo, outputColumnNo);
        this.session = new SessionContext((ClassLoader)null);
        this.factory = this.session.getSimpleDataFactory();
        this.staticCxt = new BasicStaticContext(this.session.getTypeRegistry());
        this.staticCxt.setLanguageTypeAndVersion(5);
        this.staticCxt.setBaseURI(System.getProperty("user.dir"));
        Preparer preparer = this.session.getPreparer(RequestInfo.XSLT2);
        this.xsltExec = preparer.prepare("<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:stylesheet version=\"2.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">  <xsl:output indent=\"yes\" method=\"xml\"/>  <xsl:param name=\"regex\" as=\"xs:string\"/>  <xsl:param name=\"flags\" as=\"xs:string\"/>  <xsl:template match=\"/\">    <xsl:analyze-string select=\"source\" regex=\"{$regex}\" flags=\"{$flags}\">      <xsl:matching-substring>        <match>          <xsl:value-of select=\".\"/>        </match>      </xsl:matching-substring>      <xsl:non-matching-substring/>    </xsl:analyze-string>  </xsl:template></xsl:stylesheet>", this.staticCxt, -1);
        this.pattern = inPattern;
        this.flags = inFlags;
        if (inPattern == null || inFromPos == null || inOccurrence == null || inFlags == null) {
            this.nullArgs = true;
        } else {
            this.fromPos = ((Number)inFromPos).intValue();
            this.occurrence = ((Number)inOccurrence).intValue();
        }
        this.function = new SubstringRegexFunction();
    }

    public XVectorSubstringRegex() {
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.attribute(ATTRIBUTE_PATTERN, this.pattern);
        if (this.fromPos > 0) {
            trace.attribute(ATTRIBUTE_FROM, String.valueOf(this.fromPos));
        }
        if (this.occurrence > 0) {
            trace.attribute(ATTRIBUTE_OCCURRENCE, String.valueOf(this.occurrence));
        }
        if (this.flags != null && !this.flags.isEmpty()) {
            trace.attribute(ATTRIBUTE_FLAGS, this.flags);
        }
    }

    private class SubstringRegexFunction
    implements XVectorStringFunction.IUnaryStringFunction {
        private SubstringRegexFunction() {
        }

        @Override
        public String evaluate(String s) {
            if (s == null || XVectorSubstringRegex.this.nullArgs) {
                return null;
            }
            String result = null;
            String source = StringSubstitutionEngine.escapeString(s);
            if (XVectorSubstringRegex.this.fromPos > 1) {
                source = source.substring(XVectorSubstringRegex.this.fromPos - 1);
            }
            source = String.format("<source>%s</source>", source);
            BasicMutableDynamicContext dynamicCxt = new BasicMutableDynamicContext(XVectorSubstringRegex.this.session, XVectorSubstringRegex.this.staticCxt);
            dynamicCxt.bindVariable(p, XVectorSubstringRegex.this.factory.sequence((CharSequence)XVectorSubstringRegex.this.pattern, null, false));
            dynamicCxt.bindVariable(f, XVectorSubstringRegex.this.factory.sequence((CharSequence)XVectorSubstringRegex.this.flags, null, false));
            RequestInfo request = new RequestInfo(Cursor.RANDOM_ACCESS, XVectorSubstringRegex.this.staticCxt);
            StreamSource document = new StreamSource(new StringReader(source));
            Cursor contextDoc = XVectorSubstringRegex.this.session.document((Source)document, request);
            DOMAdapter.DOMCursor cursor = (DOMAdapter.DOMCursor)XVectorSubstringRegex.this.xsltExec.execute(contextDoc, (DynamicContext)dynamicCxt, Cursor.RANDOM_ACCESS, null);
            if (cursor != null) {
                NodeList nodeList = cursor.getNode().getChildNodes();
                if (XVectorSubstringRegex.this.occurrence <= nodeList.getLength()) {
                    result = nodeList.item(XVectorSubstringRegex.this.occurrence - 1).getTextContent();
                }
            }
            cursor.release();
            return result;
        }
    }
}

