/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.set;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSetFunction;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorAggregateAvgInterval
extends XVectorSetFunction {
    private static final long serialVersionUID = 1L;
    private static TimestampUtil tsUtil = new TimestampUtil();

    public XVectorAggregateAvgInterval(int inputColumnNo) {
        super(inputColumnNo);
    }

    public XVectorAggregateAvgInterval() {
    }

    @Override
    public XVectorSetFunction.AggregateState getAggregateState() {
        return new State(this.dataType);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        trace.attribute("dataType", this.dataType);
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
    }

    private static final class State
    implements XVectorSetFunction.AggregateState {
        private IntervalColumnVector sumCv;
        private int count;
        private int nullCount;
        private int nonNullCount;
        private boolean isNull = true;

        private State(IDataType dataType) {
            this.sumCv = new IntervalColumnVector(dataType, false, 1);
        }

        @Override
        public void iterate(XDataContext context, ColumnVector inputVector, int index) {
            IntervalColumnVector.IntervalStruct value = ((IntervalColumnVector)inputVector).vector[index];
            ++this.count;
            if (inputVector.isNull[index]) {
                ++this.nullCount;
                return;
            }
            if (this.isNull) {
                this.sumCv.set(0, value);
                this.isNull = false;
            } else {
                tsUtil.add(0, this.sumCv.vector[0], value, this.sumCv);
            }
            ++this.nonNullCount;
        }

        @Override
        public void iterateNoNulls(XDataContext context, ColumnVector inputVector, int index) {
            IntervalColumnVector.IntervalStruct value = ((IntervalColumnVector)inputVector).vector[index];
            ++this.count;
            if (this.isNull) {
                this.sumCv.set(0, value);
                this.isNull = false;
            } else {
                tsUtil.add(0, this.sumCv.vector[0], value, this.sumCv);
            }
            ++this.nonNullCount;
        }

        @Override
        public void getResult(XDataContext context, XVectorRowBatch batch, int targetIndex) {
            IntervalColumnVector outputColumnVector = (IntervalColumnVector)batch.columns[targetIndex];
            if (this.isNull) {
                outputColumnVector.setNull(batch.size);
            } else {
                tsUtil.divide(batch.size, this.sumCv.vector[0], this.nonNullCount, outputColumnVector);
            }
        }

        @Override
        public void reset() {
            this.isNull = true;
        }
    }
}

