/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.set;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSetFunction;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorAggregateStdDevSampDecimal
extends XVectorSetFunction {
    private static final long serialVersionUID = 1L;

    public XVectorAggregateStdDevSampDecimal(int inputColumnNo) {
        super(inputColumnNo);
    }

    public XVectorAggregateStdDevSampDecimal() {
    }

    @Override
    public XVectorSetFunction.AggregateState getAggregateState() {
        return new State();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        trace.attribute("dataType", this.dataType);
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
    }

    private static final class State
    implements XVectorSetFunction.AggregateState {
        private double sum;
        private double sumOfSquares;
        private int count;
        private int nullCount;

        private State() {
        }

        @Override
        public void iterate(XDataContext context, ColumnVector inputVector, int index) {
            double value = ((DecimalColumnVector)inputVector).vector[index].doubleValue();
            ++this.count;
            if (inputVector.isNull[index]) {
                ++this.nullCount;
                return;
            }
            this.sum += value;
            this.sumOfSquares += value * value;
        }

        @Override
        public void iterateNoNulls(XDataContext context, ColumnVector inputVector, int index) {
            double value = ((DecimalColumnVector)inputVector).vector[index].doubleValue();
            ++this.count;
            this.sum += value;
            this.sumOfSquares += value * value;
        }

        @Override
        public void getResult(XDataContext context, XVectorRowBatch batch, int targetIndex) {
            DoubleColumnVector outputColumnVector = (DoubleColumnVector)batch.columns[targetIndex];
            int nonNullCount = this.count - this.nullCount;
            if (this.count == 0 || nonNullCount == 0) {
                outputColumnVector.setNull(batch.size);
            } else if (nonNullCount == 1) {
                outputColumnVector.setNull(batch.size);
            } else {
                double d1 = this.sum * this.sum / (double)nonNullCount;
                double d2 = (this.sumOfSquares - d1) / (double)(nonNullCount - 1);
                outputColumnVector.vector[batch.size] = Math.sqrt(d2);
            }
        }

        @Override
        public void reset() {
            this.sum = 0.0;
            this.sumOfSquares = 0.0;
            this.count = 0;
            this.nullCount = 0;
        }
    }
}

