/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.v5.V5ResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class V5MappedEdgeIterator
extends XIterator {
    V5ResultSet mThisV5ResultSet;
    private XIterator mEdgeIterator;
    protected RSAPIEdge mEdge;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public V5MappedEdgeIterator(XDataContext dataContext, V5ResultSet v5ResultSet, RSAPIEdge edge, XIterator edgeIterator, Integer id) {
        super(dataContext, id);
        this.mThisV5ResultSet = v5ResultSet;
        this.mEdgeIterator = edgeIterator;
        this.mEdge = edge;
    }

    @Override
    public void release() {
        if (this.mEdgeIterator != null) {
            try {
                this.mEdgeIterator.release();
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
            }
            finally {
                this.mEdgeIterator = null;
            }
        }
    }

    @Override
    public Object nextImpl() {
        long baseEdgeOrdinal = this.mThisV5ResultSet.mapV5EdgeOrdinal(this.mEdge, this.currentIndex + 1L);
        if (this.mEdgeIterator.getIndex() >= baseEdgeOrdinal) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_XQEQueryNodeInternalError_INTERNAL, "V5MappedEdgeIterator", "ordinal not monotonically increasing");
        }
        while (this.mEdgeIterator.getIndex() < baseEdgeOrdinal - 1L) {
            Object o = this.mEdgeIterator.nextImpl();
            if (o != null) continue;
            return null;
        }
        RowValue rowValue = (RowValue)this.mEdgeIterator.nextImpl();
        if (rowValue != null) {
            ++this.currentIndex;
            rowValue = this.mThisV5ResultSet.processV5Row(this.mEdge, this.currentIndex, rowValue);
        }
        return rowValue;
    }
}

