/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.function.ISetFunction;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.set.Avg;
import com.cognos.xqe.function.set.Count;
import com.cognos.xqe.function.set.Max;
import com.cognos.xqe.function.set.Min;
import com.cognos.xqe.function.set.Sum;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.virtual.VirtualMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.HResultSetException;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.CubeHybridResultSet;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.runtree.ValueList;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.CalcMemberReferencePrefixes;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XV5ListSummary
extends XNode {
    private static final long serialVersionUID = 0L;
    public static final String NODE_TYPE_NAME = "XV5ListSummary";
    private static final String V5LISTSUMMARYSPEC = "V5ListSummarySpec";
    private static final String EDGENUM = "EdgeNum";
    private static final String ROWSETID = "RowsetId";
    private static final String DATAITEMINDEX = "DataItemIndex";
    private static final String SUMMARYFUNCTION = "SummaryFunction";
    private static final String DETAILROWSETID = "DetailRowsetId";
    private static final String DETAILDATAITEMINDEX = "DetailDataItemIndex";
    private static final String DISTINCT = "distinct";
    private static final int SCALE_FOR_AGGREGATES = 16;
    private List<XV5ListSummarySpec> mV5ListSummarySpecs = new ArrayList<XV5ListSummarySpec>();
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public void addListSummarySpec(int edgeNum, RSAPIRowset rowset, RSAPIDataItem dataItem, String summaryFunction, int detailRowsetId, int detailDataItemIndex, boolean bDistinct) {
        XV5ListSummarySpec v5DemoSpec = new XV5ListSummarySpec(edgeNum, rowset, dataItem, summaryFunction, detailRowsetId, detailDataItemIndex, bDistinct);
        this.mV5ListSummarySpecs.add(v5DemoSpec);
    }

    public void linkSummarySpec() {
        for (int i = 0; i < this.mV5ListSummarySpecs.size(); ++i) {
            XV5ListSummarySpec innerSpec = this.mV5ListSummarySpecs.get(i);
            RSAPIEdgeRowset breakRowset = innerSpec.getBreakMemberRowset();
            RSAPIEdgeRowset footerRowsetOfBreakRowset = null;
            if (null == breakRowset || null == (footerRowsetOfBreakRowset = breakRowset.getFooterRowset())) continue;
            for (int j = 0; j < i; ++j) {
                XV5ListSummarySpec outerSpec = this.mV5ListSummarySpecs.get(j);
                if (footerRowsetOfBreakRowset.getRowsetId() != outerSpec.getRowsetId() || innerSpec.getOuterSummarySpec() != null) continue;
                innerSpec.setOuterSummarySpec(outerSpec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IValue executeImpl(XDataContext context) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DQExecuteRuntree", this.getNodeTypeName(), ZipiContext.getQRDName());
        try {
            for (int idx = 0; idx < this.mV5ListSummarySpecs.size(); ++idx) {
                XV5ListSummarySpec rule = this.mV5ListSummarySpecs.get(idx);
                rule.initializeSummary(context);
            }
            this.linkSummarySpec();
            CubeHybridResultSet sourceV5Result = (CubeHybridResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
            XV5ListSummaryResultSet xV5ListSummaryResultSet = new XV5ListSummaryResultSet(context, sourceV5Result);
            return xV5ListSummaryResultSet;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    @Override
    public int getType() {
        return 501086;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 501086) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List v5DemoSpecsList = inputNode.elements(V5LISTSUMMARYSPEC);
        ListIterator it = v5DemoSpecsList.listIterator();
        int i = 0;
        while (it.hasNext()) {
            Element anElement = (Element)it.next();
            int edgeNum = Integer.parseInt(anElement.attributeValue(EDGENUM));
            int rowsetId = Integer.parseInt(anElement.attributeValue(ROWSETID));
            int dataItemIndex = Integer.parseInt(anElement.attributeValue(DATAITEMINDEX));
            String summaryFunction = anElement.attributeValue(SUMMARYFUNCTION);
            int detailRowsetId = Integer.parseInt(anElement.attributeValue(DETAILROWSETID));
            int detailDataItemIndex = Integer.parseInt(anElement.attributeValue(DETAILDATAITEMINDEX));
            boolean bDistinct = Boolean.parseBoolean(anElement.attributeValue(DISTINCT));
            new XV5ListSummarySpec(edgeNum, rowsetId, dataItemIndex, summaryFunction, detailRowsetId, detailDataItemIndex, bDistinct);
            it.remove();
            ++i;
        }
        super.capture(env, inputNode);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        for (XV5ListSummarySpec v5DemoSpec : this.mV5ListSummarySpecs) {
            trace.beginElement(V5LISTSUMMARYSPEC, -1);
            trace.attribute(EDGENUM, Integer.toString(v5DemoSpec.getEdgeNum()));
            trace.attribute(ROWSETID, Integer.toString(v5DemoSpec.getRowsetId()));
            trace.attribute(DATAITEMINDEX, Integer.toString(v5DemoSpec.getDataItemIndex()));
            trace.attribute(SUMMARYFUNCTION, v5DemoSpec.getSummaryFunction());
            trace.attribute(DETAILROWSETID, Integer.toString(v5DemoSpec.getDEtailRowsetId()));
            trace.attribute(DETAILDATAITEMINDEX, Integer.toString(v5DemoSpec.getDetailDataItemIndex()));
            trace.attribute(DISTINCT, Boolean.toString(v5DemoSpec.getDistinct()));
            trace.endElement(-1);
        }
    }

    public void release() {
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        super.restoreAttributeProperty(ctx, att, inputNode);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }

    public final class XV5ListSummarySpec {
        public static final String SUMMARY_SUM = "sum";
        public static final String SUMMARY_MIN = "min";
        public static final String SUMMARY_MAX = "max";
        public static final String SUMMARY_AVG = "avg";
        public static final String SUMMARY_COUNT = "count";
        private XV5ListSummarySpec mOuterSummarySpec;
        private boolean mIsOuterMostSummarySpec;
        private int mEdgeNum;
        private RSAPIRowset mRowset;
        private int mRowsetId;
        private int mDataItemIndex;
        private String mSummaryFunction;
        private int mDetailRowSetId;
        private int mDetailDataItemIndex;
        private RSAPIEdgeRowset mBreakForRowset;
        private int mBreakForRowsetId;
        private boolean mBreakFound = false;
        private boolean mDistinct;
        private ContextMember mCurrentBreakValue = null;
        private XDataContext summaryContext = null;
        private ISetFunctionState summaryState = null;
        private ISetFunction summaryFunction = null;
        private ContextValue lastDetailValue = null;
        private boolean bInitialized = false;
        private ValueList valueList = new ValueList();
        Set<FormatId> operandIds = new HashSet<FormatId>();

        protected XV5ListSummarySpec(int edgeNum, RSAPIRowset rowset, RSAPIDataItem dataItem, String summaryFunctionString, int detailRowsetId, int detailDataItemIndex, boolean bDistinct) {
            this.mEdgeNum = edgeNum;
            this.mRowset = rowset;
            this.mRowsetId = rowset.getRowsetId();
            this.mDataItemIndex = rowset.getDataItemOrdinal(dataItem);
            this.mBreakForRowset = ((RSAPIEdgeRowset)this.mRowset).getParentRowset();
            if (this.mBreakForRowset == null) {
                this.mIsOuterMostSummarySpec = true;
            }
            this.mSummaryFunction = summaryFunctionString;
            this.mDetailRowSetId = detailRowsetId;
            this.mDetailDataItemIndex = detailDataItemIndex;
            this.mDistinct = bDistinct;
        }

        protected XV5ListSummarySpec(int edgeNum, int rowsetId, int dataItemIndex, String summaryFunctionString, int detailRowsetId, int detailDataItemIndex, boolean bDistinct) {
            this.mEdgeNum = edgeNum;
            this.mRowsetId = rowsetId;
            this.mDataItemIndex = dataItemIndex;
            this.mSummaryFunction = summaryFunctionString;
            this.mDetailRowSetId = detailRowsetId;
            this.mDetailDataItemIndex = detailDataItemIndex;
            this.mDistinct = bDistinct;
        }

        protected int getEdgeNum() {
            return this.mEdgeNum;
        }

        protected RSAPIRowset getRowset() {
            return this.mRowset;
        }

        protected int getRowsetId() {
            return this.mRowsetId;
        }

        protected boolean isOuterMostSummarySpec() {
            return this.mIsOuterMostSummarySpec;
        }

        protected RSAPIEdgeRowset getBreakMemberRowset() {
            return this.mBreakForRowset;
        }

        protected int getBreakMemberRowsetId() {
            return this.mBreakForRowsetId;
        }

        protected int getDataItemIndex() {
            return this.mDataItemIndex;
        }

        protected int getDEtailRowsetId() {
            return this.mDetailRowSetId;
        }

        protected int getDetailDataItemIndex() {
            return this.mDetailDataItemIndex;
        }

        protected boolean getDistinct() {
            return this.mDistinct;
        }

        protected String getSummaryFunction() {
            return this.mSummaryFunction;
        }

        protected boolean isMatchingDetailRule(ContextBase aColumn) {
            ContextBase context = null;
            if (!(aColumn instanceof ContextBase)) {
                return false;
            }
            context = aColumn;
            return context.getRowset() != null && this.mDetailDataItemIndex == context.getDataItemIndex() && this.mDetailRowSetId == context.getRowset().getRowsetId() && this.mEdgeNum == context.getEdgeOrdinal();
        }

        protected boolean isMatchingSummaryRule(ContextBase member) {
            ContextBase context = null;
            if (!(member instanceof ContextBase)) {
                return false;
            }
            context = member;
            RSAPIRowset contextMemberRowset = member.getRowset();
            if (contextMemberRowset == null) {
                return false;
            }
            if (this.isOuterMostSummarySpec()) {
                return false;
            }
            this.mBreakForRowsetId = this.mBreakForRowset.getRowsetId();
            if (this.mBreakForRowsetId == context.getRowset().getRowsetId() && this.mEdgeNum == context.getEdgeOrdinal()) {
                return !context.contextIsAMember() || !((ContextMember)context).isFillerMember();
            }
            return false;
        }

        protected boolean checkRaggedOrOuterMostHeaderSummary(List<IRow> headerRowBuffer) {
            if (this.mCurrentBreakValue == null && headerRowBuffer.isEmpty()) {
                return true;
            }
            if (this.mCurrentBreakValue != null && !headerRowBuffer.isEmpty()) {
                return true;
            }
            if (this.mCurrentBreakValue != null) {
                if (!this.mCurrentBreakValue.isFillerMember()) {
                    return true;
                }
                RSAPIEdgeRowset childRowsetofBreak = this.mBreakForRowset.getNestedRowset();
                if (null != childRowsetofBreak && childRowsetofBreak.getRowsetId() == this.mDetailRowSetId) {
                    return true;
                }
            }
            return false;
        }

        protected boolean isMatchingBreakRule(ContextMember contextMember) {
            if (this.isOuterMostSummarySpec()) {
                return false;
            }
            this.mBreakForRowsetId = this.mBreakForRowset.getRowsetId();
            RSAPIRowset contextMemberRowset = contextMember.getRowset();
            if (contextMemberRowset == null) {
                return false;
            }
            if (this.mBreakForRowsetId == contextMemberRowset.getRowsetId() && this.mEdgeNum == contextMember.getEdgeOrdinal()) {
                if (this.mCurrentBreakValue == null) {
                    this.mCurrentBreakValue = new ContextMember();
                    this.mCurrentBreakValue.copyFrom(contextMember);
                    return false;
                }
                if (!this.mCurrentBreakValue.equals(contextMember) || null != this.mOuterSummarySpec && this.mOuterSummarySpec.mBreakFound) {
                    this.mBreakFound = true;
                    return true;
                }
            }
            return false;
        }

        protected void setCachedBreakMember(ContextMember contextMember) {
            this.mCurrentBreakValue.copyFrom(contextMember);
        }

        protected void resetBreakFound() {
            this.mBreakFound = false;
        }

        protected void setOuterSummarySpec(XV5ListSummarySpec outerSpec) {
            this.mOuterSummarySpec = outerSpec;
        }

        protected XV5ListSummarySpec getOuterSummarySpec() {
            return this.mOuterSummarySpec;
        }

        protected ContextMember getCachedBreakMember() {
            return this.mCurrentBreakValue;
        }

        public void resetBreakMember() {
            this.mCurrentBreakValue = null;
        }

        protected ContextValue applySummary(ContextBase ithColumnMember) {
            ContextValue contextValue = new ContextValue();
            if (this.lastDetailValue != null) {
                contextValue.copyFrom(this.lastDetailValue);
            }
            contextValue.setContextMember(null);
            contextValue.setRowset(this.mRowset);
            contextValue.setDataItemIndex(this.mDataItemIndex);
            NumericValue output = this.getNewSummaryValue();
            if (this.mSummaryFunction.compareToIgnoreCase(SUMMARY_SUM) == 0 || this.mSummaryFunction.compareToIgnoreCase(SUMMARY_AVG) == 0 || this.mSummaryFunction.compareToIgnoreCase(SUMMARY_MIN) == 0 || this.mSummaryFunction.compareToIgnoreCase(SUMMARY_MAX) == 0) {
                FormatService service = FormatService.getInstance();
                FormatId resultFormatId = FormatId.DEFAULT_NUMBER_FORMAT_FID;
                if (this.mSummaryFunction.compareToIgnoreCase(SUMMARY_SUM) == 0) {
                    ArrayList<FormatId> operandsIdsList = new ArrayList<FormatId>(this.operandIds);
                    resultFormatId = service.formatResult("Sum", operandsIdsList);
                } else if (this.mSummaryFunction.compareToIgnoreCase(SUMMARY_AVG) == 0) {
                    ArrayList<FormatId> operandsIdsList = new ArrayList<FormatId>(this.operandIds);
                    resultFormatId = Avg.AvgFormatManager.calculateFormatId(operandsIdsList);
                } else if (this.mSummaryFunction.compareToIgnoreCase(SUMMARY_MAX) == 0 || this.mSummaryFunction.compareToIgnoreCase(SUMMARY_MIN) == 0) {
                    resultFormatId = this.operandIds.iterator().next();
                }
                output.setFormatId(resultFormatId);
            }
            this.summaryFunction.getResult(this.summaryContext, this.summaryState, output);
            this.summaryFunction.terminate(this.summaryContext, this.summaryState);
            contextValue.setValue(output);
            this.resetSummary();
            return contextValue;
        }

        protected boolean summarizeDetail(IValue column) {
            IValue cellValue = null;
            if (!(column instanceof ContextBase)) {
                return false;
            }
            cellValue = this.getValue((ContextBase)((Object)column));
            if (cellValue instanceof Value) {
                this.operandIds.add(((Value)cellValue).getFormatId());
            }
            if (this.bInitialized) {
                this.resetSummary();
                this.bInitialized = false;
            }
            this.valueList.clear();
            this.valueList.add(cellValue);
            this.summaryFunction.iterate(this.summaryContext, this.summaryState, this.valueList);
            return false;
        }

        private IValue getValue(ContextBase context) {
            IValue value = null;
            if (context instanceof ContextValue) {
                this.lastDetailValue = (ContextValue)context;
                value = this.lastDetailValue.getValue();
            } else {
                value = ((ContextMember)context).getMember();
                if (this.summaryFunction.isDistinct() && value.getDataType() == null) {
                    value = DataValueFactory.createStringValue();
                    ((StringValue)value).set(((ContextMember)context).getUniqueName());
                }
            }
            return value;
        }

        private void resetSummary() {
            this.summaryState = this.mSummaryFunction.compareToIgnoreCase(SUMMARY_COUNT) == 0 ? this.summaryFunction.initialize(this.summaryContext, this.valueList, DataTypeFactory.getIntegerType()) : this.summaryFunction.initialize(this.summaryContext, this.valueList, DataTypeFactory.getDoubleType());
        }

        private NumericValue getNewSummaryValue() {
            if (this.mSummaryFunction.compareToIgnoreCase(SUMMARY_COUNT) == 0) {
                return DataValueFactory.createIntegerValue();
            }
            return DataValueFactory.createDecimalValue(DataTypeFactory.getDecimalType(256, 16));
        }

        protected void initializeSummary(XDataContext context) {
            this.summaryContext = context;
            if (this.mSummaryFunction.compareToIgnoreCase(SUMMARY_SUM) == 0) {
                this.summaryFunction = new Sum();
            } else if (this.mSummaryFunction.compareToIgnoreCase(SUMMARY_MIN) == 0) {
                this.summaryFunction = new Min();
            } else if (this.mSummaryFunction.compareToIgnoreCase(SUMMARY_MAX) == 0) {
                this.summaryFunction = new Max();
            } else if (this.mSummaryFunction.compareToIgnoreCase(SUMMARY_AVG) == 0) {
                this.summaryFunction = new Avg();
            } else if (this.mSummaryFunction.compareToIgnoreCase(SUMMARY_COUNT) == 0) {
                this.summaryFunction = new Count();
            }
            this.summaryFunction.setDistinct(this.mDistinct);
            this.bInitialized = true;
        }
    }

    private class XV5ListSummaryResultSet
    extends CubeHybridResultSet {
        protected ICubeResultSet originalDimensionalResult;

        XV5ListSummaryResultSet(XDataContext context, ICubeResultSet sourceResult) {
            super(context, sourceResult, XV5ListSummary.this.getId(), CacheHints.cacheNone());
            this.originalDimensionalResult = sourceResult;
        }

        @Override
        public ITabularIterator getTabularIterator() {
            this.resetBreaks();
            this.resetSummaries();
            return new V5ListSummaryMDTabularIterator(this.getDataContext(), XV5ListSummary.this.getId());
        }

        @Override
        public int getNumAxes() {
            return 1;
        }

        public void resetBreaks() {
            for (XV5ListSummarySpec aSpec : XV5ListSummary.this.mV5ListSummarySpecs) {
                aSpec.resetBreakMember();
                aSpec.resetBreakFound();
            }
        }

        public void resetSummaries() {
            for (XV5ListSummarySpec aSpec : XV5ListSummary.this.mV5ListSummarySpecs) {
                aSpec.resetSummary();
            }
        }

        public void resetBreakFound() {
            for (XV5ListSummarySpec aSpec : XV5ListSummary.this.mV5ListSummarySpecs) {
                aSpec.resetBreakFound();
            }
        }

        @Override
        public void releaseImpl() {
            if (this.originalDimensionalResult != null) {
                this.originalDimensionalResult.release();
                this.originalDimensionalResult = null;
            }
            super.releaseImpl();
        }

        private final class V5ListSummaryMDTabularIterator
        extends XTabularIterator {
            private boolean mEod;
            protected ITabularIterator sourceTabularIterator;
            private SortedMap<Integer, List<IValue>> rowItems;
            private SortedMap<Integer, List<IValue>> summaries;
            private Stack<IRow> summaryRowBuffer;
            private Stack<IRow> detailRowBuffer;
            private List<IRow> headerFillerRowBuffer;
            private SortedMap<Integer, IMetadata> rowMemberIndexMetadataMap;
            private Map<IMetadata, ContextMember> rowMetadataContextMemberMap;
            private RowValue mRowCache;
            private boolean isHeader;
            private boolean isEmptySummary;
            private boolean isFillerRow;
            private static final String FILLER_MEMBER = "FillerMember";

            private V5ListSummaryMDTabularIterator(XDataContext xDataContext, Integer theNodeId) {
                super(xDataContext, theNodeId);
                this.mEod = false;
                this.rowItems = new TreeMap<Integer, List<IValue>>();
                this.summaries = new TreeMap<Integer, List<IValue>>();
                this.summaryRowBuffer = new Stack();
                this.detailRowBuffer = new Stack();
                this.headerFillerRowBuffer = new ArrayList<IRow>();
                this.rowMemberIndexMetadataMap = new TreeMap<Integer, IMetadata>();
                this.rowMetadataContextMemberMap = new HashMap<IMetadata, ContextMember>();
                this.isHeader = false;
                this.isEmptySummary = false;
                this.isFillerRow = false;
                if (XV5ListSummaryResultSet.this.originalDimensionalResult instanceof CubeHybridResultSet) {
                    this.sourceTabularIterator = ((CubeHybridResultSet)XV5ListSummaryResultSet.this.originalDimensionalResult).getTabularIterator();
                }
            }

            @Override
            public Object nextImpl() {
                if (this.mEod) {
                    return null;
                }
                IRow resultRow = this.fetchRowFromCache();
                if (null != resultRow) {
                    return resultRow;
                }
                IRow aRow = (IRow)this.sourceTabularIterator.next();
                List<ContextBase> flatMemberList = this.flattenContextMembersFromRow(aRow);
                if (this.isEmptySummary && aRow != null) {
                    return aRow;
                }
                while (null != aRow && (this.isHeader || this.isFillerRow)) {
                    if (null != this.mRowCache) {
                        this.headerFillerRowBuffer.add((IRow)aRow.copy());
                        aRow = (IRow)this.sourceTabularIterator.next();
                        flatMemberList = this.flattenContextMembersFromRow(aRow);
                        continue;
                    }
                    return aRow;
                }
                if (null != flatMemberList && this.rowMetadataContextMemberMap.size() < flatMemberList.size()) {
                    this.buildRowMetadataList(flatMemberList);
                }
                if (null != aRow && this.headerFillerRowBuffer.isEmpty()) {
                    resultRow = this.processRow(aRow, flatMemberList);
                    this.mRowCache = (RowValue)aRow.copy();
                }
                if (null != aRow && !this.headerFillerRowBuffer.isEmpty()) {
                    this.detailRowBuffer.add((IRow)aRow.copy());
                    flatMemberList = this.flattenContextMembersFromRow(this.mRowCache);
                    resultRow = this.processRestRows(this.mRowCache, flatMemberList);
                    XV5ListSummaryResultSet.this.resetBreaks();
                }
                if (aRow == null) {
                    flatMemberList = this.flattenContextMembersFromRow(this.mRowCache);
                    resultRow = this.processRestRows(this.mRowCache, flatMemberList);
                    if (this.summaryRowBuffer.isEmpty() && resultRow == null) {
                        XV5ListSummaryResultSet.this.resetBreaks();
                        this.mEod = true;
                        return null;
                    }
                    this.mRowCache = null;
                }
                return resultRow;
            }

            private IRow fetchRowFromCache() {
                IRow result = null;
                if (!this.summaryRowBuffer.isEmpty()) {
                    result = this.summaryRowBuffer.pop();
                }
                if (result == null && !this.headerFillerRowBuffer.isEmpty()) {
                    result = this.headerFillerRowBuffer.remove(0);
                }
                if (result == null && !this.detailRowBuffer.isEmpty()) {
                    IRow bufferRow = this.detailRowBuffer.pop();
                    this.mRowCache = (RowValue)bufferRow.copy();
                    result = this.processRow(bufferRow, this.flattenContextMembersFromRow(bufferRow));
                }
                return result;
            }

            private IRow constructRows() {
                Set<Integer> membersKeySet = this.rowItems.keySet();
                Iterator<Integer> memberIterator = membersKeySet.iterator();
                Set<Integer> summariesKeySet = this.summaries.keySet();
                for (Integer summaryKey : summariesKeySet) {
                    List measures = (List)this.summaries.get(summaryKey);
                    List members = (List)this.rowItems.get(summaryKey);
                    if (null != members) break;
                    int numSummarisOnRow = measures.size();
                    IValue[] values = new IValue[numSummarisOnRow];
                    RowValue aRow = DataValueFactory.createRowValue(values);
                    for (int i = 0; i < numSummarisOnRow; ++i) {
                        ContextValue aValue = (ContextValue)measures.get(i);
                        values[i] = aValue;
                    }
                    this.summaryRowBuffer.push(aRow);
                }
                while (memberIterator.hasNext()) {
                    Integer memberKey = memberIterator.next();
                    List members = (List)this.rowItems.get(memberKey);
                    List summariesForRowSet = (List)this.summaries.get(memberKey);
                    int numMembersRow = members.size();
                    int numSummarisOnRow = 0;
                    if (null == summariesForRowSet) {
                        this.rowItems.clear();
                        this.summaries.clear();
                        return null;
                    }
                    numSummarisOnRow = summariesForRowSet.size();
                    IValue[] values = new IValue[numMembersRow + numSummarisOnRow];
                    RowValue aRow = DataValueFactory.createRowValue(values);
                    for (int i = 0; i < numMembersRow; ++i) {
                        IValue aValue;
                        values[i] = aValue = (IValue)members.get(i);
                    }
                    int listIndex = 0;
                    for (int i = numMembersRow; i < values.length; ++i) {
                        ContextValue aValue = (ContextValue)summariesForRowSet.get(listIndex++);
                        int position = aValue.getDataItemIndex() + numMembersRow;
                        values[position] = aValue;
                    }
                    this.summaryRowBuffer.push(aRow);
                }
                this.rowItems.clear();
                this.summaries.clear();
                return this.summaryRowBuffer.pop();
            }

            public IRow processRow(IRow rowValue, List<ContextBase> flatMemberList) {
                if (flatMemberList == null) {
                    return rowValue;
                }
                this.buildContextMembersForSummaries(flatMemberList);
                IRow retRowValue = rowValue;
                for (XV5ListSummarySpec aRule : XV5ListSummary.this.mV5ListSummarySpecs) {
                    Integer currentRowsetKey = new Integer(aRule.getRowsetId());
                    for (int i = 0; i < flatMemberList.size(); ++i) {
                        List members = (List)this.rowItems.get(currentRowsetKey);
                        ContextBase ithMemberOfRow = flatMemberList.get(i);
                        if (null != members && aRule.isMatchingDetailRule(ithMemberOfRow)) {
                            ContextValue summaryValue = aRule.applySummary(ithMemberOfRow);
                            this.add(this.summaries, currentRowsetKey, summaryValue);
                            continue;
                        }
                        if (this.rowItems.size() != 0 || !aRule.isMatchingDetailRule(ithMemberOfRow) || aRule.getSummaryFunction().compareToIgnoreCase("count") == 0 && ithMemberOfRow.contextIsAMember() && ((ContextMember)ithMemberOfRow).isFillerMember()) continue;
                        aRule.summarizeDetail((IValue)((Object)ithMemberOfRow));
                    }
                }
                if (!(this.rowItems.isEmpty() && this.summaries.isEmpty() || null == (retRowValue = this.constructRows()))) {
                    RowValue theRow = (RowValue)rowValue.copy();
                    this.detailRowBuffer.push(theRow);
                    return retRowValue;
                }
                return rowValue;
            }

            public IRow processRestRows(IRow rowValue, List<ContextBase> flatMemberList) {
                if (flatMemberList == null) {
                    return rowValue;
                }
                IRow retRowValue = rowValue;
                for (XV5ListSummarySpec aRule : XV5ListSummary.this.mV5ListSummarySpecs) {
                    for (int i = 0; i < flatMemberList.size(); ++i) {
                        List members = (List)this.rowItems.get(aRule.mRowsetId);
                        if (members == null && aRule.isMatchingSummaryRule(flatMemberList.get(i))) {
                            if (this.mRowCache == null) {
                                return null;
                            }
                            this.populateContextMembersFromCachedRow((ContextMember)flatMemberList.get(i), aRule, flatMemberList);
                            continue;
                        }
                        if (!aRule.isMatchingDetailRule(flatMemberList.get(i)) || !aRule.checkRaggedOrOuterMostHeaderSummary(this.headerFillerRowBuffer)) continue;
                        ContextValue summaryValue = aRule.applySummary(flatMemberList.get(i));
                        this.add(this.summaries, aRule.mRowsetId, summaryValue);
                    }
                }
                retRowValue = !this.rowItems.isEmpty() || !this.summaries.isEmpty() ? this.constructRows() : this.fetchRowFromCache();
                return retRowValue;
            }

            private void buildContextMembersForSummaries(List<ContextBase> flatMemberList) {
                block0: for (XV5ListSummarySpec aRule : XV5ListSummary.this.mV5ListSummarySpecs) {
                    for (ContextBase member : flatMemberList) {
                        if (!(member instanceof ContextMember) || !aRule.isMatchingBreakRule((ContextMember)member)) continue;
                        if (this.mRowCache == null) {
                            return;
                        }
                        List<ContextBase> flatCachedMemberList = this.flattenContextMembersFromRow(this.mRowCache);
                        this.populateContextMembersFromCachedRow(aRule.getCachedBreakMember(), aRule, flatCachedMemberList);
                        aRule.setCachedBreakMember((ContextMember)member);
                        continue block0;
                    }
                }
                XV5ListSummaryResultSet.this.resetBreakFound();
            }

            public void buildRowMetadataList(List<ContextBase> flatMemberList) {
                if (!this.rowMetadataContextMemberMap.isEmpty()) {
                    this.rowMemberIndexMetadataMap.clear();
                    this.rowMetadataContextMemberMap.clear();
                }
                for (int i = 0; i < flatMemberList.size(); ++i) {
                    ContextBase ithMember = flatMemberList.get(i);
                    IMetadata iMetadata = null;
                    ContextMember contextMember = null;
                    if (ithMember.contextIsAMember()) {
                        iMetadata = ((ContextMember)ithMember).getMember().getLevel();
                        VirtualMember virtualMember = new VirtualMember(FILLER_MEMBER, (ILevel)iMetadata);
                        ContextMember virtualContextMember = new ContextMember();
                        virtualContextMember.setMember(virtualMember);
                        virtualContextMember.setRowset(ithMember.getRowset());
                        virtualContextMember.setDataItemIndex(ithMember.getDataItemIndex());
                        virtualContextMember.setFillerMember(true);
                        contextMember = virtualContextMember;
                    } else {
                        contextMember = ithMember.getContextMember();
                        iMetadata = contextMember.getMember();
                    }
                    if (this.rowMetadataContextMemberMap.containsKey(iMetadata)) continue;
                    this.rowMemberIndexMetadataMap.put(new Integer(i), iMetadata);
                    this.rowMetadataContextMemberMap.put(iMetadata, contextMember);
                }
            }

            private List<ContextBase> flattenContextMembersFromRow(IRow rowValue) {
                int factsIndex;
                if (rowValue == null || rowValue.getNumColumns() == 0) {
                    return null;
                }
                ArrayList<ContextBase> flatMemberList = new ArrayList<ContextBase>();
                IValue[] columns = rowValue.getColumns();
                RSAPIEdgeRowset detailEdgeRowset = (RSAPIEdgeRowset)((ContextBase)((Object)columns[columns.length - 1])).getRowset();
                ContextMember dummyMember = ((ContextBase)((Object)columns[columns.length - 1])).getContextMember();
                boolean bl = this.isHeader = detailEdgeRowset != null && detailEdgeRowset.isHeaderRowset() && !dummyMember.isMeasure();
                if (this.isHeader) {
                    return null;
                }
                RSAPIDataItem[] dataItems = detailEdgeRowset.getDataItems();
                this.isEmptySummary = false;
                if (detailEdgeRowset.getRefDataItem() == null && dataItems.length == 0) {
                    this.isEmptySummary = true;
                    return null;
                }
                boolean hasFact = false;
                for (factsIndex = 0; factsIndex < dataItems.length; ++factsIndex) {
                    if (dataItems[factsIndex].getUsage() != RSAPIUsage.FACT) continue;
                    hasFact = true;
                    break;
                }
                this.isFillerRow = false;
                int columnIndex = 0;
                while (!(columnIndex >= columns.length || factsIndex >= dataItems.length && hasFact)) {
                    ContextBase iColumn = (ContextBase)((Object)columns[columnIndex]);
                    if (iColumn instanceof ContextMember) {
                        IMember iMember = ((ContextMember)iColumn).getMember();
                        if (CalcMemberReferencePrefixes.isFillerTag(iMember)) {
                            this.isFillerRow = true;
                            return null;
                        }
                        this.addContextMember((ContextMember)iColumn, flatMemberList);
                        ++columnIndex;
                        continue;
                    }
                    RSAPIEdgeRowset colRowset = (RSAPIEdgeRowset)iColumn.getRowset();
                    if (colRowset != null && colRowset.getRowsetId() == detailEdgeRowset.getRowsetId()) {
                        if (iColumn.getDataItemIndex() == factsIndex) {
                            flatMemberList.add(iColumn);
                            ++columnIndex;
                        } else {
                            ContextBase fillerMember = this.createFillerMember(detailEdgeRowset, dummyMember, factsIndex);
                            flatMemberList.add(fillerMember);
                        }
                    }
                    ++factsIndex;
                }
                while (factsIndex < dataItems.length) {
                    ContextBase fillerMember = this.createFillerMember(detailEdgeRowset, dummyMember, factsIndex);
                    flatMemberList.add(fillerMember);
                    ++factsIndex;
                }
                if (flatMemberList.size() < this.rowMetadataContextMemberMap.size()) {
                    this.padMissmembersToFlatMemberList(flatMemberList);
                }
                return flatMemberList;
            }

            private ContextBase createFillerMember(RSAPIEdgeRowset detailEdgeRowset, ContextMember dummyMember, int factsIndex) {
                VirtualMember virtualMember = new VirtualMember(FILLER_MEMBER, dummyMember.getLevel());
                ContextMember virtualContextMember = new ContextMember();
                virtualContextMember.setMember(virtualMember);
                virtualContextMember.setRowset(detailEdgeRowset);
                virtualContextMember.setDataItemIndex(factsIndex);
                virtualContextMember.setFillerMember(true);
                NullValue nullValue = NullValue.NULLVALUE;
                ContextValue fillerMember = new ContextValue(nullValue);
                fillerMember.setContextMember(virtualContextMember);
                fillerMember.setRowset(detailEdgeRowset);
                fillerMember.setDataItemIndex(factsIndex);
                return fillerMember;
            }

            private void addContextMember(ContextMember innerMember, List<ContextBase> flatMemberList) {
                ContextMember outerMember = innerMember.getContextMember();
                if (outerMember == null) {
                    flatMemberList.add(innerMember);
                } else {
                    this.addContextMember(outerMember, flatMemberList);
                    flatMemberList.add(innerMember);
                }
            }

            private void padMissmembersToFlatMemberList(List<ContextBase> flatMemberList) {
                Set<Integer> indexSet = this.rowMemberIndexMetadataMap.keySet();
                for (Integer index : indexSet) {
                    IMetadata currentCachedMetadata = (IMetadata)this.rowMemberIndexMetadataMap.get(index);
                    int indexValue = index;
                    ContextBase theContextBase = null;
                    if (flatMemberList.size() > indexValue) {
                        theContextBase = flatMemberList.get(indexValue);
                        ContextMember contextMember = null;
                        IMetadata iMetadata = null;
                        if (theContextBase.contextIsAMember()) {
                            contextMember = (ContextMember)theContextBase;
                            iMetadata = contextMember.getMember().getLevel();
                        } else {
                            contextMember = theContextBase.getContextMember();
                            iMetadata = contextMember.getMember();
                        }
                        if (currentCachedMetadata.equals(iMetadata)) continue;
                    }
                    if (null != theContextBase) {
                        ContextBase fillerMember = null;
                        if (currentCachedMetadata.getObjectType() == MetadataType.MEMBER) {
                            ContextMember measureContextMember = this.rowMetadataContextMemberMap.get(currentCachedMetadata);
                            NullValue nullValue = DataValueFactory.createNullValue();
                            fillerMember = new ContextValue(nullValue);
                            fillerMember.setContextMember(measureContextMember);
                            fillerMember.setRowset(measureContextMember.getRowset());
                            fillerMember.setDataItemIndex(measureContextMember.getDataItemIndex());
                        } else {
                            fillerMember = this.rowMetadataContextMemberMap.get(currentCachedMetadata);
                        }
                        flatMemberList.add(index, fillerMember);
                    }
                    if (flatMemberList.size() != this.rowMetadataContextMemberMap.size()) continue;
                    break;
                }
            }

            private void add(SortedMap<Integer, List<IValue>> bufferMap, Integer key, IValue newValue) {
                IValue contextBase = null;
                if (newValue instanceof ContextMember) {
                    contextBase = new ContextMember();
                    contextBase.copyFrom(newValue);
                } else if (newValue instanceof ContextValue) {
                    contextBase = newValue;
                }
                if (bufferMap.containsKey(key)) {
                    List values = (List)bufferMap.get(key);
                    if (!values.contains(contextBase)) {
                        values.add(contextBase);
                    }
                } else {
                    ArrayList<ContextMember> values = new ArrayList<ContextMember>();
                    values.add((ContextMember)contextBase);
                    bufferMap.put(key, values);
                }
            }

            private void populateContextMembersFromCachedRow(ContextMember currentBreak, XV5ListSummarySpec theRule, List<ContextBase> flatMemberList) {
                if (currentBreak == null) {
                    return;
                }
                Iterator<ContextBase> iterator = flatMemberList.iterator();
                boolean found = false;
                while (iterator.hasNext() && !found) {
                    ContextBase theMember = iterator.next();
                    if (theMember.contextIsAValue()) continue;
                    if (theMember.equals(currentBreak)) {
                        found = true;
                    }
                    if (!((ContextMember)theMember).isFillerMember()) {
                        this.add(this.rowItems, theRule.mRowsetId, (ContextMember)theMember);
                        continue;
                    }
                    if (!currentBreak.isFillerMember()) continue;
                    this.rowItems.remove(theRule.mRowsetId);
                    theRule.resetSummary();
                    return;
                }
                if (!found) {
                    throw new HResultSetException(XQEMessageKeys.DEC_InternalError_INTERNAL, "Could not found cached break member from cached row.");
                }
            }

            @Override
            public void release() {
                if (this.sourceTabularIterator != null) {
                    try {
                        this.sourceTabularIterator.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.sourceTabularIterator = null;
                    }
                }
                this.rowItems.clear();
                this.summaries.clear();
                this.summaryRowBuffer.clear();
                this.detailRowBuffer.clear();
                this.headerFillerRowBuffer.clear();
                this.rowMemberIndexMetadataMap.clear();
                this.rowMetadataContextMemberMap.clear();
                this.mRowCache = null;
            }
        }
    }
}

