/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.BusinessKeyType;
import com.cognos.xqe.data.types.CurrencyCodeType;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.data.types.HierarchyUniqueNameType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LevelLabelType;
import com.cognos.xqe.data.types.LevelNumberType;
import com.cognos.xqe.data.types.LevelUniqueNameType;
import com.cognos.xqe.data.types.MemberCaptionType;
import com.cognos.xqe.data.types.MemberDescriptionType;
import com.cognos.xqe.data.types.MemberRollupType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.MemberUniqueNameType;
import com.cognos.xqe.data.types.ParentUniqueNameType;
import com.cognos.xqe.data.types.QueryItemModelIDType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.resultsets.v5.V5HybridResultSet;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeElementPosition;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.rsapi.ValueSetReplicas;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.v5.V5ResultSet;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedCellIterator;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedEdgeIterator;
import com.cognos.xqe.runtree.v5.XV5Demo;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XV5Sort
extends XNode {
    private static final long serialVersionUID = 0L;
    public static final String NODE_TYPE_NAME = "XV5Sort";
    private static final String SORTSPEC = "SortSpec";
    private static final String EDGENUM = "EdgeNum";
    private static final String ROWSETID = "RowsetId";
    private static final String COLUMNNUM = "ColumnNum";
    private static final String ASCENDING = "Ascending";
    private static final String ATTRIBUTE_NULL_BEHAVIOR = "nullBehavior";
    private NullBehavior mNullBehavior = NullBehavior.ZERO_FIRST;
    private List<XV5SortSpec> mSortSpecs = new ArrayList<XV5SortSpec>();
    private int gXV5SortDebug = 0;
    private final int kXV5SortDebugOrdinals = 1;
    private final int kXV5SortDebugTuplesBeforeSort = 4;
    private final int kXV5SortDebugTuplesAfterSort = 3;
    private final int kXV5SortDebugAllRowsets = 3;
    private final int kXV5SortDebugCurrentRowsets = 2;

    public void addSortSpec(int theEdgeNum, int theRowsetId, int theColumnNum, boolean theAscending) {
        XV5SortSpec sortSpec = new XV5SortSpec(theEdgeNum, theRowsetId, theColumnNum, theAscending);
        this.mSortSpecs.add(sortSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IValue executeImpl(XDataContext context) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DQExecuteRuntree", this.getNodeTypeName(), ZipiContext.getQRDName());
        try {
            IV5ResultSet sourceResult = (IV5ResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
            XV5SortResultSet v5Result = new XV5SortResultSet(context, this, sourceResult);
            V5HybridResultSet v5HybridResultSet = new V5HybridResultSet(context, v5Result, this.getId());
            return v5HybridResultSet;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    public void setNullBehaviorFromCofig(NullBehavior nullBehavior) {
        this.mNullBehavior = nullBehavior;
    }

    @Override
    public int getType() {
        return 501039;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == this.getType()) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List sortSpecsList = inputNode.elements(SORTSPEC);
        ListIterator it = sortSpecsList.listIterator();
        int i = 0;
        while (it.hasNext()) {
            Element anElement = (Element)it.next();
            int edgeNum = Integer.parseInt(anElement.attributeValue(EDGENUM));
            int rowsetId = Integer.parseInt(anElement.attributeValue(ROWSETID));
            int columnNum = Integer.parseInt(anElement.attributeValue(COLUMNNUM));
            boolean ascending = Boolean.valueOf(anElement.attributeValue(ASCENDING));
            this.addSortSpec(edgeNum, rowsetId, columnNum, ascending);
            ++i;
        }
        super.capture(env, inputNode);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        for (XV5SortSpec sortSpec : this.mSortSpecs) {
            trace.beginElement(SORTSPEC, -1);
            trace.attribute(EDGENUM, Integer.toString(sortSpec.getEdgeNum()));
            trace.attribute(ROWSETID, Integer.toString(sortSpec.getRowsetId()));
            trace.attribute(COLUMNNUM, Integer.toString(sortSpec.getColumnNum()));
            trace.attribute(ASCENDING, Boolean.toString(sortSpec.getAscending()));
            trace.endElement(-1);
        }
    }

    public void release() {
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_NULL_BEHAVIOR, this.mNullBehavior.getKeywordValue());
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.mSortSpecs != null) {
            ctx.elementProperty(SORTSPEC, this.mSortSpecs);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_NULL_BEHAVIOR)) {
            Object val = ctx.attributeValue(att);
            this.mNullBehavior = NullBehavior.convertStringToNullBehavior((String)val);
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(SORTSPEC)) {
            Object val = ctx.elementValue(node);
            this.mSortSpecs = (List)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    public final class XV5SortSpec
    implements IXQEPersist {
        private int mEdgeNum;
        private int mRowsetId;
        private int mColumnNum;
        private boolean mAscending;

        public XV5SortSpec(int theEdgeNum, int theRowsetId, int theColumnNum, boolean theAscending) {
            this.mEdgeNum = theEdgeNum;
            this.mRowsetId = theRowsetId;
            this.mColumnNum = theColumnNum;
            this.mAscending = theAscending;
        }

        public int getEdgeNum() {
            return this.mEdgeNum;
        }

        public int getRowsetId() {
            return this.mRowsetId;
        }

        public int getColumnNum() {
            return this.mColumnNum;
        }

        public boolean getAscending() {
            return this.mAscending;
        }

        @Override
        public void persist(XQEPersistContext ctx, String optionalName) {
            if (ctx.beginElement(this, optionalName, -1)) {
                this.persistAttributeProperties(ctx);
                ctx.endElement();
            }
        }

        public void persistAttributeProperties(XQEPersistContext ctx) {
            ctx.property(XV5Sort.EDGENUM, this.mEdgeNum);
            ctx.property(XV5Sort.ROWSETID, this.mRowsetId);
            ctx.property(XV5Sort.COLUMNNUM, this.mColumnNum);
            ctx.property(XV5Sort.ASCENDING, this.mAscending);
        }

        @Override
        public void restore(XQERestoreContext ctx, Element node) {
            this.restoreAttributes(ctx, node);
        }

        public void restoreAttributes(XQERestoreContext ctx, Element node) {
            int size = node.attributeCount();
            for (int i = 0; i < size; ++i) {
                Attribute att = node.attribute(i);
                this.restoreAttributeProperty(ctx, att, node);
            }
        }

        protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
            String attName = att.getName();
            if (attName.equals(XV5Sort.EDGENUM)) {
                Object val = ctx.attributeValue(att);
                this.mEdgeNum = (Integer)val;
            } else if (attName.equals(XV5Sort.ROWSETID)) {
                Object val = ctx.attributeValue(att);
                this.mRowsetId = (Integer)val;
            } else if (attName.equals(XV5Sort.COLUMNNUM)) {
                Object val = ctx.attributeValue(att);
                this.mColumnNum = (Integer)val;
            } else if (attName.equals(XV5Sort.ASCENDING)) {
                Object val = ctx.attributeValue(att);
                this.mAscending = (Boolean)val;
            }
        }
    }

    private class XV5SortResultSet
    extends V5ResultSet {
        private XV5SortEdge[] mSortEdges;

        XV5SortResultSet(XDataContext context, XNode node, IV5ResultSet sourceResult) {
            super(context, node, sourceResult);
            try {
                int numEdges = this.mEdges.length;
                this.mSortEdges = new XV5SortEdge[numEdges];
                for (XV5SortSpec sortSpec : XV5Sort.this.mSortSpecs) {
                    int edgeNum = sortSpec.getEdgeNum();
                    if (this.mSortEdges[edgeNum] != null) continue;
                    this.mSortEdges[edgeNum] = new XV5SortEdge(this.mEdges[edgeNum]);
                    this.mSortEdges[edgeNum].doSort();
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public long mapV5EdgeOrdinal(RSAPIEdge edge, long oldOrdinal) {
            int edgeNum = edge.getPositionalOrdinal();
            if (this.mSortEdges[edgeNum] == null) {
                return oldOrdinal;
            }
            return this.mSortEdges[edgeNum].mapIndex(oldOrdinal);
        }

        @Override
        public XIterator getV5EdgeIterator(RSAPIEdge edge) {
            int edgeNum = edge.getPositionalOrdinal();
            if (this.mSortEdges[edgeNum] == null) {
                return this.getBaseResultSet().getV5EdgeIterator(edge);
            }
            return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), XV5Sort.this.getId());
        }

        @Override
        public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
            int edgeNum = edge.getPositionalOrdinal();
            if (this.mSortEdges[edgeNum] == null) {
                return this.getBaseResultSet().getScrollableV5EdgeIterator(edge);
            }
            return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), XV5Sort.this.getId());
        }

        @Override
        public XCellIterator getV5CellIterator() {
            return new V5ScrollableMappedCellIterator(this.getDataContext(), this, this.getBaseResultSet().getScrollableV5CellIterator(), XV5Sort.this.getId());
        }

        @Override
        public XScrollableCellIterator getScrollableV5CellIterator() {
            return new V5ScrollableMappedCellIterator(this.getDataContext(), this, this.getBaseResultSet().getScrollableV5CellIterator(), XV5Sort.this.getId());
        }

        @Override
        public void releaseImpl() {
            if (this.mSortEdges != null) {
                for (int i = 0; i < this.mSortEdges.length; ++i) {
                    if (this.mSortEdges[i] == null) continue;
                    this.mSortEdges[i].release();
                    this.mSortEdges[i] = null;
                }
                this.mSortEdges = null;
            }
            super.releaseImpl();
        }

        private final class XV5SortEdge
        implements IReleasable {
            protected RSAPIEdge mEdge;
            private Long[] mOrder;
            private IScrollableIterator mBaseIterator;

            public long mapIndex(long index) {
                if (index >= (long)this.mOrder.length) {
                    return index;
                }
                return this.mOrder[(int)index];
            }

            XV5SortEdge(RSAPIEdge edge) {
                try {
                    this.mEdge = edge;
                    this.mBaseIterator = XV5SortResultSet.this.getBaseResultSet().getScrollableV5EdgeIterator(this.mEdge);
                    if (XV5Sort.this.gXV5SortDebug >= 3) {
                        XV5Demo.dumpRowsets("All Rowsets", this.mEdge.getRowsets());
                    }
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
            }

            public void doSort() {
                long numRows = XV5SortResultSet.this.getBaseResultSet().getV5EdgeSize(this.mEdge);
                if (numRows > Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException();
                }
                this.mOrder = new Long[(int)numRows];
                for (int i = 0; i < (int)numRows; ++i) {
                    this.mOrder[i] = new Long(i);
                }
                if (XV5Sort.this.gXV5SortDebug >= 4) {
                    XV5Demo.dumpAllRows("Before Sort", XV5SortResultSet.this.mThisV5ResultSet, this.mEdge);
                }
                for (int inx = XV5Sort.this.mSortSpecs.size() - 1; inx >= 0; --inx) {
                    XV5SortSpec sortSpec = (XV5SortSpec)XV5Sort.this.mSortSpecs.get(inx);
                    if (sortSpec.getEdgeNum() != this.mEdge.getPositionalOrdinal()) continue;
                    XV5SortApply sortApply = new XV5SortApply(sortSpec, XV5SortResultSet.this.getDataContext());
                    if (sortApply.mCurrRowsets == null || sortApply.mCurrRowsets.length == 0) {
                        return;
                    }
                    long start = 0L;
                    while (start < (long)this.mOrder.length) {
                        start = sortApply.sortSubset(start);
                    }
                }
                if (XV5Sort.this.gXV5SortDebug >= 3) {
                    XV5Demo.dumpAllRows("After Sort", XV5SortResultSet.this.mThisV5ResultSet, this.mEdge);
                }
            }

            @Override
            public void release() {
                if (this.mBaseIterator != null) {
                    this.mBaseIterator.release();
                    this.mBaseIterator = null;
                }
            }

            private final class XV5SortApply {
                XV5SortSpec mSortSpec = null;
                private RSAPIEdgeRowset[] mCurrRowsets = null;
                private XV5SortRowComparator mComparator;
                private RSAPIDataItem mSortDataItem = null;
                private String mSortAttributeName = null;

                XV5SortApply(XV5SortSpec theSortSpec, XDataContext context) {
                    this.mSortSpec = theSortSpec;
                    this.mComparator = new XV5SortRowComparator(context.getLocalCollator());
                    ArrayList<RSAPIEdgeRowset> myRowsets = new ArrayList<RSAPIEdgeRowset>();
                    RowValue detailRow = null;
                    for (int start = 0; start < XV5SortEdge.this.mOrder.length; ++start) {
                        XV5SortEdge.this.mBaseIterator.absolute(XV5SortEdge.this.mapIndex(start));
                        detailRow = (RowValue)XV5SortEdge.this.mBaseIterator.current();
                        if (detailRow != null && !detailRow.isSummary()) break;
                    }
                    IValue[] columns = null;
                    boolean foundSortitemInDetail = false;
                    if (detailRow != null && detailRow.getNumColumns() > 0) {
                        for (IValue column : columns = detailRow.getColumns()) {
                            ContextBase col = (ContextBase)((Object)column);
                            if (col.getRowset() == null || this.mSortSpec.getRowsetId() != col.getRowset().getRowsetId()) continue;
                            foundSortitemInDetail = true;
                            break;
                        }
                    }
                    for (int inx = 0; inx < XV5SortEdge.this.mEdge.getNumRowsets(); ++inx) {
                        RSAPIEdgeRowset rowset = XV5SortEdge.this.mEdge.getRowset(inx);
                        if (rowset.getRowsetId() != this.mSortSpec.getRowsetId()) continue;
                        while (rowset != null) {
                            if (foundSortitemInDetail) {
                                if (columns != null) {
                                    for (IValue column : columns) {
                                        ContextBase col = (ContextBase)((Object)column);
                                        if (col.getRowset() == null || rowset.getRowsetId() != col.getRowset().getRowsetId()) continue;
                                        myRowsets.add(rowset);
                                        break;
                                    }
                                }
                            } else {
                                myRowsets.add(rowset);
                            }
                            rowset = rowset.getParentRowset();
                        }
                    }
                    if (myRowsets.isEmpty()) {
                        return;
                    }
                    RSAPIEdgeRowset myRowset = (RSAPIEdgeRowset)myRowsets.get(0);
                    this.mSortDataItem = this.mSortSpec.mColumnNum < 0 ? myRowset.getRefDataItem() : myRowset.getDataItem(this.mSortSpec.mColumnNum);
                    if (this.mSortDataItem == null) {
                        throw new UnsupportedOperationException("Can not sort on an unprojected dataItem");
                    }
                    if (this.mSortDataItem.getUsage() == RSAPIUsage.ATTRIBUTE) {
                        IDataType dType = this.mSortDataItem.getDataType();
                        if (this.mSortDataItem.isCustomProperty() && this.mSortDataItem.getPropertyName() != null) {
                            this.mSortAttributeName = this.mSortDataItem.getPropertyName();
                        } else if (dType == MemberCaptionType.DEFAULTMEMBERCAPTIONTYPE || dType == MemberType.MEMBERTYPE) {
                            this.mSortAttributeName = "memberCaption";
                        } else if (dType == CurrencyCodeType.DEFAULTCURRENCYCODETYPE) {
                            this.mSortAttributeName = "currencyCode";
                        } else if (dType == DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE) {
                            this.mSortAttributeName = "dimensionUniqueName";
                        } else if (dType == HierarchyUniqueNameType.DEFAULTHIERARCHYUNIQUENAMETYPE) {
                            this.mSortAttributeName = "hierarchyUniqueName";
                        } else if (dType == LevelUniqueNameType.DEFAULTLEVELUNIQUENAMETYPE) {
                            this.mSortAttributeName = "levelUniqueName";
                        } else if (dType == MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE) {
                            this.mSortAttributeName = "memberUniqueName";
                        } else if (dType == LevelLabelType.DEFAULTLEVELLABELTYPE) {
                            this.mSortAttributeName = "levelLabel";
                        } else if (dType == LevelNumberType.LEVELNUMBERTYPE) {
                            this.mSortAttributeName = "levelNumber";
                        } else if (dType == MemberDescriptionType.DEFAULTMEMBERDESCRIPTIONTYPE) {
                            this.mSortAttributeName = "memberDescription";
                        } else if (dType == ParentUniqueNameType.DEFAULTPARENTUNIQUENAMETYPE) {
                            this.mSortAttributeName = "memberDescription";
                        } else if (dType == QueryItemModelIDType.DEFAULTQUERYITEMMODELIDTYPE) {
                            this.mSortAttributeName = "queryItemModelID";
                        } else if (dType == BusinessKeyType.DEFAULTBUSINESSKEYTYPE) {
                            this.mSortAttributeName = "businessKey";
                        } else if (dType == MemberRollupType.DEFAULTMEMBERROLLUPTYPE) {
                            this.mSortAttributeName = "rollupType";
                        }
                    }
                    Collections.reverse(myRowsets);
                    this.mCurrRowsets = myRowsets.toArray(new RSAPIEdgeRowset[myRowsets.size()]);
                    if (XV5Sort.this.gXV5SortDebug >= 2) {
                        XV5Demo.dumpRowsets("Current Rowsets", this.mCurrRowsets);
                    }
                }

                public long sortSubset(long start) {
                    RowValue currRow = null;
                    RowValue firstRowWithGivenKey = null;
                    while (start < (long)XV5SortEdge.this.mOrder.length) {
                        currRow = this.loadRow(start);
                        if (currRow != null) {
                            firstRowWithGivenKey = (RowValue)currRow.copy();
                            break;
                        }
                        ++start;
                    }
                    if (start >= (long)XV5SortEdge.this.mOrder.length) {
                        return start;
                    }
                    ArrayList<XV5SortOrdinal> aList = new ArrayList<XV5SortOrdinal>();
                    long first = start;
                    for (long curr = start + 1L; curr <= (long)XV5SortEdge.this.mOrder.length; ++curr) {
                        if (curr < (long)XV5SortEdge.this.mOrder.length) {
                            currRow = this.loadRow(curr);
                            if (currRow != null && this.isBreakRow(currRow, firstRowWithGivenKey)) {
                                currRow = null;
                            }
                            if (currRow != null && this.compareMember(this.getKey(currRow), this.getKey(firstRowWithGivenKey)) || currRow != null && this.isRowFromNestedEmptyValueSet(currRow)) continue;
                        }
                        aList.add(new XV5SortOrdinal(start, curr - start, this.getKey(firstRowWithGivenKey)));
                        start = curr;
                        if (curr >= (long)XV5SortEdge.this.mOrder.length || currRow == null) break;
                        firstRowWithGivenKey = (RowValue)currRow.copy();
                    }
                    if (XV5Sort.this.gXV5SortDebug >= 1) {
                        this.dumpOrdinals(aList);
                    }
                    if (aList.size() > 1) {
                        Collections.sort(aList, this.mComparator);
                        this.updateOrder(aList, first, start);
                    }
                    return start;
                }

                private boolean isRowFromNestedEmptyValueSet(RowValue currRow) {
                    int numColumns = currRow.getNumColumns();
                    if (numColumns != 1) {
                        return false;
                    }
                    ContextBase col = (ContextBase)((Object)currRow.getColumn(0));
                    RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)col.getRowset();
                    if (rowset == null) {
                        return false;
                    }
                    for (RSAPIEdgeRowset currRowset : this.mCurrRowsets) {
                        if (!rowset.isEmptyNestedUnder(currRowset)) continue;
                        return true;
                    }
                    return false;
                }

                private RowValue loadRow(long index) {
                    XV5SortEdge.this.mBaseIterator.absolute(XV5SortEdge.this.mapIndex(index));
                    RowValue row = (RowValue)XV5SortEdge.this.mBaseIterator.current();
                    int numColumns = row.getNumColumns();
                    for (int inx = 0; inx < this.mCurrRowsets.length && numColumns > inx; ++inx) {
                        ContextBase col = (ContextBase)((Object)row.getColumn(inx));
                        RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)col.getRowset();
                        if (rowset != null && numColumns == 1 && rowset.isEmptyNestedUnder(this.mCurrRowsets[inx]) || rowset.getRowsetId() == this.mCurrRowsets[inx].getRowsetId()) continue;
                        return null;
                    }
                    return row;
                }

                private ContextBase getKey(RowValue row) {
                    for (int inx = this.mCurrRowsets.length - 1; inx < row.getNumColumns(); ++inx) {
                        RSAPIEdgeRowset columnRowset;
                        ContextBase col = (ContextBase)((Object)row.getColumn(inx));
                        int specColumnNum = this.mSortSpec.getColumnNum();
                        if (col.getDataItemIndex() == specColumnNum) {
                            return col;
                        }
                        if (col instanceof ContextMember && ((ContextMember)col).getAdditionalDataItemIndices() != null && ((ContextMember)col).getAdditionalDataItemIndices().contains(specColumnNum)) {
                            return col;
                        }
                        if (!(col instanceof ContextBase) || (columnRowset = (RSAPIEdgeRowset)col.getRowset()) == null || columnRowset.getReplicasOfThis() == null) continue;
                        for (int repIndex = 0; repIndex < columnRowset.getReplicasOfThis().size(); ++repIndex) {
                            List<RSAPIEdgeElementPosition> rsapiEdgeElementPositions;
                            ValueSetReplicas valueSetReplicas = columnRowset.getReplicasOfThis().get(repIndex);
                            if (valueSetReplicas.getSourceDataItemOrdinal() != col.getDataItemIndex() || (rsapiEdgeElementPositions = valueSetReplicas.getGroupBodyDataItemRefs()) == null) continue;
                            for (RSAPIEdgeElementPosition replicaPosition : rsapiEdgeElementPositions) {
                                if (replicaPosition.getDataItemOrdinal() != specColumnNum) continue;
                                return col;
                            }
                        }
                    }
                    return null;
                }

                private boolean isBreakRow(RowValue currRow, RowValue lastRow) {
                    for (int inx = 0; inx < this.mCurrRowsets.length - 1; ++inx) {
                        if (this.compareMember((ContextBase)((Object)currRow.getColumn(inx)), (ContextBase)((Object)lastRow.getColumn(inx)))) continue;
                        return true;
                    }
                    return false;
                }

                private boolean compareMember(ContextBase currCol, ContextBase lastCol) {
                    if (lastCol == null || currCol == null) {
                        return false;
                    }
                    if (currCol.contextIsAMember() && lastCol.contextIsAMember()) {
                        IMember iMemb1 = ((ContextMember)currCol).getMember();
                        IMember iMemb2 = ((ContextMember)lastCol).getMember();
                        if (iMemb1 == null && iMemb2 == null) {
                            return true;
                        }
                        if (iMemb1 == null || iMemb2 == null) {
                            return false;
                        }
                        return iMemb1.getUniqueName().equals(iMemb2.getUniqueName());
                    }
                    if (currCol.contextIsAValue() && lastCol.contextIsAValue()) {
                        ContextValue val1 = (ContextValue)currCol;
                        ContextValue val2 = (ContextValue)lastCol;
                        return val1.compareTo(val2) == 0;
                    }
                    return false;
                }

                private void updateOrder(ArrayList<XV5SortOrdinal> aList, long start, long last) {
                    long size = last - start;
                    long origin = start;
                    Long[] orderCopy = new Long[(int)size];
                    System.arraycopy(XV5SortEdge.this.mOrder, (int)start, orderCopy, 0, (int)size);
                    for (int i = 0; i < aList.size(); ++i) {
                        XV5SortOrdinal ordinal = aList.get(i);
                        System.arraycopy(orderCopy, (int)(ordinal.getFirst() - origin), XV5SortEdge.this.mOrder, (int)start, (int)ordinal.getSpan());
                        start += ordinal.getSpan();
                    }
                }

                private void dumpOrdinals(ArrayList<XV5SortOrdinal> ordinals) {
                    XQEDebugLog.out.print("Sorting ");
                    XQEDebugLog.out.print(ordinals.size());
                    XQEDebugLog.out.println(" row groups");
                    for (int inx = 0; inx < ordinals.size(); ++inx) {
                        XV5SortOrdinal ordinal = ordinals.get(inx);
                        XQEDebugLog.out.print(ordinal.getFirst());
                        XQEDebugLog.out.print(" - ");
                        XQEDebugLog.out.print(ordinal.getSpan());
                        ContextBase value = ordinal.getKey();
                        XQEDebugLog.out.print(" : ");
                        if (value == null) {
                            XQEDebugLog.out.print("NULL");
                        } else if (this.mSortDataItem.getUsage() == RSAPIUsage.FACT) {
                            XQEDebugLog.out.print(value.toString());
                        } else {
                            IMember iMember = ((ContextMember)value).getMember();
                            XQEDebugLog.out.print(iMember.getCaption());
                        }
                        XQEDebugLog.out.println();
                    }
                }

                private final class XV5SortRowComparator
                implements Comparator<Object> {
                    private Collator mCollator;

                    XV5SortRowComparator(Collator collator) {
                        this.mCollator = collator;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public int compare(Object obj1, Object obj2) {
                        ContextBase value1 = ((XV5SortOrdinal)obj1).getKey();
                        ContextBase value2 = ((XV5SortOrdinal)obj2).getKey();
                        int rc = 0;
                        Object compareValue1 = null;
                        Object compareValue2 = null;
                        boolean hasNonNumericNull = false;
                        boolean hasNumericNull = false;
                        if (value1 != null && value2 != null) {
                            if (XV5SortApply.this.mSortDataItem.getUsage() == RSAPIUsage.IDENTIFIER) {
                                compareValue1 = ((ContextMember)value1).getMember().getCaption();
                                compareValue2 = ((ContextMember)value2).getMember().getCaption();
                                if (compareValue1 == null || compareValue2 == null) {
                                    hasNonNumericNull = true;
                                }
                                rc = this.mCollator.compare((String)compareValue1, (String)compareValue2);
                            } else if (XV5SortApply.this.mSortDataItem.getUsage() == RSAPIUsage.ATTRIBUTE) {
                                boolean value2IsNull;
                                compareValue1 = ((ContextMember)value1).getMember().getProperty(XV5SortApply.this.mSortAttributeName);
                                compareValue2 = ((ContextMember)value2).getMember().getProperty(XV5SortApply.this.mSortAttributeName);
                                boolean value1IsNull = compareValue1 == null || Value.class.isInstance(compareValue1) && ((Value)compareValue1).isNull();
                                boolean bl = value2IsNull = compareValue2 == null || Value.class.isInstance(compareValue2) && ((Value)compareValue2).isNull();
                                if (value1IsNull || value2IsNull) {
                                    hasNonNumericNull = true;
                                    if (!value1IsNull) {
                                        rc = 1;
                                    } else if (!value2IsNull) {
                                        rc = -1;
                                    }
                                } else {
                                    Object attribute = null;
                                    if (compareValue1.getClass().isInstance(compareValue2)) {
                                        attribute = compareValue1;
                                    } else {
                                        if (!compareValue2.getClass().isInstance(compareValue1)) throw new UnsupportedOperationException("Can not sort incompatible datatypes");
                                        attribute = compareValue2;
                                    }
                                    if (String.class.isInstance(attribute)) {
                                        rc = this.mCollator.compare((String)compareValue1, (String)compareValue2);
                                    } else if (Integer.class.isInstance(attribute)) {
                                        rc = ((Integer)compareValue1).compareTo((Integer)compareValue2);
                                    } else if (Double.class.isInstance(attribute)) {
                                        rc = ((Double)compareValue1).compareTo((Double)compareValue2);
                                    } else {
                                        if (!Value.class.isInstance(attribute)) throw new UnsupportedOperationException("Can only sort Strings, Integer, Doubles or Values");
                                        boolean useValue1 = false;
                                        useValue1 = attribute instanceof TextValue ? ((TextValue)attribute).compareTo(compareValue1, this.mCollator) == 0 : attribute.equals(compareValue1);
                                        if (useValue1) {
                                            rc = compareValue1 instanceof TextValue ? ((TextValue)compareValue1).compareTo(compareValue2, this.mCollator) : ((Value)compareValue1).compareTo(compareValue2);
                                        } else {
                                            rc = compareValue2 instanceof TextValue ? ((TextValue)compareValue2).compareTo(compareValue1, this.mCollator) : ((Value)compareValue2).compareTo(compareValue1);
                                            rc = -rc;
                                        }
                                    }
                                }
                            } else if (XV5SortApply.this.mSortDataItem.getUsage() == RSAPIUsage.FACT) {
                                IValue contextValue1 = ((ContextValue)value1).getValue();
                                IValue contextValue2 = ((ContextValue)value2).getValue();
                                if ((((Value)contextValue1).isNull() || ((Value)contextValue2).isNull()) && (XV5Sort.this.mNullBehavior == NullBehavior.NULL_FIRST || XV5Sort.this.mNullBehavior == NullBehavior.NULL_LAST)) {
                                    hasNumericNull = true;
                                }
                                rc = ((Value)contextValue1).compareTo(contextValue2, XV5Sort.this.mNullBehavior);
                            } else {
                                rc = 0;
                            }
                        } else if (value1 != null) {
                            if (XV5SortApply.this.mSortDataItem.getUsage() == RSAPIUsage.FACT) {
                                if (XV5Sort.this.mNullBehavior == NullBehavior.NULL_FIRST || XV5Sort.this.mNullBehavior == NullBehavior.NULL_LAST) {
                                    hasNumericNull = true;
                                }
                                NullValue nullValue = DataValueFactory.createNullValue();
                                rc = ((Value)((ContextValue)value1).getValue()).compareTo(nullValue, XV5Sort.this.mNullBehavior);
                            } else {
                                hasNonNumericNull = true;
                                rc = 1;
                            }
                        } else if (value2 != null) {
                            if (XV5SortApply.this.mSortDataItem.getUsage() == RSAPIUsage.FACT) {
                                if (XV5Sort.this.mNullBehavior == NullBehavior.NULL_FIRST || XV5Sort.this.mNullBehavior == NullBehavior.NULL_LAST) {
                                    hasNumericNull = true;
                                }
                                NullValue nullValue = DataValueFactory.createNullValue();
                                rc = -1 * ((Value)((ContextValue)value2).getValue()).compareTo(nullValue, XV5Sort.this.mNullBehavior);
                            } else {
                                hasNonNumericNull = true;
                                rc = -1;
                            }
                        }
                        if (!(XV5SortApply.this.mSortSpec.getAscending() || hasNonNumericNull || hasNumericNull)) {
                            rc = -rc;
                        }
                        if (!hasNonNumericNull) return rc;
                        if (XV5Sort.this.mNullBehavior == NullBehavior.NULL_LAST) return -rc;
                        if (XV5Sort.this.mNullBehavior != NullBehavior.ZERO_LAST) return rc;
                        return -rc;
                    }
                }

                private final class XV5SortOrdinal {
                    private long mFirst;
                    private long mSpan;
                    private ContextBase mKey;

                    XV5SortOrdinal(long first, long span, ContextBase key) {
                        this.mFirst = first;
                        this.mSpan = span;
                        this.mKey = key;
                    }

                    public long getFirst() {
                        return this.mFirst;
                    }

                    public long getSpan() {
                        return this.mSpan;
                    }

                    public ContextBase getKey() {
                        return this.mKey;
                    }
                }
            }
        }
    }
}

