/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.resultsets.v5.V5HybridResultSet;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.v5.V5ResultSet;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedCellIterator;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedEdgeIterator;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IReleasable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XV5SuppressRowUsingEdgeContext
extends XNode {
    private static final long serialVersionUID = 0L;
    public static final String NODE_TYPE_NAME = "XV5SuppressRowUsingEdgeContext";
    private static final String XSUPPRESSROWRULE = "XV5SuppressRowRule";
    private static final String EDGENUM = "EdgeNum";
    private static final String SOURCEROWSETID = "SourceRowsetId";
    private static final String SOURCEDATAITEMINDEX = "SourceDataItemIndex";
    private static final String SOURCEVALUE = "SourceValue";
    private static final String CONTEXTROWSETID = "ContextRowsetId";
    private static final String CONTEXTVALUE = "ContextValue";
    private List<XV5SuppressRowRule> mSuppressRowRuleList = new ArrayList<XV5SuppressRowRule>();

    @Override
    protected IValue executeImpl(XDataContext context) {
        IV5ResultSet sourceResult = (IV5ResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
        XV5SuppressRowResultSet v5Result = new XV5SuppressRowResultSet(context, this, sourceResult);
        return new V5HybridResultSet(context, v5Result, this.getId());
    }

    @Override
    public int getType() {
        return 501082;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == this.getType()) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List xsuppressRowRuleList = inputNode.elements(XSUPPRESSROWRULE);
        ListIterator itRule = xsuppressRowRuleList.listIterator();
        while (itRule.hasNext()) {
            Element ruleElement = (Element)itRule.next();
            int edgeNum = Integer.parseInt(ruleElement.attributeValue(EDGENUM));
            int sourceRowsetId = Integer.parseInt(ruleElement.attributeValue(SOURCEROWSETID));
            int sourceDataItemIndex = Integer.parseInt(ruleElement.attributeValue(SOURCEDATAITEMINDEX));
            String sourceValue = String.valueOf(ruleElement.attribute(SOURCEVALUE));
            int contextRowsetId = Integer.parseInt(ruleElement.attributeValue(CONTEXTROWSETID));
            String contextValue = String.valueOf(ruleElement.attribute(CONTEXTVALUE));
            XV5SuppressRowRule rule = new XV5SuppressRowRule(edgeNum, sourceRowsetId, sourceDataItemIndex, sourceValue, contextRowsetId, contextValue);
            this.addSuppressRowRule(rule);
            itRule.remove();
        }
        super.capture(env, inputNode);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        for (XV5SuppressRowRule aRule : this.mSuppressRowRuleList) {
            trace.beginElement(XSUPPRESSROWRULE, -1);
            trace.attribute(EDGENUM, Integer.toString(aRule.getEdgeNum()));
            trace.attribute(SOURCEROWSETID, Integer.toString(aRule.getSourceRowsetId()));
            trace.attribute(SOURCEDATAITEMINDEX, Integer.toString(aRule.getSourceDataItemIndex()));
            trace.attribute(SOURCEVALUE, aRule.getSourceValue());
            trace.attribute(CONTEXTROWSETID, Integer.toString(aRule.getContextRowsetId()));
            trace.attribute(CONTEXTVALUE, aRule.getContextValue());
            trace.endElement(-1);
        }
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement(this.getNodeTypeName(), -1);
        this.dumpExtraInfo(trace, true);
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            this.getChild(i).dumpFormattedXMLQuery(trace);
        }
        trace.endElement(-1);
    }

    public void addSuppressRowRule(XV5SuppressRowRule rule) {
        this.mSuppressRowRuleList.add(rule);
    }

    public void addSuppressRowRule(List<XV5SuppressRowRule> rules) {
        this.mSuppressRowRuleList.addAll(rules);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.mSuppressRowRuleList != null) {
            ctx.elementProperty(XSUPPRESSROWRULE, this.mSuppressRowRuleList);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(XSUPPRESSROWRULE)) {
            Object val = ctx.elementValue(node);
            this.mSuppressRowRuleList = (List)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    public static final class XV5SuppressRowRule
    implements IXQEPersist {
        private int mEdgeNum;
        private int mSourceRowsetId;
        private int mSourceDataItemIndex;
        private String mSourceValue;
        private int mContextRowsetId;
        private String mContextValue;

        public XV5SuppressRowRule() {
        }

        public XV5SuppressRowRule(int theEdgeNum, int theSourceRowsetId, int theSourceDataItemIndex, String theSourceValue, int theContextRowsetId, String theContextValue) {
            this.mEdgeNum = theEdgeNum;
            this.mSourceRowsetId = theSourceRowsetId;
            this.mSourceDataItemIndex = theSourceDataItemIndex;
            this.mSourceValue = theSourceValue;
            this.mContextRowsetId = theContextRowsetId;
            this.mContextValue = theContextValue;
        }

        public int getEdgeNum() {
            return this.mEdgeNum;
        }

        public int getSourceRowsetId() {
            return this.mSourceRowsetId;
        }

        public int getSourceDataItemIndex() {
            return this.mSourceDataItemIndex;
        }

        public String getSourceValue() {
            return this.mSourceValue;
        }

        public int getContextRowsetId() {
            return this.mContextRowsetId;
        }

        public String getContextValue() {
            return this.mContextValue;
        }

        @Override
        public void persist(XQEPersistContext ctx, String optionalName) {
            if (ctx.beginElement(this, optionalName, -1)) {
                this.persistAttributeProperties(ctx);
                ctx.endElement();
            }
        }

        public void persistAttributeProperties(XQEPersistContext ctx) {
            ctx.property(XV5SuppressRowUsingEdgeContext.EDGENUM, this.mEdgeNum);
            ctx.property(XV5SuppressRowUsingEdgeContext.SOURCEROWSETID, this.mSourceRowsetId);
            ctx.property(XV5SuppressRowUsingEdgeContext.SOURCEDATAITEMINDEX, this.mSourceDataItemIndex);
            ctx.property(XV5SuppressRowUsingEdgeContext.SOURCEVALUE, this.mSourceValue);
            ctx.property(XV5SuppressRowUsingEdgeContext.CONTEXTROWSETID, this.mContextRowsetId);
            ctx.property(XV5SuppressRowUsingEdgeContext.CONTEXTVALUE, this.mContextValue);
        }

        @Override
        public void restore(XQERestoreContext ctx, Element node) {
            this.restoreAttributes(ctx, node);
        }

        public void restoreAttributes(XQERestoreContext ctx, Element node) {
            int size = node.attributeCount();
            for (int i = 0; i < size; ++i) {
                Attribute att = node.attribute(i);
                this.restoreAttributeProperty(ctx, att, node);
            }
        }

        protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
            String attName = att.getName();
            if (attName.equals(XV5SuppressRowUsingEdgeContext.EDGENUM)) {
                Object val = ctx.attributeValue(att);
                this.mEdgeNum = (Integer)val;
            } else if (attName.equals(XV5SuppressRowUsingEdgeContext.SOURCEROWSETID)) {
                Object val = ctx.attributeValue(att);
                this.mSourceRowsetId = (Integer)val;
            } else if (attName.equals(XV5SuppressRowUsingEdgeContext.SOURCEDATAITEMINDEX)) {
                Object val = ctx.attributeValue(att);
                this.mSourceDataItemIndex = (Integer)val;
            } else if (attName.equals(XV5SuppressRowUsingEdgeContext.SOURCEVALUE)) {
                Object val = ctx.attributeValue(att);
                this.mSourceValue = (String)val;
            } else if (attName.equals(XV5SuppressRowUsingEdgeContext.CONTEXTROWSETID)) {
                Object val = ctx.attributeValue(att);
                this.mContextRowsetId = (Integer)val;
            } else if (attName.equals(XV5SuppressRowUsingEdgeContext.CONTEXTVALUE)) {
                Object val = ctx.attributeValue(att);
                this.mContextValue = (String)val;
            }
        }
    }

    private class XV5SuppressRowResultSet
    extends V5ResultSet {
        private XV5SuppressRowEdge[] mSuppressRowEdges;

        XV5SuppressRowResultSet(XDataContext context, XNode node, IV5ResultSet sourceResult) {
            super(context, node, sourceResult);
            try {
                int numEdges = this.mEdges.length;
                this.mSuppressRowEdges = new XV5SuppressRowEdge[numEdges];
                for (XV5SuppressRowRule suppressRowRule : XV5SuppressRowUsingEdgeContext.this.mSuppressRowRuleList) {
                    int edgeNum = suppressRowRule.getEdgeNum();
                    if (this.mSuppressRowEdges[edgeNum] != null) continue;
                    this.mSuppressRowEdges[edgeNum] = new XV5SuppressRowEdge(this.mEdges[edgeNum]);
                    this.mSuppressRowEdges[edgeNum].doSuppress();
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public long mapV5EdgeOrdinal(RSAPIEdge edge, long oldOrdinal) {
            int edgeNum = edge.getPositionalOrdinal();
            if (this.mSuppressRowEdges[edgeNum] == null) {
                return oldOrdinal;
            }
            return this.mSuppressRowEdges[edgeNum].mapIndex(oldOrdinal);
        }

        @Override
        public XIterator getV5EdgeIterator(RSAPIEdge edge) {
            int edgeNum = edge.getPositionalOrdinal();
            if (this.mSuppressRowEdges[edgeNum] == null) {
                return this.getBaseResultSet().getV5EdgeIterator(edge);
            }
            return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), XV5SuppressRowUsingEdgeContext.this.getId());
        }

        @Override
        public long getV5EdgeSize(RSAPIEdge edge) {
            int edgeNum = edge.getPositionalOrdinal();
            if (this.mSuppressRowEdges[edgeNum] == null) {
                return this.getBaseResultSet().getV5EdgeSize(edge);
            }
            return this.mSuppressRowEdges[edgeNum].getUpdatedNumRows();
        }

        @Override
        public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
            int edgeNum = edge.getPositionalOrdinal();
            if (this.mSuppressRowEdges[edgeNum] == null) {
                return this.getBaseResultSet().getScrollableV5EdgeIterator(edge);
            }
            return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), XV5SuppressRowUsingEdgeContext.this.getId());
        }

        @Override
        public XCellIterator getV5CellIterator() {
            return new V5ScrollableMappedCellIterator(this.getDataContext(), this, this.getBaseResultSet().getScrollableV5CellIterator(), XV5SuppressRowUsingEdgeContext.this.getId());
        }

        @Override
        public XScrollableCellIterator getScrollableV5CellIterator() {
            return new V5ScrollableMappedCellIterator(this.getDataContext(), this, this.getBaseResultSet().getScrollableV5CellIterator(), XV5SuppressRowUsingEdgeContext.this.getId());
        }

        @Override
        public void releaseImpl() {
            if (this.mSuppressRowEdges != null) {
                for (int i = 0; i < this.mSuppressRowEdges.length; ++i) {
                    if (this.mSuppressRowEdges[i] == null) continue;
                    this.mSuppressRowEdges[i].release();
                    this.mSuppressRowEdges[i] = null;
                }
                this.mSuppressRowEdges = null;
            }
            this.mSuppressRowEdges = null;
            super.releaseImpl();
        }

        private final class XV5SuppressRowEdge
        implements IReleasable {
            protected RSAPIEdge mEdge;
            private long mUpdatedNumRows;
            private Long[] mOrder;
            private IScrollableIterator mBaseIterator;

            public long mapIndex(long index) {
                if (index >= this.mUpdatedNumRows) {
                    return XV5SuppressRowResultSet.this.getBaseResultSet().getV5EdgeSize(this.mEdge);
                }
                return this.mOrder[(int)index];
            }

            XV5SuppressRowEdge(RSAPIEdge edge) {
                try {
                    this.mEdge = edge;
                    this.mUpdatedNumRows = XV5SuppressRowResultSet.this.getBaseResultSet().getV5EdgeSize(this.mEdge);
                    this.mBaseIterator = XV5SuppressRowResultSet.this.getBaseResultSet().getScrollableV5EdgeIterator(this.mEdge);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
            }

            public long getUpdatedNumRows() {
                return this.mUpdatedNumRows;
            }

            public void doSuppress() {
                this.mOrder = new Long[(int)this.mUpdatedNumRows];
                for (int i = 0; i < (int)this.mUpdatedNumRows; ++i) {
                    this.mOrder[i] = new Long(i);
                }
                for (int inx = 0; inx < XV5SuppressRowUsingEdgeContext.this.mSuppressRowRuleList.size(); ++inx) {
                    XV5SuppressRowRule suppressRowRule = (XV5SuppressRowRule)XV5SuppressRowUsingEdgeContext.this.mSuppressRowRuleList.get(inx);
                    if (suppressRowRule.getEdgeNum() != this.mEdge.getPositionalOrdinal()) continue;
                    XV5SuppressRowApply suppressRowApply = new XV5SuppressRowApply(suppressRowRule);
                    long start = 0L;
                    while (start < this.mUpdatedNumRows) {
                        start = suppressRowApply.suppressSubset(start);
                    }
                }
            }

            @Override
            public void release() {
                if (this.mBaseIterator != null) {
                    this.mBaseIterator.release();
                    this.mBaseIterator = null;
                }
            }

            private final class XV5SuppressRowApply {
                XV5SuppressRowRule mSuppressRowRule = null;
                private RSAPIEdgeRowset[] mCurrRowsets = null;

                XV5SuppressRowApply(XV5SuppressRowRule theSuppressRowRule) {
                    this.mSuppressRowRule = theSuppressRowRule;
                    ArrayList<RSAPIEdgeRowset> myRowsets = new ArrayList<RSAPIEdgeRowset>();
                    for (int inx = 0; inx < XV5SuppressRowEdge.this.mEdge.getNumRowsets(); ++inx) {
                        RSAPIEdgeRowset rowset = XV5SuppressRowEdge.this.mEdge.getRowset(inx);
                        if (rowset.getRowsetId() != this.mSuppressRowRule.getSourceRowsetId()) continue;
                        while (rowset != null) {
                            myRowsets.add(rowset);
                            rowset = rowset.getParentRowset();
                        }
                        break;
                    }
                    Collections.reverse(myRowsets);
                    this.mCurrRowsets = myRowsets.toArray(new RSAPIEdgeRowset[myRowsets.size()]);
                }

                public long suppressSubset(long start) {
                    RowValue currRow = null;
                    while (start < XV5SuppressRowEdge.this.mUpdatedNumRows && (currRow = this.loadRow(start)) == null) {
                        ++start;
                    }
                    if (start >= XV5SuppressRowEdge.this.mUpdatedNumRows) {
                        return start;
                    }
                    long rowsSuppressed = 0L;
                    for (long curr = start + 1L; curr <= XV5SuppressRowEdge.this.mUpdatedNumRows; ++curr) {
                        RowValue lastRow = (RowValue)currRow.copy();
                        if (curr < XV5SuppressRowEdge.this.mUpdatedNumRows) {
                            currRow = this.loadRow(curr);
                            if (currRow != null && this.isBreakRow(currRow, lastRow)) {
                                currRow = null;
                            }
                            if (currRow != null && this.compareMember(this.getKey(currRow), this.getKey(lastRow))) continue;
                        }
                        if (this.suppressRow(lastRow)) {
                            rowsSuppressed = curr - start;
                            break;
                        }
                        start = curr;
                        if (curr >= XV5SuppressRowEdge.this.mUpdatedNumRows || currRow == null) break;
                    }
                    if (rowsSuppressed > 0L) {
                        this.updateOrder(start, rowsSuppressed);
                    }
                    return start;
                }

                private boolean suppressRow(RowValue aRow) {
                    ContextMember contextMember;
                    String contextValue;
                    boolean suppressed = false;
                    ContextMember sourceMember = (ContextMember)this.getKey(aRow);
                    if (sourceMember == null) {
                        return suppressed;
                    }
                    String sourceValue = sourceMember.getV5UniqueName();
                    if (sourceValue.equals(this.mSuppressRowRule.getSourceValue()) && !(contextValue = (contextMember = (ContextMember)this.getContext(aRow)).getCognosUniqueNameNormalized()).equals(this.mSuppressRowRule.getContextValue())) {
                        suppressed = true;
                    }
                    return suppressed;
                }

                private RowValue loadRow(long index) {
                    XV5SuppressRowEdge.this.mBaseIterator.absolute(XV5SuppressRowEdge.this.mapIndex(index));
                    RowValue row = (RowValue)XV5SuppressRowEdge.this.mBaseIterator.current();
                    int numColumns = row.getNumColumns();
                    for (int inx = 0; inx < this.mCurrRowsets.length && numColumns > inx; ++inx) {
                        ContextBase col = (ContextBase)((Object)row.getColumn(inx));
                        if (col.getRowset() == null || col.getRowset().getRowsetId() == this.mCurrRowsets[inx].getRowsetId()) continue;
                        return null;
                    }
                    return row;
                }

                private ContextBase getKey(RowValue row) {
                    ContextBase col = null;
                    for (int inx = this.mCurrRowsets.length - 1; inx < row.getNumColumns() && ((col = (ContextBase)((Object)row.getColumn(inx))).getRowset() == null || col.getRowset().getRowsetId() != this.mSuppressRowRule.getSourceRowsetId()); ++inx) {
                    }
                    return col;
                }

                private ContextBase getContext(RowValue row) {
                    ContextBase col = null;
                    for (int inx = 0; inx < row.getNumColumns() && ((col = (ContextBase)((Object)row.getColumn(inx))).getRowset() == null || col.getRowset().getRowsetId() != this.mSuppressRowRule.getContextRowsetId()); ++inx) {
                    }
                    return col;
                }

                private boolean isBreakRow(RowValue currRow, RowValue lastRow) {
                    for (int inx = 0; inx < this.mCurrRowsets.length - 1; ++inx) {
                        if (this.compareMember((ContextBase)((Object)currRow.getColumn(inx)), (ContextBase)((Object)lastRow.getColumn(inx)))) continue;
                        return true;
                    }
                    return false;
                }

                private boolean compareMember(ContextBase currCol, ContextBase lastCol) {
                    if (currCol.contextIsAMember() && lastCol.contextIsAMember()) {
                        IMember iMemb1 = ((ContextMember)currCol).getMember();
                        IMember iMemb2 = ((ContextMember)lastCol).getMember();
                        if (iMemb1 == null && iMemb2 == null) {
                            return true;
                        }
                        if (iMemb1 == null || iMemb2 == null) {
                            return false;
                        }
                        return iMemb1.getUniqueName().equals(iMemb2.getUniqueName());
                    }
                    if (currCol.contextIsAValue() && lastCol.contextIsAValue()) {
                        ContextValue val1 = (ContextValue)currCol;
                        ContextValue val2 = (ContextValue)lastCol;
                        return val1.compareTo(val2) == 0;
                    }
                    return false;
                }

                private void updateOrder(long start, long rowsSuppressed) {
                    long first = (int)(start + rowsSuppressed);
                    int size = (int)(XV5SuppressRowEdge.this.mUpdatedNumRows - first);
                    if (size > 0) {
                        System.arraycopy(XV5SuppressRowEdge.this.mOrder, (int)first, XV5SuppressRowEdge.this.mOrder, (int)start, size);
                    }
                    XV5SuppressRowEdge.this.mUpdatedNumRows = XV5SuppressRowEdge.this.mUpdatedNumRows - rowsSuppressed;
                }
            }
        }
    }
}

