/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5.cellupdate;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.v5.cellupdate.XV5CellSpec;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;

public abstract class AbstractXV5CellUpdateRule {
    private XV5CellSpec primaryCellSpec = null;
    private List<XV5CellSpec> intersectingCellSpecList = new ArrayList<XV5CellSpec>();

    AbstractXV5CellUpdateRule() {
    }

    public AbstractXV5CellUpdateRule(XV5CellSpec cellSpec) {
        this.primaryCellSpec = cellSpec;
    }

    public XV5CellSpec getPrimaryCellSpec() {
        return this.primaryCellSpec;
    }

    void setPrimaryCellSpec(XV5CellSpec cellSpec) {
        this.primaryCellSpec = cellSpec;
    }

    public List<XV5CellSpec> getIntersectingCellSpecList() {
        return this.intersectingCellSpecList;
    }

    public void addIntersectingCellSpec(XV5CellSpec cellSpec) {
        this.intersectingCellSpecList.add(cellSpec);
    }

    public void addIntersectingCellSpec(List<XV5CellSpec> cellSpecs) {
        this.intersectingCellSpecList.addAll(cellSpecs);
    }

    public void acceptRow(RowValue aRow, long rowIndex, HashMap<XV5CellSpec, ArrayList<Long>> cellSpecToRowIndexMap) {
        if (this.getPrimaryCellSpec().acceptRow(aRow.getColumns())) {
            this.mapAcceptedCellSpec(this.getPrimaryCellSpec(), rowIndex, cellSpecToRowIndexMap);
        }
        for (XV5CellSpec anIntersectingSpec : this.getIntersectingCellSpecList()) {
            if (!anIntersectingSpec.acceptRow(aRow.getColumns())) continue;
            this.mapAcceptedCellSpec(anIntersectingSpec, rowIndex, cellSpecToRowIndexMap);
        }
    }

    private void mapAcceptedCellSpec(XV5CellSpec acceptedCellSpec, long rowIndex, HashMap<XV5CellSpec, ArrayList<Long>> cellSpecToRowIndexMap) {
        ArrayList<Long> rowIndexList = cellSpecToRowIndexMap.get(acceptedCellSpec);
        if (rowIndexList == null) {
            rowIndexList = new ArrayList();
            cellSpecToRowIndexMap.put(acceptedCellSpec, rowIndexList);
        }
        rowIndexList.add(new Long(rowIndex));
    }

    public String getRuleName() {
        return "XCellUpdateRule";
    }

    public boolean isMatchingRule(long[] rowIndex, List<Long>[] rowIndexSetOnEdge) {
        if (rowIndexSetOnEdge == null || rowIndexSetOnEdge.length != rowIndex.length) {
            return false;
        }
        for (int i = 0; i < rowIndex.length; ++i) {
            long anOrdinal = rowIndex[i];
            if (rowIndexSetOnEdge[i] == null || rowIndexSetOnEdge[i].contains(anOrdinal)) continue;
            return false;
        }
        return true;
    }

    public boolean isMatchingRule(IValue column) {
        return this.getPrimaryCellSpec().acceptRow(new IValue[]{column});
    }

    public boolean apply(ICell cell) {
        return false;
    }

    public boolean apply(IValue column) {
        return false;
    }

    public void capture(PlanningEnvironment env, Element inputNode) {
        List xcellSpecList = inputNode.elements();
        ListIterator itSpec = xcellSpecList.listIterator();
        while (itSpec.hasNext()) {
            Element anElement = (Element)itSpec.next();
            if ("XPrimaryCellSpec".equals(anElement.getName())) {
                XV5CellSpec newPrimaryCellSpec = new XV5CellSpec();
                newPrimaryCellSpec.capture(env, anElement);
                this.setPrimaryCellSpec(newPrimaryCellSpec);
                continue;
            }
            if (!"XIntersectingCellSpecs".equals(anElement.getName())) continue;
            List xintersectingCellSpecList = anElement.elements("XCellSpec");
            ListIterator itIntersectingSpec = xintersectingCellSpecList.listIterator();
            while (itIntersectingSpec.hasNext()) {
                Element intersectingSpec = (Element)itIntersectingSpec.next();
                XV5CellSpec intersectingCellSpec = new XV5CellSpec();
                intersectingCellSpec.capture(env, intersectingSpec);
                this.addIntersectingCellSpec(intersectingCellSpec);
            }
        }
    }

    public void dump(XQETrace trace) {
        trace.beginElement(this.getRuleName(), -1);
        XV5CellSpec aCellSpec2 = this.getPrimaryCellSpec();
        trace.beginElement("XPrimaryCellSpec", -1);
        aCellSpec2.dumpAdditionalAttributes(trace);
        trace.endElement(-1);
        trace.beginElement("XIntersectingCellSpecs", -1);
        for (XV5CellSpec aCellSpec2 : this.getIntersectingCellSpecList()) {
            trace.beginElement("XCellSpec", -1);
            aCellSpec2.dumpAdditionalAttributes(trace);
            trace.endElement(-1);
        }
        trace.endElement(-1);
        this.dumpAdditionalElements(trace);
        trace.endElement(-1);
    }

    protected void dumpAdditionalElements(XQETrace trace) {
    }
}

