/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5.cellupdate;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.v5.cellupdate.AbstractXV5CellUpdate;
import com.cognos.xqe.runtree.v5.cellupdate.AbstractXV5CellUpdateResultSet;
import com.cognos.xqe.runtree.v5.cellupdate.AbstractXV5CellUpdateRule;
import com.cognos.xqe.runtree.v5.cellupdate.XV5CellSpec;
import com.cognos.xqe.runtree.v5.cellupdate.XV5CellUpdate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XV5CellUpdateResultSet
extends AbstractXV5CellUpdateResultSet {
    private long[] lastRowIndices = null;

    public XV5CellUpdateResultSet(XDataContext context, XNode node, IV5ResultSet sourceResult) {
        super(context, node, sourceResult);
        try {
            RSAPIDataset rsapiDataset = (RSAPIDataset)this.mNode.getAncestorOfType(401005);
            RSAPIEdge[] edges = rsapiDataset.getEdges();
            int numEdges = edges.length;
            this.edgeSizes = new long[edges.length];
            this.lastRowIndices = new long[edges.length];
            for (int edgeNum = 0; edgeNum < numEdges; ++edgeNum) {
                this.lastRowIndices[edgeNum] = -1L;
                long edgeSize = -1L;
                if (edgeNum < numEdges - 1) {
                    edgeSize = sourceResult.getV5EdgeSize(edges[edgeNum]);
                }
                this.edgeSizes[edgeNum] = edgeSize;
            }
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    @Override
    public ICell processV5Cell(ICell cell) {
        this.checkForCellUpdates(cell);
        return cell;
    }

    @Override
    public RowValue processV5Row(RSAPIEdge edge, long iRow, RowValue rowValue) {
        if (rowValue != null && !edge.getDataset().isCrossTabReport()) {
            this.checkForRowUpdates(rowValue);
        }
        return rowValue;
    }

    private void checkForRowUpdates(RowValue aRow) {
        if (aRow == null) {
            return;
        }
        for (AbstractXV5CellUpdateRule aRule : ((XV5CellUpdate)this.mNode).cellUpdateRuleList) {
            IValue[] columns = aRow.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                if (!aRule.isMatchingRule(columns[i])) continue;
                aRule.apply(columns[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForCellUpdates(ICell cell) {
        if (cell == null) {
            return;
        }
        long[] currentRowIndex = this.convertCellOrdinalToRowIndex(cell.getOrdinal());
        HashMap<XV5CellSpec, ArrayList<Long>> cellSpecToRowIndexMapTmp = new HashMap<XV5CellSpec, ArrayList<Long>>();
        RSAPIDataset rsapiDataset = (RSAPIDataset)this.mNode.getAncestorOfType(401005);
        RSAPIEdge[] edges = rsapiDataset.getEdges();
        int numEdges = edges.length;
        for (int edgeNum = 0; edgeNum < numEdges; ++edgeNum) {
            long rowIndex = currentRowIndex[edgeNum];
            if (edges[edgeNum].isEmpty() || rowIndex <= this.lastRowIndices[edgeNum]) continue;
            IScrollableIterator edgeIterator = this.mBaseV5ResultSet.getScrollableV5EdgeIterator(edges[edgeNum]);
            try {
                for (long startingIndex = this.lastRowIndices[edgeNum] + 1L; startingIndex <= rowIndex; ++startingIndex) {
                    edgeIterator.absolute(startingIndex);
                    RowValue aRow = (RowValue)edgeIterator.current();
                    if (aRow == null) continue;
                    ((AbstractXV5CellUpdate)this.mNode).acceptRow(aRow, startingIndex, cellSpecToRowIndexMapTmp);
                }
            }
            finally {
                edgeIterator.release();
            }
            this.lastRowIndices[edgeNum] = rowIndex;
            for (XV5CellSpec aCellSpec : cellSpecToRowIndexMapTmp.keySet()) {
                ArrayList rowIndexList = (ArrayList)this.cellSpecToRowIndexMap.get(aCellSpec);
                if (rowIndexList == null) {
                    this.cellSpecToRowIndexMap.put(aCellSpec, cellSpecToRowIndexMapTmp.get(aCellSpec));
                    continue;
                }
                rowIndexList.addAll((Collection)cellSpecToRowIndexMapTmp.get(aCellSpec));
            }
        }
        Map<AbstractXV5CellUpdateRule, List<Long>[]> ruleToRowIndexListMap = this.buildRuleToRowIndexSetMap(this.cellSpecToRowIndexMap, numEdges);
        for (AbstractXV5CellUpdateRule aRule : ((AbstractXV5CellUpdate)this.mNode).cellUpdateRuleList) {
            if (!aRule.isMatchingRule(currentRowIndex, ruleToRowIndexListMap.get(aRule))) continue;
            aRule.apply(cell);
        }
    }

    protected long[] convertCellOrdinalToRowIndex(long cellOrdinal) {
        long[] currentRowIndex = new long[this.edgeSizes.length];
        for (int edgeIndex = 0; edgeIndex < this.edgeSizes.length - 1; ++edgeIndex) {
            currentRowIndex[edgeIndex] = 0L;
            if (this.edgeSizes[edgeIndex] <= 0L) continue;
            currentRowIndex[edgeIndex] = cellOrdinal % this.edgeSizes[edgeIndex];
            cellOrdinal /= this.edgeSizes[edgeIndex];
        }
        currentRowIndex[this.edgeSizes.length - 1] = cellOrdinal;
        return currentRowIndex;
    }

    @Override
    public long mapV5CellOrdinal(long thisOrdinal) {
        return thisOrdinal;
    }
}

