/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5.edgeupdate;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextMemberWrapper;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.ContextValueWrapper;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedCellIterator;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedEdgeIterator;
import com.cognos.xqe.runtree.v5.edgeupdate.AbstractXV5EdgeUpdate;
import com.cognos.xqe.runtree.v5.edgeupdate.AbstractXV5EdgeUpdateResultSet;
import com.cognos.xqe.runtree.v5.edgeupdate.XEdgeUpdateForResult;
import com.cognos.xqe.runtree.v5.edgeupdate.XEdgeUpdateSpec;
import com.cognos.xqe.runtree.v5.edgeupdate.XSuppressionView;
import com.ibm.cognos.xqe.resultsdk.IPostProcessingFilter;
import java.util.List;

public final class XV5ExternalResultSet
extends AbstractXV5EdgeUpdateResultSet {
    private IPostProcessingFilter mPostProcessingFilter;
    private final String mRequestID;
    protected XEdgeUpdateForResult mEdgeUpdateSpecs;

    XV5ExternalResultSet(XDataContext context, AbstractXV5EdgeUpdate xV5EdgeUpdate, IV5ResultSet sourceResultSet, XEdgeUpdateForResult edgeUpdateSpecs, IPostProcessingFilter postProcessingFilter, String requestID) {
        super(context, xV5EdgeUpdate, sourceResultSet);
        this.mSuppressionView = new XSuppressionView(this.getBaseResultSet(), this.mEdges);
        this.mPostProcessingFilter = postProcessingFilter;
        this.mRequestID = requestID;
        this.mEdgeUpdateSpecs = edgeUpdateSpecs;
    }

    protected void initialize(IV5ResultSet sourceResultSet) {
    }

    @Override
    public void releaseImpl() {
        if (this.mPostProcessingFilter != null) {
            this.mPostProcessingFilter.release(this.mRequestID);
            this.mPostProcessingFilter = null;
        }
        super.releaseImpl();
    }

    @Override
    public XCellIterator getV5CellIterator() {
        return new V5ScrollableMappedCellIterator(this.getDataContext(), this, this.getBaseResultSet().getScrollableV5CellIterator(), this.getId());
    }

    @Override
    public XScrollableCellIterator getScrollableV5CellIterator() {
        return new V5ScrollableMappedCellIterator(this.getDataContext(), this, this.getBaseResultSet().getScrollableV5CellIterator(), this.getId());
    }

    @Override
    public RowValue processV5Row(RSAPIEdge edge, long iRow, RowValue rowValue) {
        List<XEdgeUpdateSpec> rowUpdates;
        int edgeNumber;
        XEdgeUpdateForResult.XEdgeUpdateSpecForEdge edgeUpdates;
        if (rowValue != null && (edgeUpdates = this.mEdgeUpdateSpecs.getSpecsForEdge(edgeNumber = edge.getPositionalOrdinal())) != null && (rowUpdates = edgeUpdates.getSpecsForRow(iRow)) != null) {
            this.updateV5Row(rowValue, rowUpdates);
        }
        return rowValue;
    }

    private void updateV5Row(RowValue rowValue, List<XEdgeUpdateSpec> rowUpdates) {
        for (XEdgeUpdateSpec updateSpec : rowUpdates) {
            int columnIndex;
            if (updateSpec == null) continue;
            ContextBase column = null;
            IValue[] columns = rowValue.getColumns();
            for (columnIndex = 0; columnIndex < columns.length; ++columnIndex) {
                ContextBase rowColumn = (ContextBase)((Object)columns[columnIndex]);
                if (rowColumn.getRowset() == null || rowColumn.getRowset().getRowsetId() != updateSpec.getRowsetId() || rowColumn.getDataItemIndex() != updateSpec.getDataItemIndex()) continue;
                column = rowColumn;
                break;
            }
            if (column == null) {
                boolean gbmFound = false;
                block2: for (int i = 0; i < columns.length && !gbmFound; ++i) {
                    ContextBase rowColumn = (ContextBase)((Object)columns[i]);
                    if (!rowColumn.contextIsAMember() || !((ContextMember)rowColumn).hasGroupBodyMeasures()) continue;
                    ContextMember contextMember = (ContextMember)rowColumn;
                    for (ContextValue gbmValue : contextMember.getGroupBodyMeasures()) {
                        if (gbmValue.getRowset() == null || gbmValue.getRowset().getRowsetId() != updateSpec.getRowsetId() || gbmValue.getDataItemIndex() != updateSpec.getDataItemIndex()) continue;
                        ContextValueWrapper valueWrapper = null;
                        if (gbmValue instanceof ContextValueWrapper) {
                            valueWrapper = (ContextValueWrapper)gbmValue;
                        } else {
                            ContextValue contextValue = gbmValue;
                            valueWrapper = new ContextValueWrapper(contextValue);
                        }
                        contextMember.addValueOfGroupBodyMeasure(valueWrapper);
                        valueWrapper.updateV5Row(updateSpec);
                        gbmFound = true;
                        continue block2;
                    }
                }
                continue;
            }
            if (column.contextIsAMember()) {
                ContextMemberWrapper wrapper = null;
                if (column instanceof ContextMemberWrapper) {
                    wrapper = (ContextMemberWrapper)column;
                } else {
                    ContextMember contextMember = (ContextMember)column;
                    wrapper = new ContextMemberWrapper(contextMember);
                    rowValue.setColumn(columnIndex, wrapper);
                }
                wrapper.updateV5Row(updateSpec);
            }
            if (!column.contextIsAValue()) continue;
            ContextValueWrapper valueWrapper = null;
            if (column instanceof ContextValueWrapper) {
                valueWrapper = (ContextValueWrapper)column;
            } else {
                ContextValue contextValue = (ContextValue)column;
                valueWrapper = new ContextValueWrapper(contextValue);
                rowValue.setColumn(columnIndex, valueWrapper);
            }
            valueWrapper.updateV5Row(updateSpec);
        }
    }

    @Override
    public XIterator getV5EdgeIterator(RSAPIEdge edge) {
        int edgeNum = edge.getPositionalOrdinal();
        if (this.mSuppressedEdges[edgeNum] != null || this.mEdgeUpdateSpecs.getSpecsForEdge(edgeNum) != null) {
            return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), this.getId());
        }
        return this.getBaseResultSet().getV5EdgeIterator(edge);
    }

    @Override
    public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
        int edgeNum = edge.getPositionalOrdinal();
        if (this.mSuppressedEdges[edgeNum] != null || this.mEdgeUpdateSpecs.getSpecsForEdge(edgeNum) != null) {
            return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), this.getId());
        }
        return this.getBaseResultSet().getScrollableV5EdgeIterator(edge);
    }
}

