/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace;

import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.query.engine.TransformationLibraryManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceLogWriter;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.V5SpecificationGeneration;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public final class TraceLogManager {
    private static final String UTF_8 = "UTF-8";
    private static final String CONTROL_REPLACE = "_";
    private static final String SUBQUERY_NAME_JOIN = "-";
    private static final TraceLogManager INSTANCE = new TraceLogManager();
    private static final int BUFFER_SIZE = 16384;
    private static final int MAX_REPORT_NAME_LENGTH = 60;
    private static final String UNKNOWN = "UNKNOWN";
    private static final String LOG_VERSION = "1.2.0.v10.1";
    private static final String V5SPEC_FILENAME = "aSubquerySpecification.xml";
    private Map<String, File> directoryMap = Collections.synchronizedMap(new WeakHashMap());
    private ConcurrentMap<String, Manifest> manifestMap = new ConcurrentHashMap<String, Manifest>();

    public static TraceLogManager getInstance() {
        return INSTANCE;
    }

    private TraceLogManager() {
    }

    public Writer createPlanningTraceWriter(IRequestEnvironment reqEnv) {
        return this.createTraceOutputWriter(reqEnv, QueryEngineLoggingUtils.isPlanningTraceEnabled(reqEnv), "planningLog.xml");
    }

    public Writer createSubqueryTraceWriter(IRequestEnvironment reqEnv) {
        return this.createTraceOutputWriter(reqEnv, QueryEngineLoggingUtils.isLogV5SubquerySpecificationGenerationTraceEnabled(reqEnv.getExecutionEnvironment().getMultiRequestContext()), V5SPEC_FILENAME);
    }

    private String getSafeRequestID(IRequestEnvironment reqEnv) {
        String requestId = reqEnv.getRequestID();
        if (requestId != null) {
            return requestId;
        }
        return UNKNOWN;
    }

    public Writer createPlanningPassTraceWriter(IRequestEnvironment reqEnv, int passNumber) {
        Formatter formatter = new Formatter();
        formatter.format("planningLog_pass_%03d.xml", passNumber);
        return this.createTraceOutputWriter(reqEnv, QueryEngineLoggingUtils.isPlanningTraceEnabled(reqEnv), formatter.toString());
    }

    public Writer createRuntreeTraceWriter(IRequestEnvironment reqEnv) {
        return this.createTraceOutputWriter(reqEnv, QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv), "runtreeLog.xml");
    }

    public Writer createExecutionTraceWriter(IRequestEnvironment reqEnv) {
        return this.createTraceOutputWriter(reqEnv, QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv), "executionLog.xml");
    }

    public String createJDBCTraceWriter(IRequestEnvironment reqEnv) {
        return this.createJDBCTraceFileName(reqEnv, QueryEngineLoggingUtils.isJDBCTraceEnabled(), "JDBCLog.txt");
    }

    public OutputStream createProfilingTraceOutputStream(IRequestEnvironment reqEnv) {
        return this.createNextProfilingOutputStream(reqEnv, "profilingLog-");
    }

    private OutputStream createNextProfilingOutputStream(IRequestEnvironment reqEnv, String prefix) {
        if (!QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv)) {
            return null;
        }
        File logDir = this.getLogDirectory(reqEnv);
        File logFile = null;
        StringBuilder sBuffer = new StringBuilder();
        int idx = 0;
        do {
            sBuffer.setLength(0);
            sBuffer.append(prefix);
            sBuffer.append(idx++);
            sBuffer.append(".xml");
        } while ((logFile = new File(logDir, sBuffer.toString())).exists());
        try {
            return new BufferedOutputStream(new FileOutputStream(logFile));
        }
        catch (FileNotFoundException e) {
            throw new XQERuntimeException(e);
        }
    }

    public void packageTraceOutput(IRequestEnvironment reqEnv) {
        String subRequestId;
        if (!QueryEngineLoggingUtils.isTracingEnabled(reqEnv)) {
            return;
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (!configuration.getBooleanProperty("general.compressTraceLogs", false)) {
            return;
        }
        String requestId = this.getSafeRequestID(reqEnv);
        if (TraceLogManager.isSubRequest(requestId, subRequestId = reqEnv.getSubRequestID())) {
            return;
        }
        if (this.directoryMap.get(requestId = this.getKey(reqEnv, requestId)) == null) {
            throw new XQERuntimeException();
        }
        File logDir = this.getLogDirectory(reqEnv);
        String logArchiveName = logDir.getPath() + ".xql";
        try {
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(logArchiveName)));
            this.addDirectory(zos, logDir, logDir.getName());
            zos.close();
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        this.deleteDirectory(logDir);
    }

    private String getKey(IRequestEnvironment reqEnv, String requestId) {
        String operationName = reqEnv.getOperationName();
        if (operationName == null) {
            return requestId;
        }
        if (operationName.equals("Metadata")) {
            requestId = requestId + operationName;
        }
        if (operationName.equals("getParameters")) {
            requestId = requestId + operationName;
        }
        return requestId;
    }

    public static boolean isSubRequest(String requestId, String subRequestId) {
        return subRequestId != null && !requestId.equals(subRequestId) && requestId.indexOf(subRequestId) != 0;
    }

    private void deleteDirectory(File dir) {
        File[] files;
        if (!dir.exists()) {
            return;
        }
        for (File f : files = dir.listFiles()) {
            if (f.isDirectory()) {
                this.deleteDirectory(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    private void addDirectory(ZipOutputStream zos, File dir, String baseDirName) {
        File[] files;
        if (!dir.isDirectory()) {
            return;
        }
        byte[] buf = new byte[16384];
        for (File f : files = dir.listFiles()) {
            StringBuilder sb = new StringBuilder(baseDirName);
            sb.append(File.separatorChar);
            sb.append(f.getName());
            if (f.isDirectory()) {
                this.addDirectory(zos, f, sb.toString());
                continue;
            }
            try {
                int len;
                zos.putNextEntry(new ZipEntry(sb.toString()));
                FileInputStream fis = new FileInputStream(f);
                while ((len = fis.read(buf)) > 0) {
                    zos.write(buf, 0, len);
                }
                fis.close();
                zos.closeEntry();
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        }
    }

    public File getLogDirectory(IRequestEnvironment reqEnv) {
        String requestId = this.getSafeRequestID(reqEnv);
        String subRequestId = reqEnv.getSubRequestID();
        boolean isSubRequest = TraceLogManager.isSubRequest(requestId, subRequestId);
        StringBuilder sb = new StringBuilder();
        File dir = null;
        String key = requestId;
        if (isSubRequest) {
            key = subRequestId;
        }
        if ((dir = this.directoryMap.get(key = this.getKey(reqEnv, key))) != null) {
            return dir;
        }
        File fd = null;
        if (isSubRequest) {
            key = this.getKey(reqEnv, requestId);
            dir = this.directoryMap.get(key);
            if (dir == null && (dir = this.createRequestDirectory(reqEnv)) == null) {
                throw new XQERuntimeException();
            }
            sb.append("subqueries");
            sb.append(File.separatorChar);
            key = this.getKey(reqEnv, subRequestId);
            String subDirectoryName = this.createSubqueryDirectoryName(key, reqEnv);
            fd = this.createDirectory(dir, subDirectoryName, sb.toString(), reqEnv);
        } else {
            fd = this.createRequestDirectory(reqEnv);
        }
        return fd;
    }

    private File createRequestDirectory(IRequestEnvironment reqEnv) {
        String key = this.getKey(reqEnv, this.getSafeRequestID(reqEnv));
        StringBuilder sb = new StringBuilder();
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        sb.append(configuration.getXqeLogsDirectory());
        if (reqEnv.getCubeName() != null) {
            sb.append(File.separatorChar);
            sb.append("Cube_");
            sb.append(reqEnv.getCubeName());
        }
        sb.append(File.separatorChar);
        return this.createDirectory(null, key, sb.toString(), reqEnv);
    }

    public static void appendTimestamp(StringBuilder sb) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH'h'mm'm'SS's'");
        Date d = new Date();
        sb.append(dateFormat.format(d));
    }

    private File createDirectory(File baseDir, String key, String path, IRequestEnvironment reqEnv) {
        StringBuilder sb = new StringBuilder();
        if (baseDir == null) {
            String suffixName;
            TraceLogManager.appendTimestamp(sb);
            boolean isMetadata = false;
            String operationName = reqEnv.getOperationName();
            if (operationName != null) {
                isMetadata = operationName.equals("Metadata");
            }
            if (isMetadata) {
                sb.append(CONTROL_REPLACE);
                sb.append("Metadata");
            }
            if ((suffixName = reqEnv.getReportName()) == "unknown") {
                suffixName = reqEnv.getPackageName();
            }
            if (suffixName != null) {
                sb.append(CONTROL_REPLACE);
                if (suffixName.length() > 60) {
                    sb.append(TraceLogManager.escapeName(suffixName.substring(0, 60)));
                } else {
                    sb.append(TraceLogManager.escapeName(suffixName));
                }
            }
        } else {
            sb.append(TraceLogManager.escapeName(key));
        }
        File dir = null;
        if (baseDir != null) {
            dir = new File(baseDir, path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            dir = new File(dir, sb.toString());
        } else {
            dir = new File(path, sb.toString());
        }
        dir.mkdirs();
        this.directoryMap.put(key, dir);
        this.getOrCreateManifest(key, true);
        return dir;
    }

    private void writeElementWithUnknown(Element root, String tag, String value) {
        Element reportElement = root.addElement(tag);
        if (value == null) {
            reportElement.setText(UNKNOWN);
        } else {
            reportElement.setText(value);
        }
    }

    public static String escapeName(String name) {
        String newName;
        try {
            newName = URLEncoder.encode(name, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            XQELog.logConsole(e.getLocalizedMessage(), LogLevel.WARN);
            newName = name;
        }
        newName = newName.replaceAll("[&\\\\/<>\\?\\s\\*:]", CONTROL_REPLACE).replace("\"", CONTROL_REPLACE).replace("%", CONTROL_REPLACE);
        if (newName.length() > 60) {
            return newName.substring(0, 60);
        }
        return newName;
    }

    private Writer createTraceOutputWriter(IRequestEnvironment reqEnv, boolean isTracing, String logFileName) {
        if (isTracing) {
            File logDir = this.getLogDirectory(reqEnv);
            File logFile = new File(logDir, logFileName);
            return new TraceLogWriter(logFile);
        }
        return null;
    }

    private String createJDBCTraceFileName(IRequestEnvironment reqEnv, boolean isTracing, String logFileName) {
        if (isTracing) {
            File logDir = this.getLogDirectory(reqEnv);
            File logFile = new File(logDir, logFileName);
            return logFile.getAbsolutePath();
        }
        return null;
    }

    public void setSubqueryInfo(IRequestEnvironment reqEnv, String subqueryType, String subqueryName) {
        this.setManifestProperty(reqEnv, "subqueryName", subqueryName);
        this.setManifestProperty(reqEnv, "subqueryType", subqueryType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeTrace(IRequestEnvironment reqEnv) {
        File dir = this.getLogDirectory(reqEnv);
        if (dir == null) {
            throw new XQERuntimeException();
        }
        File manifestFile = new File(dir, "manifest.xml");
        if (!manifestFile.exists()) {
            String key = this.getKey(reqEnv, this.getSafeRequestID(reqEnv));
            if (TraceLogManager.isSubRequest(this.getSafeRequestID(reqEnv), reqEnv.getSubRequestID())) {
                key = this.getKey(reqEnv, reqEnv.getSubRequestID());
            }
            if (key == null) {
                throw new XQERuntimeException();
            }
            Manifest m = this.getOrCreateManifest(key, false);
            if (m == null) {
                throw new XQERuntimeException();
            }
            try {
                m.dumpFile(reqEnv, manifestFile);
            }
            finally {
                this.removeManifest(key);
            }
        }
    }

    public void setManifestProperty(IRequestEnvironment requestEnvironment, String propertyName, String propertyValue) {
        if (!this.isValidEnvironment(requestEnvironment)) {
            return;
        }
        this.getManifest(requestEnvironment).setProperty(propertyName, propertyValue);
    }

    private Manifest getManifest(IRequestEnvironment requestEnvironment) {
        String requestEnvironmentId = this.getKey(requestEnvironment, this.getSafeRequestID(requestEnvironment));
        if (TraceLogManager.isSubRequest(this.getSafeRequestID(requestEnvironment), requestEnvironment.getSubRequestID())) {
            requestEnvironmentId = this.getKey(requestEnvironment, requestEnvironment.getSubRequestID());
        }
        return this.getOrCreateManifest(requestEnvironmentId, true);
    }

    private Manifest getOrCreateManifest(String id, boolean create) {
        if (create) {
            Manifest manifest = new Manifest();
            Manifest current = this.manifestMap.putIfAbsent(id, manifest);
            if (current == null) {
                return manifest;
            }
            return current;
        }
        return (Manifest)this.manifestMap.get(id);
    }

    private void removeManifest(String key) {
        this.manifestMap.remove(key);
    }

    public void logQueryHint(IRequestEnvironment requestEnvironment, String hint, Object value) {
        if (!this.isValidEnvironment(requestEnvironment)) {
            return;
        }
        this.getManifest(requestEnvironment).addQueryHint(hint, value);
    }

    private boolean isValidEnvironment(IRequestEnvironment requestEnvironment) {
        if (requestEnvironment == null) {
            return false;
        }
        if (requestEnvironment.getRequestID() == null) {
            return false;
        }
        return QueryEngineLoggingUtils.isTracingEnabled(requestEnvironment);
    }

    public void logV5QuerySet(V5QuerySet querySet, IRequestEnvironment reqEnv) {
        Writer logWriter = null;
        logWriter = this.createSubqueryTraceWriter(reqEnv);
        if (logWriter == null) {
            return;
        }
        V5SpecificationGeneration visitor = new V5SpecificationGeneration();
        visitor.visit(querySet);
        String output = visitor.dumpToString();
        try {
            logWriter.write(output);
            logWriter.close();
        }
        catch (IOException e) {
            return;
        }
        Manifest manifest = this.getManifest(reqEnv);
        manifest.setProperty("v5Spec", V5SPEC_FILENAME);
    }

    private String createSubqueryDirectoryName(String key, IRequestEnvironment reqEnv) {
        String metadata;
        StringBuilder sb = new StringBuilder();
        String type = this.getManifest(reqEnv).getProperty("subqueryType");
        if (type != null) {
            sb.append(type);
        }
        if ((metadata = this.getManifest(reqEnv).getProperty("subqueryName")) != null) {
            int overflow = metadata.length() + type.length() - 60;
            if (overflow > 0) {
                metadata = metadata.substring(overflow);
            }
            sb.append(SUBQUERY_NAME_JOIN);
            sb.append(metadata);
        }
        if (sb.length() > 0) {
            sb.append(SUBQUERY_NAME_JOIN);
        }
        sb.append(key);
        return TraceLogManager.escapeName(sb.toString());
    }

    public static String formatMemberNames(List<IMember> members) {
        if (members.size() == 1) {
            return members.get(0).getUniqueName();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < members.size() - 1; ++i) {
            IMember member = members.get(i);
            sb.append(member.getName());
            sb.append(CONTROL_REPLACE);
        }
        sb.append(members.get(members.size() - 1).getName());
        return sb.toString();
    }

    private class Manifest {
        private static final int MAX_CHAR = 127;
        public static final String SUBQUERY_TYPE = "subqueryType";
        public static final String SUBQUERY_NAME = "subqueryName";
        public static final String V5SPEC = "v5Spec";
        private Map<String, String> properties = new HashMap<String, String>();
        private Map<V5Query.QueryHint, Object> hints = new HashMap<V5Query.QueryHint, Object>();

        private Manifest() {
        }

        void dumpFile(IRequestEnvironment reqEnv, File logFileManifest) {
            Document document = this.createManifestDocument(reqEnv);
            OutputStreamWriter writer = null;
            try {
                XMLWriter xmlWriter = new XMLWriter();
                StringWriter strWriter = new StringWriter();
                xmlWriter.setWriter((Writer)strWriter);
                xmlWriter.setMaximumAllowedCharacter(127);
                xmlWriter.write(document);
                writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(logFileManifest)), TraceLogManager.UTF_8);
                writer.append(strWriter.toString());
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        throw new XQERuntimeException(e);
                    }
                }
            }
        }

        private Document createManifestDocument(IRequestEnvironment reqEnv) {
            Element subqueryNameMemento;
            Element subqueryMememto;
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement("xqetraceInfo");
            Element date = root.addElement("date");
            date.setText(DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(new Date()));
            TraceLogManager.this.writeElementWithUnknown(root, "reportName", reqEnv.getReportName());
            TraceLogManager.this.writeElementWithUnknown(root, "reportPath", reqEnv.getReportPath());
            TraceLogManager.this.writeElementWithUnknown(root, "packageName", reqEnv.getPackageName());
            TraceLogManager.this.writeElementWithUnknown(root, "modelPath", reqEnv.getModelPath());
            Element logVersion = root.addElement("logVersion");
            logVersion.setText(TraceLogManager.LOG_VERSION);
            TraceLogManager.this.writeElementWithUnknown(root, "requestId", reqEnv.getRequestID());
            if (reqEnv.getOperationName() != null) {
                TraceLogManager.this.writeElementWithUnknown(root, "operationName", reqEnv.getOperationName());
            }
            if (reqEnv.getSubRequestID() != null) {
                TraceLogManager.this.writeElementWithUnknown(root, "subRequestId", reqEnv.getSubRequestID());
            }
            TraceLogManager.this.writeElementWithUnknown(root, "version", QueryEngineLoggingUtils.class.getPackage().getImplementationVersion());
            Element numberPasses = root.addElement("expectedNumberOfPasses");
            numberPasses.setText(String.valueOf(TransformationLibraryManager.getInstance().getMaximumPassNumber()));
            if (!this.properties.isEmpty()) {
                subqueryMememto = root.addElement("properties");
                for (String propertyName : this.properties.keySet()) {
                    subqueryNameMemento = subqueryMememto.addElement(propertyName);
                    subqueryNameMemento.setText(this.properties.get(propertyName));
                }
            }
            if (!this.hints.isEmpty()) {
                subqueryMememto = root.addElement("queryHints");
                for (V5Query.QueryHint hint : this.hints.keySet()) {
                    subqueryNameMemento = subqueryMememto.addElement("queryHint");
                    subqueryNameMemento.addElement("name", hint.getPropertyName());
                    Object value = this.hints.get((Object)hint);
                    if (value == null) continue;
                    subqueryNameMemento.addElement("value", value.toString());
                }
            }
            return document;
        }

        void setProperty(String propertyName, String propertyValue) {
            this.properties.put(propertyName, propertyValue);
        }

        String getProperty(String propertyName) {
            return this.properties.get(propertyName);
        }

        public void addQueryHint(V5Query.QueryHint hint, Object value) {
            if (value == null && this.hints.containsKey((Object)hint)) {
                return;
            }
            this.hints.put(hint, value);
        }

        public void addQueryHint(String hint, Object value) {
            for (V5Query.QueryHint queryHint : V5Query.QueryHint.values()) {
                if (!queryHint.getPropertyName().equals(hint)) continue;
                this.addQueryHint(queryHint, value);
                return;
            }
        }
    }
}

