/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.appender.XQELogAppender;
import com.cognos.xqe.trace.logger.XQELoggerImpl;
import com.cognos.xqe.trace.message.InputStreamMessage;
import com.cognos.xqe.trace.message.LocalizedMessage;
import com.cognos.xqe.trace.message.LogMessage;
import com.cognos.xqe.trace.message.StringMessage;
import com.cognos.xqe.trace.message.ThrowableMessage;
import com.cognos.xqe.trace.message.XmlMessage;
import java.io.InputStream;
import org.dom4j.Node;

public class XQELogger {
    private XQELoggerImpl impl;
    private LogLevel defaultLevel;

    public XQELogger(XQELoggerImpl logger) {
        this.impl = logger;
        this.defaultLevel = this.impl.getDefaultLevel();
    }

    private void checkLoggerImpl() {
        if (this.impl.needToReload()) {
            this.impl = XQELog.getLoggerImpl(this.impl.getService(), this.impl.getComponent(), this.impl.getEventGroup(), this.defaultLevel);
        }
    }

    public boolean isOn(LogLevel aLogLevel) {
        this.checkLoggerImpl();
        return this.impl.isOn(aLogLevel);
    }

    public boolean isOn() {
        this.checkLoggerImpl();
        return this.impl.isOn();
    }

    public boolean isOnIgnoreSLF4JLogger(LogLevel aLogLevel) {
        this.checkLoggerImpl();
        boolean useOverride = true;
        boolean considerSlf4jLogger = false;
        return this.impl.isOn(aLogLevel, useOverride, considerSlf4jLogger);
    }

    public void log(LogLevel aLogLevel, String message) {
        this.log(aLogLevel, OperationEnum.DEFAULT, message);
    }

    public void log(String message) {
        this.log(this.defaultLevel, OperationEnum.DEFAULT, message);
    }

    public void log(LogLevel aLogLevel, OperationEnum anOp, String message) {
        this.log(aLogLevel, anOp, new StringMessage(message));
    }

    public void log(LogLevel aLogLevel, OperationEnum anOp, String message, long duration) {
        this.log(aLogLevel, anOp, new StringMessage(message), "", duration);
    }

    public void log(LogLevel aLogLevel, OperationEnum anOp, IMessageKey.Param0 key) {
        this.log(aLogLevel, anOp, new LocalizedMessage(key));
    }

    public void log(LogLevel aLogLevel, OperationEnum anOp, IMessageKey.Param1 key, String arg1) {
        this.log(aLogLevel, anOp, new LocalizedMessage(key, arg1));
    }

    public void log(LogLevel aLogLevel, OperationEnum anOp, IMessageKey.Param2 key, String arg1, String arg2) {
        this.log(aLogLevel, anOp, new LocalizedMessage(key, arg1, arg2));
    }

    public void log(LogLevel aLogLevel, OperationEnum anOp, IMessageKey.Param3 key, String arg1, String arg2, String arg3) {
        this.log(aLogLevel, anOp, new LocalizedMessage(key, arg1, arg2, arg3));
    }

    public void log(OperationEnum anOp, String message) {
        this.log(this.defaultLevel, anOp, message);
    }

    public void log(LogLevel aLogLevel, Node xmlDoc) {
        this.log(aLogLevel, OperationEnum.DEFAULT, xmlDoc);
    }

    public void log(LogLevel aLogLevel, Node xmlDoc, String fileName) {
        this.log(aLogLevel, OperationEnum.DEFAULT, xmlDoc, fileName);
    }

    public void log(Node xmlDoc) {
        this.log(this.defaultLevel, OperationEnum.DEFAULT, xmlDoc);
    }

    public void log(Node xmlDoc, String fileName) {
        this.log(this.defaultLevel, OperationEnum.DEFAULT, xmlDoc, fileName);
    }

    public void log(LogLevel aLogLevel, OperationEnum anOp, Node xmlDoc) {
        this.log(aLogLevel, anOp, new XmlMessage(xmlDoc));
    }

    public void log(LogLevel aLogLevel, OperationEnum anOp, Node xmlDoc, String fileName) {
        this.log(aLogLevel, anOp, new XmlMessage(xmlDoc), fileName, -1L);
    }

    public void log(OperationEnum anOp, Node xmlDoc) {
        this.log(this.defaultLevel, anOp, xmlDoc);
    }

    public void log(OperationEnum anOp, Node xmlDoc, String fileName) {
        this.log(this.defaultLevel, anOp, xmlDoc, fileName);
    }

    public void log(LogLevel aLogLevel, Throwable exception) {
        this.log(aLogLevel, OperationEnum.DEFAULT, exception);
    }

    public void log(Throwable exception) {
        this.log(this.defaultLevel, OperationEnum.DEFAULT, exception);
    }

    public void log(LogLevel aLogLevel, OperationEnum anOp, Throwable exception) {
        this.log(aLogLevel, anOp, new ThrowableMessage(exception));
    }

    public void log(LogLevel aLogLevel, String message, Throwable exception) {
        this.log(aLogLevel, OperationEnum.DEFAULT, message, exception);
    }

    public void log(String message, Throwable exception) {
        this.log(this.defaultLevel, OperationEnum.DEFAULT, message, exception);
    }

    public void log(LogLevel aLogLevel, OperationEnum anOp, String message, Throwable exception) {
        this.log(aLogLevel, anOp, new ThrowableMessage(message, exception));
    }

    public void log(OperationEnum anOp, Throwable exception) {
        this.log(this.defaultLevel, anOp, exception);
    }

    public void log(LogLevel aLogLevel, InputStream stream) {
        this.log(aLogLevel, OperationEnum.DEFAULT, stream);
    }

    public void log(InputStream stream) {
        this.log(this.defaultLevel, OperationEnum.DEFAULT, stream);
    }

    public void log(OperationEnum anOp, InputStream stream) {
        this.log(this.defaultLevel, anOp, stream);
    }

    public void log(LogLevel aLogLevel, OperationEnum anOp, InputStream stream) {
        this.log(aLogLevel, anOp, new InputStreamMessage(stream));
    }

    public void log(int aLogLevel, String message) {
        this.log(LogLevel.valueOf(aLogLevel), OperationEnum.DEFAULT, message);
    }

    public void log(int aLogLevel, int op, String message) {
        this.log(LogLevel.valueOf(aLogLevel), OperationEnum.valueOf(op), message);
    }

    private void log(LogLevel aLogLevel, OperationEnum anOp, LogMessage message) {
        this.log(aLogLevel, anOp, message, "", -1L);
    }

    private void log(LogLevel aLogLevel, OperationEnum anOp, LogMessage message, String fileName, long duration) {
        this.checkLoggerImpl();
        this.impl.log(aLogLevel, anOp, message, fileName, duration);
    }

    public void close() {
    }

    public LogLevel getLogLevel() {
        this.checkLoggerImpl();
        return this.impl.getLogLevel();
    }

    public XQELogAppender getAppender() {
        this.checkLoggerImpl();
        return this.impl.getAppender();
    }

    public void setTestMode(boolean flag) {
        this.impl.setTestMode(flag);
    }

    public String getComponent() {
        this.checkLoggerImpl();
        return this.impl.getComponent();
    }

    public ServiceEnumeration getService() {
        this.checkLoggerImpl();
        return this.impl.getService();
    }

    public String getEventGroup() {
        this.checkLoggerImpl();
        return this.impl.getEventGroup();
    }

    public LogLevel getDefaultLevel() {
        return this.defaultLevel;
    }

    public void log(String fileName, LogLevel aLogLevel, String message) {
        this.log(aLogLevel, OperationEnum.DEFAULT, new StringMessage(message), fileName, -1L);
    }

    public void log(String fileName, String message) {
        this.log(this.defaultLevel, OperationEnum.DEFAULT, new StringMessage(message), fileName, -1L);
    }
}

