/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.appender;

import com.cognos.xqe.trace.LoggingConstants;
import com.cognos.xqe.trace.appender.Parameters;
import com.cognos.xqe.trace.appender.XQELogAppender;
import com.cognos.xqe.trace.logger.LogEvent;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Map;

public class XQEConsoleAppender
extends XQELogAppender {
    private PrintWriter writer = new PrintWriter(System.out, true);
    private static final MessageFormat PREFIX_FORMAT = new MessageFormat(" {0} {1} {2} threadId={3} camSessionId={4} ");

    public XQEConsoleAppender(Parameters param) {
        super(param);
        this.isInitialized = true;
    }

    @Override
    public void addEvent(LogEvent anEvent) {
        try {
            StringBuilder message = new StringBuilder();
            message.append(XQEConsoleAppender.formatEvent(anEvent));
            message.append("\"");
            message.append(anEvent.getLogMessage());
            message.append("\"");
            this.writer.println(message);
        }
        catch (Exception e) {
            e.printStackTrace(this.writer);
        }
    }

    private static String formatEvent(LogEvent event) {
        Object[] prefixArgs = new Object[]{event.getComponent(), event.getEventGroup(), event.getLevel().name(), event.getThreadId(), event.getCAMSessionId()};
        StringBuilder buffer = new StringBuilder();
        buffer.append(LoggingConstants.TIMESTAMP_FORMAT.format((Object)event.getTimestamp()));
        buffer.append(PREFIX_FORMAT.format(prefixArgs));
        Map<String, String> contextAttributes = event.getContextAttributes();
        for (Map.Entry<String, String> entry : contextAttributes.entrySet()) {
            buffer.append(entry.getKey()).append('=').append(entry.getValue()).append(' ');
        }
        return buffer.toString();
    }

    @Override
    public void commit() {
        this.writer.flush();
    }
}

