/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.appender;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogTypedLogger;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.appender.Parameters;
import com.cognos.xqe.trace.appender.XQELogAppender;
import com.cognos.xqe.trace.logger.LogEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class XQEIPFAppender
extends XQELogAppender {
    private static final String FAILED_TO_INITIALIZE_IPF = "Failed to initialize IPF";
    private static final String QUERY_SERVICE = "QueryService";
    private String ipfLoggerPrefix = "Audit.RTUsage";
    private Map<String, LogTypedLogger> loggers = new HashMap<String, LogTypedLogger>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final String AUDIT_PARAM_XML_START = "<parameters><item name=\"";
    private static final String ITEM_END = "\">";
    private static final String AUDIT_PARAM_XML_END = "</item></parameters>";
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final AtomicBoolean INSTANCE_CREATED = new AtomicBoolean(false);

    public XQEIPFAppender(Parameters param) {
        super(param);
        this.ipfLoggerPrefix = param.getString("ipfLoggerPrefix", this.ipfLoggerPrefix);
        try {
            if (!LogIPFControl.initialize()) {
                System.err.println(FAILED_TO_INITIALIZE_IPF);
                return;
            }
            this.isInitialized = true;
            INSTANCE_CREATED.set(true);
        }
        catch (Exception e) {
            System.err.println(FAILED_TO_INITIALIZE_IPF);
            e.printStackTrace();
            this.isInitialized = false;
        }
    }

    @Override
    public void addEvent(LogEvent event) {
        if (this.isInitialized) {
            LogTypedLogger logger = this.getIPFLogger(event.getComponent(), event.getEventGroup());
            int ipfLevel = XQEIPFAppender.toIPFLogLevel(event.getLevel());
            if (logger != null && logger.isEnabled(ipfLevel)) {
                if (ipfLevel >= 30000) {
                    logger.log((Object)XQEIPFAppender.createAuditAccessIndication(event));
                } else {
                    logger.log((Object)XQEIPFAppender.createAuditIndication(event));
                }
            }
        }
    }

    private static LogAuditIndication createAuditIndication(LogEvent event) {
        Map<String, String> contextAttributes = event.getContextAttributes();
        String requestId = contextAttributes.get("requestId");
        LogAuditIndication indication = new LogAuditIndication(event.getComponent(), 0);
        indication.setLevel(XQEIPFAppender.toIPFLogLevel(event.getLevel()));
        indication.setRequestID(requestId);
        indication.setThreadID(String.valueOf(event.getThreadId()));
        indication.setTime(event.getTimestamp());
        indication.setLogData(event.getLogMessage().getMessage());
        indication.setSessionID(event.getCAMSessionId());
        if (event.getOp().getName() != null) {
            indication.setOperation(event.getOp().getName());
        } else {
            indication.setOperation(event.getOp().toString());
        }
        return indication;
    }

    private static LogAuditIndication createAuditAccessIndication(LogEvent event) {
        Map<String, String> contextAttributes = event.getContextAttributes();
        String requestId = contextAttributes.get("requestId");
        String cubeName = contextAttributes.get("rolapCube");
        LogAuditAccessIndication indication = new LogAuditAccessIndication(event.getComponent(), 0);
        indication.setLevel(XQEIPFAppender.toIPFLogLevel(event.getLevel()));
        indication.setRequestID(requestId);
        indication.setThreadID(String.valueOf(event.getThreadId()));
        indication.setTime(event.getTimestamp());
        indication.setLogData(XQEIPFAppender.formatLogDataXML(event.getLogMessage().getMessage(), cubeName));
        indication.setObjectType(QUERY_SERVICE);
        indication.setSessionID(event.getCAMSessionId());
        if (event.getOp().getName() != null) {
            indication.setOperation(event.getOp().getName());
        } else {
            indication.setOperation(event.getOp().toString());
        }
        if (event.getOp().getStatus() != null) {
            indication.setStatus(event.getOp().getStatus());
        }
        if (cubeName != null) {
            indication.setObjectPath(cubeName);
        }
        return indication;
    }

    protected static String formatLogDataXML(String message, String cubeName) {
        StringBuilder sb = new StringBuilder(AUDIT_PARAM_XML_START);
        if (cubeName != null) {
            sb.append("Cube " + cubeName);
        }
        sb.append(ITEM_END);
        sb.append(CDATA_BEGIN);
        sb.append(message);
        sb.append(CDATA_END);
        sb.append(AUDIT_PARAM_XML_END);
        return sb.toString();
    }

    private static int toIPFLogLevel(LogLevel level) {
        switch (level) {
            case TRACE: {
                return 10000;
            }
            case INFO: {
                return 20000;
            }
            case WARN: {
                return 30000;
            }
            case ERROR: {
                return 40000;
            }
            case CRITICAL: {
                return 50000;
            }
            case NONE: {
                return Integer.MAX_VALUE;
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "LogLevel " + level.name() + "is not supported.");
    }

    @Override
    public boolean useAppenderIsOn() {
        return true;
    }

    @Override
    public boolean isOn(String component, String eventGroup, LogLevel level) {
        if (this.isInitialized) {
            LogTypedLogger logger = this.getIPFLogger(component, eventGroup);
            return logger.isEnabled(XQEIPFAppender.toIPFLogLevel(level));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogTypedLogger getIPFLogger(String component, String eventGroup) {
        StringBuilder buffer = new StringBuilder(this.ipfLoggerPrefix);
        buffer.append(".").append(component).append(".").append(eventGroup);
        LogTypedLogger logger = null;
        String key = buffer.toString();
        this.lock.readLock().lock();
        try {
            logger = this.loggers.get(key);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (logger == null) {
            this.lock.writeLock().lock();
            try {
                logger = this.loggers.get(key);
                if (logger == null) {
                    logger = LogTypedLogger.getInstance((String)key, LogAuditIndication.class);
                    this.loggers.put(key, logger);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return logger;
    }

    @Override
    public void commit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<String, LogTypedLogger> map = this.loggers;
        synchronized (map) {
            this.loggers.clear();
            this.isInitialized = false;
        }
    }

    public static boolean instanceCreated() {
        return INSTANCE_CREATED.get();
    }
}

