/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.appender;

import com.cognos.xqe.trace.LoggingConstants;
import com.cognos.xqe.trace.appender.Parameters;
import com.cognos.xqe.trace.appender.XQELogAppender;
import com.cognos.xqe.trace.logger.LogEvent;
import com.cognos.xqe.trace.message.LogMessage;
import com.cognos.xqe.trace.remote.server.RemoteTraceServer;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Map;

public class XQERemoteAppender
extends XQELogAppender {
    private PrintWriter writer = null;
    private static final MessageFormat PREFIX_FORMAT = new MessageFormat(" {0} {1} {2} threadId={3} camSessionId={4} ");

    public XQERemoteAppender(Parameters param) {
        super(param);
        RemoteTraceServer traceServer = RemoteTraceServer.getInstance();
        this.writer = new PrintWriter(traceServer.getOutChannel().getOutputStream(), true);
        this.isInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEvent(LogEvent anEvent) {
        try {
            PrintWriter printWriter = this.writer;
            synchronized (printWriter) {
                LogMessage logMessage = anEvent.getLogMessage();
                this.writer.print(XQERemoteAppender.formatEvent(anEvent) + "\"");
                logMessage.writeMessage(this.writer);
                this.writer.println("\"");
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.writer);
        }
    }

    private static String formatEvent(LogEvent event) {
        Object[] prefixArgs = new Object[]{event.getComponent(), event.getEventGroup(), event.getLevel().name(), event.getThreadId(), event.getCAMSessionId()};
        StringBuilder buffer = new StringBuilder();
        buffer.append(LoggingConstants.TIMESTAMP_FORMAT.format((Object)event.getTimestamp()));
        buffer.append(PREFIX_FORMAT.format(prefixArgs));
        Map<String, String> contextAttributes = event.getContextAttributes();
        for (Map.Entry<String, String> entry : contextAttributes.entrySet()) {
            buffer.append(entry.getKey()).append('=').append(entry.getValue()).append(' ');
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        PrintWriter printWriter = this.writer;
        synchronized (printWriter) {
            this.writer.flush();
        }
    }
}

